/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.spider;

import com.dell.doradus.common.AggregateResult;
import com.dell.doradus.common.ApplicationDefinition;
import com.dell.doradus.common.BatchResult;
import com.dell.doradus.common.DBObject;
import com.dell.doradus.common.DBObjectBatch;
import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.FieldType;
import com.dell.doradus.common.Pair;
import com.dell.doradus.common.RetentionAge;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.common.UNode;
import com.dell.doradus.common.Utils;
import com.dell.doradus.fieldanalyzer.FieldAnalyzer;
import com.dell.doradus.search.SearchResultList;
import com.dell.doradus.search.aggregate.Aggregate;
import com.dell.doradus.service.StorageService;
import com.dell.doradus.service.db.DBService;
import com.dell.doradus.service.db.DColumn;
import com.dell.doradus.service.db.DRow;
import com.dell.doradus.service.db.Tenant;
import com.dell.doradus.service.rest.RESTCommand;
import com.dell.doradus.service.rest.RESTService;
import com.dell.doradus.service.schema.SchemaService;
import com.dell.doradus.service.spider.BatchObjectUpdater;
import com.dell.doradus.service.spider.ObjectQuery;
import com.dell.doradus.service.spider.ShardCache;
import com.dell.doradus.service.spider.SpiderDataAger;
import com.dell.doradus.service.taskmanager.Task;
import com.dell.doradus.service.taskmanager.TaskFrequency;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SpiderService
extends StorageService {
    private static final int MAX_CF_NAME_LENGTH = 48;
    private static final SpiderService INSTANCE = new SpiderService();
    private final ShardCache m_shardCache = new ShardCache();
    private static final List<RESTCommand> REST_RULES = Arrays.asList(new RESTCommand("GET    /{application}/{table}/{ID}                 com.dell.doradus.service.spider.GetObjectCmd"), new RESTCommand("GET    /{application}/{table}/_query?{params}      com.dell.doradus.service.spider.QueryURICmd"), new RESTCommand("GET    /{application}/{table}/_query               com.dell.doradus.service.spider.QueryDocCmd"), new RESTCommand("PUT    /{application}/{table}/_query               com.dell.doradus.service.spider.QueryDocCmd"), new RESTCommand("GET    /{application}/{table}/_aggregate?{params}  com.dell.doradus.service.spider.AggregateURICmd"), new RESTCommand("GET    /{application}/{table}/_aggregate           com.dell.doradus.service.spider.AggregateDocCmd"), new RESTCommand("PUT    /{application}/{table}/_aggregate           com.dell.doradus.service.spider.AggregateDocCmd"), new RESTCommand("POST   /{application}/{table}          com.dell.doradus.service.spider.AddObjectsCmd"), new RESTCommand("PUT    /{application}/{table}          com.dell.doradus.service.spider.UpdateObjectsCmd"), new RESTCommand("DELETE /{application}/{table}          com.dell.doradus.service.spider.DeleteObjectsCmd"));

    public static SpiderService instance() {
        return INSTANCE;
    }

    @Override
    public void initService() {
        RESTService.instance().registerApplicationCommands(REST_RULES, this);
    }

    @Override
    public void startService() {
        SchemaService.instance().waitForFullService();
    }

    @Override
    public void stopService() {
        this.m_shardCache.clearAll();
    }

    @Override
    public void deleteApplication(ApplicationDefinition appDef) {
        this.checkServiceState();
        this.deleteApplicationCFs(appDef);
        this.m_shardCache.clear(appDef);
    }

    @Override
    public void initializeApplication(ApplicationDefinition oldAppDef, ApplicationDefinition appDef) {
        this.checkServiceState();
        Tenant tenant = Tenant.getTenant(appDef);
        this.verifyApplicationCFs(tenant.getKeyspace(), oldAppDef, appDef);
    }

    @Override
    public void validateSchema(ApplicationDefinition appDef) {
        this.checkServiceState();
        this.validateApplication(appDef);
    }

    @Override
    public Collection<Task> getAppTasks(ApplicationDefinition appDef) {
        ArrayList<Task> appTasks = new ArrayList<Task>();
        for (TableDefinition tableDef : appDef.getTableDefinitions().values()) {
            String agingFreq = tableDef.getOption("aging-check-frequency");
            if (agingFreq == null) continue;
            Task task = new Task(appDef.getAppName(), tableDef.getTableName(), "data-aging", agingFreq, SpiderDataAger.class);
            appTasks.add(task);
        }
        return appTasks;
    }

    public DBObject getObject(TableDefinition tableDef, String objID) {
        this.checkServiceState();
        String storeName = SpiderService.objectsStoreName(tableDef);
        Iterator<DColumn> colIter = DBService.instance().getAllColumns(Tenant.getTenant(tableDef), storeName, objID);
        if (colIter == null) {
            return null;
        }
        DBObject dbObj = this.createObject(tableDef, objID, colIter);
        this.addShardedLinkValues(tableDef, dbObj);
        return dbObj;
    }

    public SearchResultList objectQueryURI(TableDefinition tableDef, String uriQuery) {
        this.checkServiceState();
        return new ObjectQuery(tableDef, uriQuery).query();
    }

    public SearchResultList objectQueryDoc(TableDefinition tableDef, UNode rootNode) {
        this.checkServiceState();
        return new ObjectQuery(tableDef, rootNode).query();
    }

    public AggregateResult aggregateQueryURI(TableDefinition tableDef, String uriQuery) {
        this.checkServiceState();
        Aggregate aggregate = new Aggregate(tableDef);
        aggregate.parseParameters(uriQuery);
        try {
            aggregate.execute();
        }
        catch (IOException e) {
            throw new RuntimeException("Aggregation failed with " + e);
        }
        return aggregate.getResult();
    }

    public AggregateResult aggregateQueryDoc(TableDefinition tableDef, UNode rootNode) {
        this.checkServiceState();
        Aggregate aggregate = new Aggregate(tableDef);
        aggregate.parseParameters(rootNode);
        try {
            aggregate.execute();
        }
        catch (IOException e) {
            throw new RuntimeException("Aggregation failed with " + e);
        }
        return aggregate.getResult();
    }

    public BatchResult addBatch(ApplicationDefinition appDef, String tableName, DBObjectBatch batch) {
        this.checkServiceState();
        TableDefinition tableDef = appDef.getTableDef(tableName);
        Utils.require((tableDef != null || appDef.allowsAutoTables() ? 1 : 0) != 0, (String)"Unknown table for application '%s': %s", (Object[])new Object[]{appDef.getAppName(), tableName});
        if (tableDef == null && appDef.allowsAutoTables()) {
            tableDef = this.addAutoTable(appDef, tableName);
            assert (tableDef != null);
        }
        BatchObjectUpdater batchUpdater = new BatchObjectUpdater(tableDef);
        return batchUpdater.addBatch(batch);
    }

    public BatchResult deleteBatch(TableDefinition tableDef, DBObjectBatch batch) {
        this.checkServiceState();
        HashSet<String> objIDSet = new HashSet<String>();
        for (DBObject dbObj : batch.getObjects()) {
            Utils.require((!Utils.isEmpty((String)dbObj.getObjectID()) ? 1 : 0) != 0, (String)"All objects must have _ID defined");
            objIDSet.add(dbObj.getObjectID());
        }
        BatchObjectUpdater batchUpdater = new BatchObjectUpdater(tableDef);
        return batchUpdater.deleteBatch(objIDSet);
    }

    public static String linkColumnName(FieldDefinition linkDef, String objID) {
        assert (linkDef.isLinkField());
        StringBuilder buffer = new StringBuilder();
        buffer.append("~");
        buffer.append(linkDef.getName());
        buffer.append("/");
        buffer.append(objID);
        return buffer.toString();
    }

    public static String objectsStoreName(TableDefinition tableDef) {
        String storeName = null;
        storeName = String.valueOf(tableDef.getAppDef().getAppName()) + "_" + tableDef.getTableName();
        return Utils.truncateTo((String)storeName, (int)48);
    }

    public static byte[] scalarValueToBinary(TableDefinition tableDef, String fieldName, String fieldValue) {
        if (fieldValue == null || fieldValue.length() == 0) {
            return null;
        }
        FieldDefinition fieldDef = tableDef.getFieldDef(fieldName);
        if (fieldDef != null && fieldDef.isBinaryField()) {
            return fieldDef.getEncoding().decode(fieldValue);
        }
        return Utils.toBytes((String)fieldValue);
    }

    public static String scalarValueToString(TableDefinition tableDef, String fieldName, byte[] colValue) {
        FieldDefinition fieldDef = tableDef.getFieldDef(fieldName);
        if (fieldDef != null && fieldDef.isBinaryField()) {
            return fieldDef.getEncoding().encode(colValue);
        }
        return Utils.toString((byte[])colValue);
    }

    public static String shardedLinkTermRowKey(FieldDefinition linkDef, String objID, int shardNumber) {
        assert (linkDef.isLinkField() && linkDef.isSharded() && shardNumber > 0);
        StringBuilder shardPrefix = new StringBuilder();
        shardPrefix.append(shardNumber);
        shardPrefix.append("/");
        shardPrefix.append(SpiderService.linkColumnName(linkDef, objID));
        return shardPrefix.toString();
    }

    public static String termIndexRowKey(TableDefinition tableDef, DBObject dbObj, String fieldName, String term) {
        StringBuilder termRecKey = new StringBuilder();
        int shardNumber = tableDef.getShardNumber(dbObj);
        if (shardNumber > 0) {
            termRecKey.append(shardNumber);
            termRecKey.append("/");
        }
        termRecKey.append(FieldAnalyzer.makeTermKey(fieldName, term));
        return termRecKey.toString();
    }

    public static String termsStoreName(TableDefinition tableDef) {
        String objStoreName = Utils.truncateTo((String)SpiderService.objectsStoreName(tableDef), (int)(48 - "_Terms".length()));
        return String.valueOf(objStoreName) + "_Terms";
    }

    public Map<String, Map<String, String>> getObjectScalars(TableDefinition tableDef, Collection<String> objIDs, Collection<String> fieldNames) {
        this.checkServiceState();
        HashMap<String, Map<String, String>> objScalarMap = new HashMap<String, Map<String, String>>();
        if (objIDs.size() > 0 && fieldNames.size() > 0) {
            String storeName = SpiderService.objectsStoreName(tableDef);
            Iterator<DRow> rowIter = DBService.instance().getRowsColumns(Tenant.getTenant(tableDef), storeName, objIDs, fieldNames);
            while (rowIter.hasNext()) {
                DRow row = rowIter.next();
                HashMap<String, String> scalarMap = new HashMap<String, String>();
                objScalarMap.put(row.getKey(), scalarMap);
                Iterator<DColumn> colIter = row.getColumns();
                while (colIter.hasNext()) {
                    DColumn col = colIter.next();
                    String fieldValue = SpiderService.scalarValueToString(tableDef, col.getName(), col.getRawValue());
                    scalarMap.put(col.getName(), fieldValue);
                }
            }
        }
        return objScalarMap;
    }

    public Map<String, String> getObjectScalar(TableDefinition tableDef, Collection<String> objIDs, String fieldName) {
        this.checkServiceState();
        HashMap<String, String> objScalarMap = new HashMap<String, String>();
        if (objIDs.size() > 0) {
            String storeName = SpiderService.objectsStoreName(tableDef);
            Iterator<DRow> rowIter = DBService.instance().getRowsColumns(Tenant.getTenant(tableDef), storeName, objIDs, Arrays.asList(fieldName));
            while (rowIter.hasNext()) {
                DRow row = rowIter.next();
                Iterator<DColumn> colIter = row.getColumns();
                while (colIter.hasNext()) {
                    DColumn col = colIter.next();
                    if (!col.getName().equals(fieldName)) continue;
                    String fieldValue = SpiderService.scalarValueToString(tableDef, col.getName(), col.getRawValue());
                    objScalarMap.put(row.getKey(), fieldValue);
                }
            }
        }
        return objScalarMap;
    }

    public void verifyShard(TableDefinition tableDef, int shardNumber) {
        assert (tableDef.isSharded());
        assert (shardNumber > 0);
        this.checkServiceState();
        this.m_shardCache.verifyShard(tableDef, shardNumber);
    }

    public Map<Integer, Date> getShards(TableDefinition tableDef) {
        this.checkServiceState();
        if (tableDef.isSharded()) {
            return this.m_shardCache.getShardMap(tableDef);
        }
        return new HashMap<Integer, Date>();
    }

    private SpiderService() {
    }

    private TableDefinition addAutoTable(ApplicationDefinition appDef, String tableName) {
        this.m_logger.debug("Adding implicit table '{}' to application '{}'", (Object)tableName, (Object)appDef.getAppName());
        Tenant tenant = Tenant.getTenant(appDef);
        TableDefinition tableDef = new TableDefinition(appDef);
        tableDef.setTableName(tableName);
        appDef.addTable(tableDef);
        SchemaService.instance().defineApplication(tenant, appDef);
        appDef = SchemaService.instance().getApplication(tenant, appDef.getAppName());
        return appDef.getTableDef(tableName);
    }

    private void addShardedLinkValues(TableDefinition tableDef, DBObject dbObj) {
        for (FieldDefinition fieldDef : tableDef.getFieldDefinitions()) {
            if (!fieldDef.isLinkField() || !fieldDef.isSharded()) continue;
            TableDefinition extentTableDef = tableDef.getLinkExtentTableDef(fieldDef);
            Set<Integer> shardNums = this.getShards(extentTableDef).keySet();
            Set<String> values = this.getShardedLinkValues(dbObj.getObjectID(), fieldDef, shardNums);
            dbObj.addFieldValues(fieldDef.getName(), values);
        }
    }

    private DBObject createObject(TableDefinition tableDef, String objID, Iterator<DColumn> colIter) {
        DBObject dbObj = new DBObject();
        dbObj.setObjectID(objID);
        dbObj.setTableName(tableDef.getTableName());
        while (colIter.hasNext()) {
            DColumn col = colIter.next();
            Pair<String, String> linkCol = this.extractLinkValue(tableDef, col.getName());
            if (linkCol == null) {
                String fieldName = col.getName();
                String fieldValue = SpiderService.scalarValueToString(tableDef, col.getName(), col.getRawValue());
                FieldDefinition fieldDef = tableDef.getFieldDef(fieldName);
                if (fieldDef != null && fieldDef.isCollection()) {
                    Set values = Utils.split((String)fieldValue, (String)"\ufffe");
                    dbObj.addFieldValues(fieldName, (Collection)values);
                    continue;
                }
                dbObj.addFieldValue(col.getName(), fieldValue);
                continue;
            }
            if (!tableDef.isLinkField((String)linkCol.firstItemInPair)) continue;
            dbObj.addFieldValue((String)linkCol.firstItemInPair, (String)linkCol.secondItemInPair);
        }
        return dbObj;
    }

    private void deleteApplicationCFs(ApplicationDefinition appDef) {
        Tenant tenant = Tenant.getTenant(appDef);
        for (TableDefinition tableDef : appDef.getTableDefinitions().values()) {
            DBService.instance().deleteStoreIfPresent(tenant, SpiderService.objectsStoreName(tableDef));
            DBService.instance().deleteStoreIfPresent(tenant, SpiderService.termsStoreName(tableDef));
        }
    }

    private Set<String> getShardedLinkValues(String objID, FieldDefinition linkDef, Set<Integer> shardNums) {
        HashSet<String> values = new HashSet<String>();
        if (shardNums.size() == 0) {
            return values;
        }
        HashSet<String> termRowKeys = new HashSet<String>();
        for (Integer shardNumber : shardNums) {
            termRowKeys.add(SpiderService.shardedLinkTermRowKey(linkDef, objID, shardNumber));
        }
        TableDefinition tableDef = linkDef.getTableDef();
        String termStore = SpiderService.termsStoreName(linkDef.getTableDef());
        Iterator<DRow> rowIter = DBService.instance().getRowsAllColumns(Tenant.getTenant(tableDef), termStore, termRowKeys);
        while (rowIter.hasNext()) {
            DRow row = rowIter.next();
            Iterator<DColumn> colIter = row.getColumns();
            while (colIter.hasNext()) {
                values.add(colIter.next().getName());
            }
        }
        return values;
    }

    private Pair<String, String> extractLinkValue(TableDefinition tableDef, String colName) {
        if (colName.length() < 3 || colName.charAt(0) != '~') {
            return null;
        }
        int slashInx = 1;
        while (slashInx < colName.length() && colName.charAt(slashInx) != '/') {
            ++slashInx;
        }
        if (slashInx >= colName.length()) {
            return null;
        }
        String fieldName = colName.substring(1, slashInx);
        String objID = colName.substring(slashInx + 1);
        return Pair.create((Object)fieldName, (Object)objID);
    }

    private boolean isValidShardDate(String shardDate) {
        try {
            Utils.dateFromString((String)shardDate);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    private void validateApplication(ApplicationDefinition appDef) {
        boolean bAutoTablesSet = false;
        block12: for (String optName : appDef.getOptionNames()) {
            String optValue = appDef.getOption(optName);
            switch (optName) {
                case "AutoTables": {
                    this.validateBooleanOption(optName, optValue);
                    bAutoTablesSet = true;
                    break;
                }
                case "StorageService": {
                    assert (optValue.equals(this.getClass().getSimpleName()));
                    continue block12;
                }
                case "aging-check-frequency": {
                    new TaskFrequency(optValue);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown option for SpiderService application: " + optName);
                }
                case "Tenant": 
            }
        }
        if (!bAutoTablesSet) {
            appDef.setOption("AutoTables", "true");
        }
        for (TableDefinition tableDef : appDef.getTableDefinitions().values()) {
            this.validateTable(tableDef);
        }
    }

    private void validateBooleanOption(String optName, String optValue) {
        if (!optValue.equalsIgnoreCase("true") && !optValue.equalsIgnoreCase("false")) {
            throw new IllegalArgumentException("Boolean value expected for '" + optName + "' option: " + optValue);
        }
    }

    private void validateField(FieldDefinition fieldDef) {
        Utils.require((!fieldDef.isXLinkField() ? 1 : 0) != 0, (String)"Xlink fields are not allowed in Spider applications");
        if (fieldDef.isScalarField()) {
            String analyzerName = fieldDef.getAnalyzerName();
            if (Utils.isEmpty((String)analyzerName)) {
                analyzerName = FieldType.getDefaultAnalyzer((FieldType)fieldDef.getType());
                fieldDef.setAnalyzer(analyzerName);
            }
            FieldAnalyzer.verifyAnalyzer(fieldDef);
        }
    }

    private void validateTable(TableDefinition tableDef) {
        for (String optName : tableDef.getOptionNames()) {
            String optValue = tableDef.getOption(optName);
            switch (optName) {
                case "aging-field": {
                    this.validateTableOptionAgingField(tableDef, optValue);
                    break;
                }
                case "retention-age": {
                    this.validateTableOptionRetentionAge(tableDef, optValue);
                    break;
                }
                case "sharding-field": {
                    this.validateTableOptionShardingField(tableDef, optValue);
                    break;
                }
                case "sharding-granularity": {
                    this.validateTableOptionShardingGranularity(tableDef, optValue);
                    break;
                }
                case "sharding-start": {
                    this.validateTableOptionShardingStart(tableDef, optValue);
                    break;
                }
                case "aging-check-frequency": {
                    this.validateTableOptionAgingCheckFrequency(tableDef, optValue);
                    break;
                }
                default: {
                    Utils.require((boolean)false, (String)("Unknown option for SpiderService table: " + optName));
                }
            }
        }
        for (FieldDefinition fieldDef : tableDef.getFieldDefinitions()) {
            this.validateField(fieldDef);
        }
        if (tableDef.getOption("aging-field") != null && tableDef.getOption("aging-check-frequency") == null) {
            String agingCheckFreq = tableDef.getAppDef().getOption("aging-check-frequency");
            if (Utils.isEmpty((String)agingCheckFreq)) {
                agingCheckFreq = "1 DAY";
            }
            tableDef.setOption("aging-check-frequency", agingCheckFreq);
        }
    }

    private void validateTableOptionAgingCheckFrequency(TableDefinition tableDef, String optValue) {
        new TaskFrequency(optValue);
        Utils.require((tableDef.getOption("aging-field") != null ? 1 : 0) != 0, (String)"Option 'aging-check-frequency' requires option 'aging-field'");
    }

    private void validateTableOptionAgingField(TableDefinition tableDef, String optValue) {
        FieldDefinition agingFieldDef = tableDef.getFieldDef(optValue);
        Utils.require((agingFieldDef != null ? 1 : 0) != 0, (String)("Aging field has not been defined: " + optValue));
        assert (agingFieldDef != null);
        Utils.require((agingFieldDef.getType() == FieldType.TIMESTAMP ? 1 : 0) != 0, (String)("Aging field must be a timestamp field: " + optValue));
        Utils.require((tableDef.getOption("retention-age") != null ? 1 : 0) != 0, (String)"Option 'aging-field' requires option 'retention-age'");
    }

    private void validateTableOptionRetentionAge(TableDefinition tableDef, String optValue) {
        RetentionAge retAge = new RetentionAge(optValue);
        optValue = retAge.toString();
        tableDef.setOption("retention-age", optValue);
        Utils.require((tableDef.getOption("aging-field") != null ? 1 : 0) != 0, (String)"Option 'retention-age' requires option 'aging-field'");
    }

    private void validateTableOptionShardingField(TableDefinition tableDef, String optValue) {
        FieldDefinition shardingFieldDef = tableDef.getFieldDef(optValue);
        Utils.require((shardingFieldDef != null ? 1 : 0) != 0, (String)("Sharding field has not been defined: " + optValue));
        assert (shardingFieldDef != null);
        Utils.require((shardingFieldDef.getType() == FieldType.TIMESTAMP ? 1 : 0) != 0, (String)("Sharding field must be a timestamp field: " + optValue));
        Utils.require((!shardingFieldDef.isCollection() ? 1 : 0) != 0, (String)("Sharding field cannot be a collection: " + optValue));
        if (tableDef.getOption("sharding-granularity") == null) {
            tableDef.setOption("sharding-granularity", "MONTH");
        }
        if (tableDef.getOption("sharding-start") == null) {
            GregorianCalendar startDate = new GregorianCalendar(Utils.UTC_TIMEZONE);
            startDate.add(5, 1);
            String startOpt = String.format("%04d-%02d-%02d", startDate.get(1), startDate.get(2) + 1, startDate.get(5));
            tableDef.setOption("sharding-start", startOpt);
        }
    }

    private void validateTableOptionShardingGranularity(TableDefinition tableDef, String optValue) {
        TableDefinition.ShardingGranularity shardingGranularity = TableDefinition.ShardingGranularity.fromString((String)optValue);
        Utils.require((shardingGranularity != null ? 1 : 0) != 0, (String)("Unrecognized 'sharding-granularity' value: " + optValue));
        Utils.require((tableDef.getOption("sharding-field") != null ? 1 : 0) != 0, (String)"Option 'sharding-granularity' requires option 'sharding-field'");
    }

    private void validateTableOptionShardingStart(TableDefinition tableDef, String optValue) {
        Utils.require((boolean)this.isValidShardDate(optValue), (String)("'sharding-start' must be YYYY-MM-DD: " + optValue));
        GregorianCalendar shardingStartDate = new GregorianCalendar(Utils.UTC_TIMEZONE);
        shardingStartDate.setTime(Utils.dateFromString((String)optValue));
        Utils.require((tableDef.getOption("sharding-field") != null ? 1 : 0) != 0, (String)"Option 'sharding-start' requires option 'sharding-field'");
    }

    private void verifyApplicationCFs(String keyspace, ApplicationDefinition oldAppDef, ApplicationDefinition appDef) {
        DBService dbService = DBService.instance();
        Tenant tenant = Tenant.getTenant(appDef);
        for (TableDefinition tableDef : appDef.getTableDefinitions().values()) {
            dbService.createStoreIfAbsent(tenant, SpiderService.objectsStoreName(tableDef), true);
            dbService.createStoreIfAbsent(tenant, SpiderService.termsStoreName(tableDef), true);
        }
        if (oldAppDef != null) {
            for (TableDefinition oldTableDef : oldAppDef.getTableDefinitions().values()) {
                if (appDef.getTableDef(oldTableDef.getTableName()) != null) continue;
                dbService.deleteStoreIfPresent(tenant, SpiderService.objectsStoreName(oldTableDef));
                dbService.deleteStoreIfPresent(tenant, SpiderService.termsStoreName(oldTableDef));
            }
        }
    }
}

