/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.spider;

import com.dell.doradus.common.ApplicationDefinition;
import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.common.Utils;
import com.dell.doradus.core.ObjectID;
import com.dell.doradus.fieldanalyzer.FieldAnalyzer;
import com.dell.doradus.fieldanalyzer.NullAnalyzer;
import com.dell.doradus.fieldanalyzer.TextAnalyzer;
import com.dell.doradus.search.IDHelper;
import com.dell.doradus.search.util.HeapSet;
import com.dell.doradus.service.db.DBService;
import com.dell.doradus.service.db.DColumn;
import com.dell.doradus.service.db.DRow;
import com.dell.doradus.service.db.Tenant;
import com.dell.doradus.service.spider.SpiderService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SpiderHelper {
    public static final byte[] EMPTY_BYTES = new byte[0];

    private static List<String> objectsToStrings(Collection<ObjectID> ids) {
        ArrayList<String> keys = new ArrayList<String>(ids.size());
        for (ObjectID id : ids) {
            keys.add(IDHelper.IDToString(id));
        }
        return keys;
    }

    private static <T extends Comparable<T>> List<T> unionUnique(List<List<T>> collection, int count) {
        HeapSet<Comparable> hl = new HeapSet<Comparable>(count);
        for (List<T> lst : collection) {
            for (Comparable v : lst) {
                hl.Put(v);
            }
        }
        List result = hl.GetValues();
        return result;
    }

    private static String fromLinksStart(FieldDefinition linkDef, ObjectID continuationLink, boolean inclusive) {
        byte[] start = null;
        if (continuationLink == null) {
            start = IDHelper.linkBoundMinimum(linkDef);
        } else {
            start = IDHelper.linkToBytes(linkDef, continuationLink);
            if (!inclusive) {
                start = IDHelper.next(start);
            }
        }
        return Utils.toString((byte[])start);
    }

    private static String fromLinksFinish(FieldDefinition linkDef) {
        return Utils.toString((byte[])IDHelper.linkBoundMaximum(linkDef));
    }

    private static String fromTerms(ObjectID continuationObject, boolean inclusive) {
        byte[] start = EMPTY_BYTES;
        if (continuationObject != null) {
            start = IDHelper.idToBytes(continuationObject);
            if (!inclusive) {
                start = IDHelper.next(start);
            }
        }
        return Utils.toString((byte[])start);
    }

    private static String linkKey(Integer shard, FieldDefinition link, ObjectID id) {
        if (id == null) {
            id = ObjectID.EMPTY;
        }
        return shard.toString() + "/~" + link.getName() + "/" + IDHelper.IDToString(id);
    }

    private static ObjectID unlinkKey(Integer shard, FieldDefinition link, String key) {
        String prefix = shard.toString() + "/~" + link.getName() + "/";
        assert (key.startsWith(prefix));
        return IDHelper.createID(key.substring(prefix.length()));
    }

    private static List<String> linkKeys(Integer shard, FieldDefinition link, Collection<ObjectID> ids) {
        ArrayList<String> keys = new ArrayList<String>(ids.size());
        for (ObjectID id : ids) {
            keys.add(shard.toString() + "/~" + link.getName() + "/" + IDHelper.IDToString(id));
        }
        return keys;
    }

    private static String termKey(Integer shard, String field) {
        return shard.toString() + "/_terms/" + field;
    }

    private static void addScalarToMap(TableDefinition tableDef, Map<String, String> scalarMap, DColumn column) {
        String fieldName = column.getName();
        FieldDefinition fieldDef = tableDef.getFieldDef(fieldName);
        if (fieldDef != null && fieldDef.isBinaryField()) {
            scalarMap.put(fieldName, fieldDef.getEncoding().encode(column.getRawValue()));
        } else {
            scalarMap.put(fieldName, column.getValue());
        }
    }

    public static Map<ObjectID, Map<String, String>> getScalarValues(TableDefinition tableDef, Collection<ObjectID> ids, String continuationField, int count) {
        DBService dbService = DBService.instance();
        HashMap<ObjectID, Map<String, String>> result = new HashMap<ObjectID, Map<String, String>>();
        if (continuationField == null && tableDef.isSharded()) {
            continuationField = new String(new char[]{'\"'});
        } else if (continuationField == null) {
            continuationField = "";
        }
        String tableName = SpiderService.objectsStoreName(tableDef);
        List<String> rowKeys = SpiderHelper.objectsToStrings(ids);
        Iterator<DRow> iRows = dbService.getRowsColumnSlice(Tenant.getTenant(tableDef), tableName, rowKeys, continuationField, "~");
        while (iRows.hasNext()) {
            DRow row = iRows.next();
            HashMap<String, String> scalarValues = new HashMap<String, String>();
            result.put(IDHelper.createID(row.getKey()), scalarValues);
            Iterator<DColumn> iColumns = row.getColumns();
            for (int i = 0; i < count && iColumns.hasNext(); ++i) {
                DColumn column = iColumns.next();
                SpiderHelper.addScalarToMap(tableDef, scalarValues, column);
            }
        }
        return result;
    }

    public static Map<String, String> getScalarValues(TableDefinition tableDef, ObjectID id, String continuationField, int count) {
        DBService dbService = DBService.instance();
        if (continuationField == null && tableDef.isSharded()) {
            continuationField = new String(new char[]{'\"'});
        } else if (continuationField == null) {
            continuationField = "";
        }
        String tableName = SpiderService.objectsStoreName(tableDef);
        Iterator<DColumn> iColumns = dbService.getColumnSlice(Tenant.getTenant(tableDef), tableName, IDHelper.IDToString(id), continuationField, "~");
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < count && iColumns.hasNext(); ++i) {
            DColumn column = iColumns.next();
            result.put(column.getName(), column.getValue());
        }
        return result;
    }

    public static Map<ObjectID, Map<String, String>> getScalarValues(TableDefinition tableDef, Collection<ObjectID> ids, Collection<String> fields) {
        DBService dbService = DBService.instance();
        HashMap<ObjectID, Map<String, String>> result = new HashMap<ObjectID, Map<String, String>>();
        String tableName = SpiderService.objectsStoreName(tableDef);
        List<String> rowKeys = SpiderHelper.objectsToStrings(ids);
        Iterator<DRow> iRows = dbService.getRowsColumns(Tenant.getTenant(tableDef), tableName, rowKeys, fields);
        while (iRows.hasNext()) {
            DRow row = iRows.next();
            HashMap<String, String> scalarValues = new HashMap<String, String>();
            result.put(IDHelper.createID(row.getKey()), scalarValues);
            Iterator<DColumn> iColumns = row.getColumns();
            while (iColumns.hasNext()) {
                DColumn column = iColumns.next();
                SpiderHelper.addScalarToMap(tableDef, scalarValues, column);
            }
        }
        return result;
    }

    public static Map<String, String> getScalarValues(TableDefinition tableDef, ObjectID id, Collection<String> fields) {
        DBService dbService = DBService.instance();
        HashMap<String, String> result = new HashMap<String, String>();
        String tableName = SpiderService.objectsStoreName(tableDef);
        Iterator<DRow> iRows = dbService.getRowsColumns(Tenant.getTenant(tableDef), tableName, Arrays.asList(IDHelper.IDToString(id)), fields);
        if (iRows.hasNext()) {
            Iterator<DColumn> iColumns = iRows.next().getColumns();
            while (iColumns.hasNext()) {
                DColumn column = iColumns.next();
                result.put(column.getName(), column.getValue());
            }
        }
        return result;
    }

    public static String fetchScalarFieldValue(TableDefinition tableDef, ObjectID id, String field) {
        ArrayList<String> fields = new ArrayList<String>(1);
        fields.add(field);
        Map<String, String> result = SpiderHelper.getScalarValues(tableDef, id, fields);
        return result.get(field);
    }

    public static List<ObjectID> getLinks(FieldDefinition linkDef, ObjectID id, ObjectID continuationLink, boolean inclusive, int count) {
        return SpiderHelper.getLinks(linkDef, (Collection<Integer>)null, id, continuationLink, inclusive, count);
    }

    public static Map<ObjectID, List<ObjectID>> getLinks(FieldDefinition linkDef, Collection<ObjectID> ids, ObjectID continuationLink, boolean inclusive, int count) {
        return SpiderHelper.getLinks(linkDef, (Collection<Integer>)null, ids, continuationLink, inclusive, count);
    }

    public static Map<ObjectID, List<ObjectID>> getLinksUnsharded(FieldDefinition linkDef, Collection<ObjectID> ids, ObjectID continuationLink, boolean inclusive, int count) {
        DBService dbService = DBService.instance();
        TableDefinition tableDef = linkDef.getTableDef();
        String tableName = SpiderService.objectsStoreName(tableDef);
        HashMap<ObjectID, List<ObjectID>> result = new HashMap<ObjectID, List<ObjectID>>();
        String start = SpiderHelper.fromLinksStart(linkDef, continuationLink, inclusive);
        String finish = SpiderHelper.fromLinksFinish(linkDef);
        List<String> keys = SpiderHelper.objectsToStrings(ids);
        Iterator<DRow> iRows = dbService.getRowsColumnSlice(Tenant.getTenant(tableDef), tableName, keys, start, finish);
        while (iRows.hasNext()) {
            DRow row = iRows.next();
            ArrayList<ObjectID> list = new ArrayList<ObjectID>();
            result.put(IDHelper.createID(row.getKey()), list);
            Iterator<DColumn> iColumns = row.getColumns();
            for (int i = 0; i < count && iColumns.hasNext(); ++i) {
                list.add(IDHelper.linkValueToId(Utils.toBytes((String)iColumns.next().getName())));
            }
        }
        return result;
    }

    public static List<ObjectID> getLinksUnsharded(FieldDefinition linkDef, ObjectID id, ObjectID continuationLink, boolean inclusive, int count) {
        DBService dbService = DBService.instance();
        TableDefinition tableDef = linkDef.getTableDef();
        String tableName = SpiderService.objectsStoreName(tableDef);
        ArrayList<ObjectID> result = new ArrayList<ObjectID>();
        String start = SpiderHelper.fromLinksStart(linkDef, continuationLink, inclusive);
        String finish = SpiderHelper.fromLinksFinish(linkDef);
        Iterator<DColumn> iColumns = dbService.getColumnSlice(Tenant.getTenant(tableDef), tableName, IDHelper.IDToString(id), start, finish);
        for (int i = 0; i < count && iColumns.hasNext(); ++i) {
            result.add(IDHelper.linkValueToId(Utils.toBytes((String)iColumns.next().getName())));
        }
        return result;
    }

    public static Map<ObjectID, List<ObjectID>> getLinks(FieldDefinition linkDef, Integer shard, Collection<ObjectID> ids, ObjectID continuationLink, boolean inclusive, int count) {
        if (shard == 0) {
            return SpiderHelper.getLinksUnsharded(linkDef, ids, continuationLink, inclusive, count);
        }
        DBService dbService = DBService.instance();
        TableDefinition tableDef = linkDef.getTableDef();
        String tableName = SpiderService.termsStoreName(tableDef);
        HashMap<ObjectID, List<ObjectID>> result = new HashMap<ObjectID, List<ObjectID>>();
        String startCol = SpiderHelper.fromTerms(continuationLink, inclusive);
        Iterator<DRow> iRows = dbService.getRowsColumnSlice(Tenant.getTenant(tableDef), tableName, SpiderHelper.linkKeys(shard, linkDef, ids), startCol, "");
        while (iRows.hasNext()) {
            DRow row = iRows.next();
            ArrayList<ObjectID> list = new ArrayList<ObjectID>();
            result.put(SpiderHelper.unlinkKey(shard, linkDef, row.getKey()), list);
            Iterator<DColumn> iColumns = row.getColumns();
            for (int i = 0; i < count && iColumns.hasNext(); ++i) {
                list.add(IDHelper.createID(iColumns.next().getName()));
            }
        }
        return result;
    }

    public static List<ObjectID> getLinks(FieldDefinition linkDef, Integer shard, ObjectID id, ObjectID continuationLink, boolean inclusive, int count) {
        if (shard == 0) {
            return SpiderHelper.getLinksUnsharded(linkDef, id, continuationLink, inclusive, count);
        }
        DBService dbService = DBService.instance();
        TableDefinition tableDef = linkDef.getTableDef();
        String tableName = SpiderService.termsStoreName(tableDef);
        ArrayList<ObjectID> result = new ArrayList<ObjectID>();
        String startCol = SpiderHelper.fromTerms(continuationLink, inclusive);
        String key = SpiderHelper.linkKey(shard, linkDef, id);
        Iterator<DColumn> iColumns = dbService.getColumnSlice(Tenant.getTenant(tableDef), tableName, key, startCol, "");
        for (int i = 0; i < count && iColumns.hasNext(); ++i) {
            result.add(IDHelper.createID(iColumns.next().getName()));
        }
        return result;
    }

    public static Map<ObjectID, List<ObjectID>> getLinks(FieldDefinition linkDef, Collection<Integer> shards, Collection<ObjectID> ids, ObjectID continuationLink, boolean inclusive, int count) {
        if (!linkDef.isSharded()) {
            return SpiderHelper.getLinksUnsharded(linkDef, ids, continuationLink, inclusive, count);
        }
        ApplicationDefinition app = linkDef.getTableDef().getAppDef();
        TableDefinition extent = app.getTableDef(linkDef.getLinkExtent());
        if (shards == null) {
            shards = SpiderHelper.getShards(extent);
        }
        if (shards.size() == 1) {
            return SpiderHelper.getLinks(linkDef, shards.toArray(new Integer[1])[0], ids, continuationLink, inclusive, count);
        }
        HashMap values = new HashMap(ids.size());
        for (Integer shard : shards) {
            Map<ObjectID, List<ObjectID>> res = SpiderHelper.getLinks(linkDef, shard, ids, continuationLink, inclusive, count);
            for (Map.Entry<ObjectID, List<ObjectID>> entry : res.entrySet()) {
                if (values.containsKey(entry.getKey())) {
                    ((List)values.get(entry.getKey())).add(entry.getValue());
                    continue;
                }
                ArrayList<List<ObjectID>> lst = new ArrayList<List<ObjectID>>(shards.size());
                lst.add(entry.getValue());
                values.put(entry.getKey(), lst);
            }
        }
        HashMap<ObjectID, List<ObjectID>> result = new HashMap<ObjectID, List<ObjectID>>(ids.size());
        for (Map.Entry entry : values.entrySet()) {
            HashSet<ObjectID> set = new HashSet<ObjectID>();
            int i = 0;
            block3: for (List list : (List)entry.getValue()) {
                for (ObjectID id : list) {
                    if (!set.add(id) || ++i < count) continue;
                    break block3;
                }
            }
            result.put((ObjectID)entry.getKey(), new ArrayList(set));
        }
        return result;
    }

    public static List<ObjectID> getLinks(FieldDefinition linkDef, Collection<Integer> shards, ObjectID id, ObjectID continuationLink, boolean inclusive, int count) {
        if (!linkDef.isSharded()) {
            return SpiderHelper.getLinksUnsharded(linkDef, id, continuationLink, inclusive, count);
        }
        ApplicationDefinition app = linkDef.getTableDef().getAppDef();
        TableDefinition extent = app.getTableDef(linkDef.getLinkExtent());
        if (shards == null) {
            shards = SpiderHelper.getShards(extent);
        }
        ArrayList values = new ArrayList(shards.size());
        for (Integer shard : shards) {
            values.add(SpiderHelper.getLinks(linkDef, shard, id, continuationLink, inclusive, count));
        }
        return SpiderHelper.unionUnique(values, count);
    }

    public static List<String> getTerms(TableDefinition tableDef, String field, String prefix, int count) {
        return SpiderHelper.getTerms(tableDef, (Collection<Integer>)null, field, prefix, count);
    }

    public static List<String> getTermsUnsharded(TableDefinition tableDef, String field, String prefix, int count) {
        DBService dbService = DBService.instance();
        String termsStore = SpiderService.termsStoreName(tableDef);
        if (prefix == null) {
            prefix = "";
        }
        ArrayList<String> result = new ArrayList<String>();
        Iterator<DColumn> iColumns = dbService.getColumnSlice(Tenant.getTenant(tableDef), termsStore, "_terms/" + field, prefix, prefix + '\uffff');
        for (int i = 0; i < count && iColumns.hasNext(); ++i) {
            result.add(iColumns.next().getName());
        }
        return result;
    }

    public static List<String> getTermsUnsharded(TableDefinition tableDef, String field, String from, String to, int count, boolean reversed) {
        DBService dbService = DBService.instance();
        String termsStore = SpiderService.termsStoreName(tableDef);
        if (from == null) {
            from = "";
        }
        if (to == null) {
            to = "";
        }
        ArrayList<String> result = new ArrayList<String>();
        Iterator<DColumn> iColumns = dbService.getColumnSlice(Tenant.getTenant(tableDef), termsStore, "_terms/" + field, from, to, reversed);
        for (int i = 0; i < count && iColumns.hasNext(); ++i) {
            result.add(iColumns.next().getName());
        }
        return result;
    }

    public static List<String> getTerms(TableDefinition tableDef, Integer shard, String field, String prefix, int count) {
        if (shard == 0) {
            return SpiderHelper.getTermsUnsharded(tableDef, field, prefix, count);
        }
        DBService dbService = DBService.instance();
        String termsStore = SpiderService.termsStoreName(tableDef);
        if (prefix == null) {
            prefix = "";
        }
        ArrayList<String> result = new ArrayList<String>();
        Iterator<DColumn> iColumns = dbService.getColumnSlice(Tenant.getTenant(tableDef), termsStore, SpiderHelper.termKey(shard, field), prefix, prefix + '\uffff');
        for (int i = 0; i < count && iColumns.hasNext(); ++i) {
            result.add(iColumns.next().getName());
        }
        return result;
    }

    public static List<String> getTerms(TableDefinition tableDef, Integer shard, String field, String from, String to, int count, boolean reversed) {
        if (shard == 0) {
            return SpiderHelper.getTermsUnsharded(tableDef, field, from, to, count, reversed);
        }
        DBService dbService = DBService.instance();
        String termsStore = SpiderService.termsStoreName(tableDef);
        if (from == null) {
            from = "";
        }
        if (to == null) {
            to = "";
        }
        ArrayList<String> result = new ArrayList<String>();
        Iterator<DColumn> iColumns = dbService.getColumnSlice(Tenant.getTenant(tableDef), termsStore, SpiderHelper.termKey(shard, field), from, to, reversed);
        for (int i = 0; i < count && iColumns.hasNext(); ++i) {
            result.add(iColumns.next().getName());
        }
        return result;
    }

    public static List<String> getTerms(TableDefinition tableDef, Collection<Integer> shards, String field, String prefix, int count) {
        if (!tableDef.isSharded()) {
            return SpiderHelper.getTermsUnsharded(tableDef, field, prefix, count);
        }
        if (shards == null) {
            shards = SpiderHelper.getShards(tableDef);
        }
        ArrayList terms = new ArrayList(shards.size());
        for (Integer shard : shards) {
            terms.add(SpiderHelper.getTerms(tableDef, shard, field, prefix, count));
        }
        List<String> result = SpiderHelper.unionUnique(terms, count);
        return result;
    }

    public static List<String> getFields(TableDefinition tableDef) {
        ArrayList<String> result = new ArrayList<String>();
        String tableName = SpiderService.termsStoreName(tableDef);
        Iterator<DColumn> iColumns = DBService.instance().getAllColumns(Tenant.getTenant(tableDef), tableName, "_fields");
        while (iColumns.hasNext()) {
            result.add(iColumns.next().getName());
        }
        return result;
    }

    public static List<ObjectID> getTermDocsUnsharded(TableDefinition tableDef, String term, ObjectID continuationObject, boolean inclusive, int count) {
        String startCol;
        DBService dbService = DBService.instance();
        String store = SpiderService.termsStoreName(tableDef);
        ArrayList<ObjectID> result = new ArrayList<ObjectID>();
        String string = startCol = continuationObject == null ? "" : IDHelper.IDToString(continuationObject);
        if (!inclusive) {
            startCol = startCol + '\u0000';
        }
        Iterator<DColumn> iColumns = dbService.getColumnSlice(Tenant.getTenant(tableDef), store, term, startCol, "");
        for (int i = 0; i < count && iColumns.hasNext(); ++i) {
            result.add(IDHelper.createID(iColumns.next().getName()));
        }
        return result;
    }

    public static Map<String, List<ObjectID>> getTermDocsUnsharded(TableDefinition tableDef, Collection<String> terms, ObjectID continuationObject, boolean inclusive, int count) {
        String startCol;
        DBService dbService = DBService.instance();
        String store = SpiderService.termsStoreName(tableDef);
        HashMap<String, List<ObjectID>> result = new HashMap<String, List<ObjectID>>();
        String string = startCol = continuationObject == null ? "" : IDHelper.IDToString(continuationObject);
        if (!inclusive) {
            startCol = startCol + '\u0000';
        }
        Iterator<DRow> iRows = dbService.getRowsColumnSlice(Tenant.getTenant(tableDef), store, terms, startCol, "");
        while (iRows.hasNext()) {
            DRow row = iRows.next();
            ArrayList<ObjectID> list = new ArrayList<ObjectID>();
            result.put(row.getKey(), list);
            Iterator<DColumn> iColumns = row.getColumns();
            for (int i = 0; i < count && iColumns.hasNext(); ++i) {
                list.add(IDHelper.createID(iColumns.next().getName()));
            }
        }
        return result;
    }

    public static List<ObjectID> getTermDocs(TableDefinition tableDef, Integer shard, String term, ObjectID continuationObject, boolean inclusive, int count) {
        if (shard == 0) {
            return SpiderHelper.getTermDocsUnsharded(tableDef, term, continuationObject, inclusive, count);
        }
        return SpiderHelper.getTermDocsUnsharded(tableDef, shard.toString() + "/" + term, continuationObject, inclusive, count);
    }

    public static Map<String, List<ObjectID>> getTermDocs(TableDefinition tableDef, Integer shard, Collection<String> terms, ObjectID continuationObject, boolean inclusive, int count) {
        if (shard == 0) {
            return SpiderHelper.getTermDocsUnsharded(tableDef, terms, continuationObject, inclusive, count);
        }
        ArrayList<String> shardTerms = new ArrayList<String>(terms.size());
        String prefix = shard.toString() + "/";
        for (String term : terms) {
            shardTerms.add(prefix + term);
        }
        Map<String, List<ObjectID>> result = SpiderHelper.getTermDocsUnsharded(tableDef, shardTerms, continuationObject, inclusive, count);
        HashMap<String, List<ObjectID>> result2 = new HashMap<String, List<ObjectID>>(result.size());
        for (Map.Entry<String, List<ObjectID>> e : result.entrySet()) {
            if (e.getKey().startsWith(prefix)) {
                result2.put(e.getKey().substring(prefix.length()), e.getValue());
                continue;
            }
            result2.put(e.getKey(), e.getValue());
        }
        return result2;
    }

    public static Set<Integer> getShards(TableDefinition tableDef) {
        HashSet<Integer> results = new HashSet<Integer>(SpiderService.instance().getShards(tableDef).keySet());
        results.add(0);
        return results;
    }

    public static Set<String> getTerms(String fieldName, String fieldValue, TableDefinition tabDef) {
        FieldAnalyzer analyzer = TextAnalyzer.instance();
        FieldDefinition fieldDef = tabDef.getFieldDef(fieldName);
        if (fieldDef != null) {
            FieldAnalyzer fieldAnalyzer = FieldAnalyzer.findAnalyzer(fieldDef);
            if (fieldAnalyzer == NullAnalyzer.instance()) {
                return null;
            }
            if (fieldAnalyzer != null) {
                analyzer = fieldAnalyzer;
            }
        }
        try {
            return analyzer.extractTerms(fieldValue);
        }
        catch (IllegalArgumentException e) {
            return new HashSet<String>();
        }
    }
}

