/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.spider;

import com.dell.doradus.common.BatchResult;
import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.RetentionAge;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.common.Utils;
import com.dell.doradus.search.SearchResult;
import com.dell.doradus.search.SearchResultList;
import com.dell.doradus.service.spider.BatchObjectUpdater;
import com.dell.doradus.service.spider.SpiderService;
import com.dell.doradus.service.taskmanager.TaskExecutor;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;

public class SpiderDataAger
extends TaskExecutor {
    private static final int QUERY_PAGE_SIZE = 1000;
    private TableDefinition m_tableDef;
    private FieldDefinition m_agingFieldDef;
    private RetentionAge m_retentionAge;

    @Override
    public void execute() {
        this.setTableParams();
        this.checkTable();
    }

    private void setTableParams() {
        String taskID = this.m_taskRecord.getTaskID();
        String[] idParts = taskID.split("/");
        String tableName = idParts[1];
        this.m_tableDef = this.m_appDef.getTableDef(tableName);
        String fieldName = this.m_tableDef.getOption("aging-field");
        this.m_agingFieldDef = this.m_tableDef.getFieldDef(fieldName);
        this.m_retentionAge = new RetentionAge(this.m_tableDef.getOption("retention-age"));
    }

    private void checkTable() {
        this.m_logger.info("Checking expired objects for: {}", (Object)this.m_tableDef.getPath());
        GregorianCalendar checkDate = new GregorianCalendar(Utils.UTC_TIMEZONE);
        GregorianCalendar expireDate = this.m_retentionAge.getExpiredDate(checkDate);
        int objsExpired = 0;
        String fixedQuery = this.buildFixedQuery(expireDate);
        String contToken = null;
        StringBuilder uriParam = new StringBuilder();
        do {
            uriParam.setLength(0);
            uriParam.append(fixedQuery);
            if (!Utils.isEmpty(contToken)) {
                uriParam.append("&g=");
                uriParam.append(contToken);
            }
            SearchResultList resultList = SpiderService.instance().objectQueryURI(this.m_tableDef, uriParam.toString());
            HashSet<String> objIDSet = new HashSet<String>();
            for (SearchResult result : resultList.results) {
                objIDSet.add(result.id());
            }
            contToken = this.deleteBatch(objIDSet) ? resultList.continuation_token : null;
            objsExpired += objIDSet.size();
        } while (!Utils.isEmpty((String)contToken));
        this.m_logger.info("Deleted {} objects for {}", (Object)objsExpired, (Object)this.m_tableDef.getPath());
    }

    private String buildFixedQuery(GregorianCalendar expireDate) {
        StringBuilder fixedParams = new StringBuilder();
        fixedParams.append("q=");
        fixedParams.append(this.m_agingFieldDef.getName());
        fixedParams.append(" <= \"");
        fixedParams.append(Utils.formatDate((Calendar)expireDate));
        fixedParams.append("\"");
        fixedParams.append("&f=_ID");
        fixedParams.append("&s=");
        fixedParams.append(1000);
        return fixedParams.toString();
    }

    private boolean deleteBatch(Set<String> objIDSet) {
        if (objIDSet.size() == 0) {
            return false;
        }
        this.m_logger.debug("Deleting batch of {} objects from {}", (Object)objIDSet.size(), (Object)this.m_tableDef.getPath());
        BatchObjectUpdater batchUpdater = new BatchObjectUpdater(this.m_tableDef);
        BatchResult batchResult = batchUpdater.deleteBatch(objIDSet);
        if (batchResult.isFailed()) {
            this.m_logger.error("Batch query failed: {}", (Object)batchResult.getErrorMessage());
            return false;
        }
        return true;
    }
}

