/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.spider;

import com.dell.doradus.common.ApplicationDefinition;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.common.Utils;
import com.dell.doradus.service.db.DBService;
import com.dell.doradus.service.db.DBTransaction;
import com.dell.doradus.service.db.DColumn;
import com.dell.doradus.service.db.Tenant;
import com.dell.doradus.service.spider.SpiderService;
import com.dell.doradus.service.spider.SpiderTransaction;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardCache {
    private static final long MAX_CACHE_TIME_MILLIS = 60000L;
    private final Map<String, Date> m_cacheMap = new ConcurrentHashMap<String, Date>();
    private final Logger m_logger = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
    private final Map<String, Map<String, Map<Integer, Date>>> m_appShardMap = new HashMap<String, Map<String, Map<Integer, Date>>>();

    public synchronized void clearAll() {
        this.m_appShardMap.clear();
        this.m_cacheMap.clear();
    }

    public synchronized void clear(ApplicationDefinition appDef) {
        String appName = appDef.getAppName();
        for (TableDefinition tableDef : appDef.getTableDefinitions().values()) {
            this.m_cacheMap.remove(appName + "/" + tableDef.getTableName());
        }
        this.m_appShardMap.remove(appName);
    }

    public synchronized Map<Integer, Date> getShardMap(TableDefinition tableDef) {
        Map<Integer, Date> shardMap;
        assert (tableDef != null);
        assert (tableDef.isSharded());
        String appName = tableDef.getAppDef().getAppName();
        String tableName = tableDef.getTableName();
        String cacheKey = appName + "/" + tableName;
        Date cacheDate = this.m_cacheMap.get(cacheKey);
        if (cacheDate == null || this.isTooOld(cacheDate)) {
            this.loadShardCache(tableDef);
        }
        HashMap<Integer, Date> result = new HashMap<Integer, Date>();
        Map<String, Map<Integer, Date>> tableMap = this.m_appShardMap.get(appName);
        if (tableMap != null && (shardMap = tableMap.get(tableDef.getTableName())) != null) {
            result.putAll(shardMap);
        }
        return result;
    }

    public synchronized void verifyShard(TableDefinition tableDef, int shardNumber) {
        Map<Integer, Date> shardMap;
        assert (tableDef != null);
        assert (tableDef.isSharded());
        assert (shardNumber > 0);
        Map<String, Map<Integer, Date>> tableMap = this.m_appShardMap.get(tableDef.getAppDef().getAppName());
        if (tableMap != null && (shardMap = tableMap.get(tableDef.getTableName())) != null && shardMap.containsKey(shardNumber)) {
            return;
        }
        Date shardDate = tableDef.computeShardStart(shardNumber);
        this.addShardStart(tableDef, shardNumber, shardDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addShardStart(TableDefinition tableDef, int shardNumber, Date shardDate) {
        SpiderTransaction spiderTran = new SpiderTransaction();
        spiderTran.addShardStart(tableDef, shardNumber, shardDate);
        DBTransaction dbTran = DBService.instance().startTransaction(Tenant.getTenant(tableDef));
        spiderTran.applyUpdates(dbTran);
        DBService.instance().commit(dbTran);
        ShardCache shardCache = this;
        synchronized (shardCache) {
            this.cacheShardValue(tableDef, shardNumber, shardDate);
        }
    }

    private void cacheShardValue(TableDefinition tableDef, Integer shardNumber, Date shardStart) {
        String tableName;
        Map<Integer, Date> shardNumberMap;
        String appName = tableDef.getAppDef().getAppName();
        Map<String, Map<Integer, Date>> tableShardNumberMap = this.m_appShardMap.get(appName);
        if (tableShardNumberMap == null) {
            tableShardNumberMap = new HashMap<String, Map<Integer, Date>>();
            this.m_appShardMap.put(appName, tableShardNumberMap);
        }
        if ((shardNumberMap = tableShardNumberMap.get(tableName = tableDef.getTableName())) == null) {
            shardNumberMap = new HashMap<Integer, Date>();
            tableShardNumberMap.put(tableName, shardNumberMap);
        }
        shardNumberMap.put(shardNumber, shardStart);
        this.m_logger.debug("Sharding date for {}.{} shard #{} set to: {} ({})", new Object[]{appName, tableName, shardNumber, shardStart.getTime(), Utils.formatDateUTC((Date)shardStart)});
    }

    private void loadShardCache(TableDefinition tableDef) {
        Iterator<DColumn> colIter;
        Map<Integer, Date> shardMap;
        String appName = tableDef.getAppDef().getAppName();
        String tableName = tableDef.getTableName();
        this.m_logger.debug("Loading shard cache for {}.{}", (Object)appName, (Object)tableName);
        Date cacheDate = new Date();
        String cacheKey = appName + "/" + tableName;
        this.m_cacheMap.put(cacheKey, cacheDate);
        Map<String, Map<Integer, Date>> tableMap = this.m_appShardMap.get(appName);
        if (tableMap == null) {
            tableMap = new HashMap<String, Map<Integer, Date>>();
            this.m_appShardMap.put(appName, tableMap);
        }
        if ((shardMap = tableMap.get(tableName)) == null) {
            shardMap = new HashMap<Integer, Date>();
            tableMap.put(tableName, shardMap);
        }
        if ((colIter = DBService.instance().getAllColumns(Tenant.getTenant(tableDef), SpiderService.termsStoreName(tableDef), "_shards")) != null) {
            while (colIter.hasNext()) {
                DColumn col = colIter.next();
                Integer shardNum = Integer.parseInt(col.getName());
                Date shardDate = new Date(Long.parseLong(col.getValue()));
                shardMap.put(shardNum, shardDate);
            }
        }
    }

    private boolean isTooOld(Date cacheDate) {
        Date now = new Date();
        return now.getTime() - cacheDate.getTime() > 60000L;
    }
}

