/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.spider;

import com.dell.doradus.common.DBObject;
import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.Utils;
import com.dell.doradus.fieldanalyzer.FieldAnalyzer;
import com.dell.doradus.service.spider.FieldUpdater;
import com.dell.doradus.service.spider.ObjectUpdater;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class ScalarFieldUpdater
extends FieldUpdater {
    protected ScalarFieldUpdater(ObjectUpdater objUpdater, DBObject dbObj, String fieldName) {
        super(objUpdater, dbObj, fieldName);
    }

    @Override
    public void addValuesForField() {
        FieldDefinition fieldDef = this.m_tableDef.getFieldDef(this.m_fieldName);
        if (fieldDef == null || !fieldDef.isCollection()) {
            this.addSVScalar();
        } else {
            this.addMVScalar();
        }
    }

    @Override
    public boolean updateValuesForField(String currentValue) {
        boolean bUpdated = false;
        FieldDefinition fieldDef = this.m_tableDef.getFieldDef(this.m_fieldName);
        bUpdated = fieldDef == null || !fieldDef.isCollection() ? this.updateSVScalar(currentValue) : this.updateMVScalar(currentValue);
        return bUpdated;
    }

    @Override
    public void deleteValuesForField() {
        this.deleteTermColumns(this.m_dbObj.getFieldValue(this.m_fieldName));
    }

    public static Set<String> mergeMVFieldValues(Collection<String> currValueSet, Collection<String> removeValueSet, Collection<String> newValueSet) {
        HashSet<String> resultSet = new HashSet<String>();
        if (currValueSet != null) {
            resultSet.addAll(currValueSet);
        }
        if (removeValueSet != null) {
            resultSet.removeAll(removeValueSet);
        }
        if (newValueSet != null) {
            resultSet.addAll(newValueSet);
        }
        return resultSet;
    }

    private void addFieldReference() {
        this.m_dbTran.addFieldReferences(this.m_tableDef, Arrays.asList(this.m_fieldName));
    }

    private void addFieldTermReferences(Set<String> termSet) {
        HashMap<String, Set<String>> fieldTermRefsMap = new HashMap<String, Set<String>>();
        fieldTermRefsMap.put(this.m_fieldName, termSet);
        this.m_dbTran.addTermReferences(this.m_tableDef, this.m_tableDef.getShardNumber(this.m_dbObj), fieldTermRefsMap);
    }

    private void addMVScalar() {
        HashSet values = new HashSet(this.m_dbObj.getFieldValues(this.m_fieldName));
        String fieldValue = Utils.concatenate(values, (String)"\ufffe");
        this.m_dbTran.addScalarValueColumn(this.m_tableDef, this.m_dbObj.getObjectID(), this.m_fieldName, fieldValue);
        this.addTermColumns(fieldValue);
    }

    private void addSVScalar() {
        String fieldValue = this.m_dbObj.getFieldValue(this.m_fieldName);
        this.m_dbTran.addScalarValueColumn(this.m_tableDef, this.m_dbObj.getObjectID(), this.m_fieldName, fieldValue);
        this.addTermColumns(fieldValue);
    }

    private void addTermColumns(String fieldValue) {
        Set<String> termSet = this.tokenize(fieldValue);
        this.indexTerms(termSet);
        this.addFieldTermReferences(termSet);
        this.addFieldReference();
    }

    private void indexTerms(Set<String> termSet) {
        for (String term : termSet) {
            this.m_dbTran.addTermIndexColumn(this.m_tableDef, this.m_dbObj, this.m_fieldName, term);
        }
    }

    private void deleteTermColumns(String fieldValue) {
        this.unindexTerms(fieldValue);
    }

    private void unindexTerms(String fieldValue) {
        for (String term : this.tokenize(fieldValue)) {
            this.unindexTerm(term);
        }
    }

    private void unindexTerm(String term) {
        this.m_dbTran.deleteTermIndexColumn(this.m_tableDef, this.m_dbObj, this.m_fieldName, term);
    }

    private Set<String> tokenize(String fieldValue) {
        FieldAnalyzer analyzer = FieldAnalyzer.findAnalyzer(this.m_tableDef, this.m_fieldName);
        return analyzer.extractTerms(fieldValue);
    }

    private boolean updateSVScalar(String currentValue) {
        String newValue = this.m_dbObj.getFieldValue(this.m_fieldName);
        boolean bUpdated = false;
        if (Utils.isEmpty((String)newValue)) {
            if (!Utils.isEmpty((String)currentValue)) {
                this.m_dbTran.deleteScalarValueColumn(this.m_tableDef, this.m_dbObj.getObjectID(), this.m_fieldName);
                this.unindexTerms(currentValue);
                bUpdated = true;
            }
        } else if (!newValue.equals(currentValue)) {
            this.updateScalarReplaceValue(currentValue, newValue);
            bUpdated = true;
        }
        return bUpdated;
    }

    private boolean updateMVScalar(String currentValue) {
        boolean bUpdated = false;
        Set currentValues = Utils.split((String)currentValue, (String)"\ufffe");
        Set<String> newValueSet = ScalarFieldUpdater.mergeMVFieldValues(currentValues, this.m_dbObj.getRemoveValues(this.m_fieldName), this.m_dbObj.getFieldValues(this.m_fieldName));
        String newValue = Utils.concatenate(newValueSet, (String)"\ufffe");
        if (!newValue.equals(currentValue)) {
            if (newValue.length() == 0) {
                this.m_dbTran.deleteScalarValueColumn(this.m_tableDef, this.m_dbObj.getObjectID(), this.m_fieldName);
                this.unindexTerms(currentValue);
            } else {
                this.updateScalarReplaceValue(currentValue, newValue);
            }
            bUpdated = true;
        }
        return bUpdated;
    }

    private void updateScalarReplaceValue(String currentValue, String newValue) {
        this.m_dbTran.addScalarValueColumn(this.m_tableDef, this.m_dbObj.getObjectID(), this.m_fieldName, newValue);
        Set<String> currTermSet = this.tokenize(Utils.isEmpty((String)currentValue) ? "" : currentValue);
        Set<String> newTermSet = this.tokenize(newValue);
        for (String term : currTermSet) {
            if (newTermSet.remove(term)) continue;
            this.unindexTerm(term);
        }
        this.indexTerms(newTermSet);
        this.addFieldTermReferences(newTermSet);
        if (Utils.isEmpty((String)currentValue)) {
            this.addFieldReference();
        }
    }
}

