/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.spider;

import com.dell.doradus.common.DBObject;
import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.ObjectResult;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.common.Utils;
import com.dell.doradus.core.IDGenerator;
import com.dell.doradus.service.spider.FieldUpdater;
import com.dell.doradus.service.spider.ScalarFieldUpdater;
import com.dell.doradus.service.spider.SpiderService;
import com.dell.doradus.service.spider.SpiderTransaction;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectUpdater {
    private final SpiderTransaction m_dbTran = new SpiderTransaction();
    private final TableDefinition m_tableDef;
    private Map<String, Map<String, Integer>> m_targetObjectShardNoMap;
    private static Logger m_logger = LoggerFactory.getLogger((String)ObjectUpdater.class.getSimpleName());

    public ObjectUpdater(TableDefinition tableDef) {
        this.m_tableDef = tableDef;
    }

    public TableDefinition getTableDef() {
        return this.m_tableDef;
    }

    public SpiderTransaction getTransaction() {
        return this.m_dbTran;
    }

    public Map<String, Map<String, Integer>> getTargetObjectShardNos() {
        return this.m_targetObjectShardNoMap;
    }

    public void setTargetObjectShardNumbers(Map<String, Map<String, Integer>> targObjShardNos) {
        this.m_targetObjectShardNoMap = targObjShardNos;
    }

    public ObjectResult addNewObject(SpiderTransaction parentTran, DBObject dbObj) {
        ObjectResult result = new ObjectResult();
        try {
            this.addBrandNewObject(dbObj);
            result.setObjectID(dbObj.getObjectID());
            result.setUpdated(true);
            parentTran.mergeSubTransaction(this.m_dbTran);
            m_logger.trace("addNewObject(): Object added/updated for ID={}", (Object)dbObj.getObjectID());
        }
        catch (Throwable ex) {
            this.buildErrorStatus(result, dbObj.getObjectID(), ex);
        }
        return result;
    }

    public ObjectResult deleteObject(SpiderTransaction parentTran, String objID) {
        ObjectResult result = new ObjectResult(objID);
        try {
            result.setObjectID(objID);
            DBObject dbObj = SpiderService.instance().getObject(this.m_tableDef, objID);
            if (dbObj != null) {
                this.deleteObject(dbObj);
                result.setUpdated(true);
                parentTran.mergeSubTransaction(this.m_dbTran);
                m_logger.trace("deleteObject(): object deleted with ID={}", (Object)objID);
            } else {
                result.setComment("Object not found");
                m_logger.trace("deleteObject(): no object with ID={}", (Object)objID);
            }
        }
        catch (Throwable ex) {
            this.buildErrorStatus(result, objID, ex);
        }
        return result;
    }

    public ObjectResult updateObject(SpiderTransaction parentTran, DBObject dbObj, Map<String, String> currScalarMap) {
        ObjectResult result = new ObjectResult();
        try {
            result.setObjectID(dbObj.getObjectID());
            boolean bUpdated = this.updateExistingObject(dbObj, currScalarMap);
            result.setUpdated(bUpdated);
            if (bUpdated) {
                m_logger.trace("updateObject(): object updated for ID={}", (Object)dbObj.getObjectID());
                parentTran.mergeSubTransaction(this.m_dbTran);
            } else {
                result.setComment("No updates made");
                m_logger.trace("updateObject(): no updates made for ID={}", (Object)dbObj.getObjectID());
            }
        }
        catch (Throwable ex) {
            this.buildErrorStatus(result, dbObj.getObjectID(), ex);
        }
        return result;
    }

    private boolean addBrandNewObject(DBObject dbObj) {
        if (Utils.isEmpty((String)dbObj.getObjectID())) {
            dbObj.setObjectID(Utils.base64FromBinary((byte[])IDGenerator.nextID()));
        }
        this.checkForNewShard(dbObj);
        for (String fieldName : dbObj.getUpdatedFieldNames()) {
            FieldUpdater fieldUpdater = FieldUpdater.createFieldUpdater(this, dbObj, fieldName);
            fieldUpdater.addValuesForField();
        }
        return true;
    }

    private void buildErrorStatus(ObjectResult result, String objID, Throwable ex) {
        result.setStatus(ObjectResult.Status.ERROR);
        result.setErrorMessage(ex.getLocalizedMessage());
        if (!Utils.isEmpty((String)objID)) {
            result.setObjectID(objID);
        }
        if (ex instanceof IllegalArgumentException) {
            m_logger.debug("Object update error: {}", (Object)ex.toString());
        } else {
            result.setStackTrace(Utils.getStackTrace((Throwable)ex));
            m_logger.debug("Object update error: {} stacktrace: {}", (Object)ex.toString(), (Object)Utils.getStackTrace((Throwable)ex));
        }
    }

    private void checkForNewShard(DBObject dbObj) {
        int shardNumber = this.m_tableDef.getShardNumber(dbObj);
        if (shardNumber > 0) {
            SpiderService.instance().verifyShard(this.m_tableDef, shardNumber);
        }
    }

    private void checkNewlySharded(DBObject dbObj, Map<String, String> currScalarMap) {
        if (!this.m_tableDef.isSharded()) {
            return;
        }
        String shardingFieldName = this.m_tableDef.getShardingField().getName();
        if (!currScalarMap.containsKey(shardingFieldName)) {
            this.m_dbTran.addAllObjectsColumn(this.m_tableDef, dbObj.getObjectID(), this.m_tableDef.getShardNumber(dbObj));
        }
    }

    private void deleteObject(DBObject dbObj) {
        for (String fieldName : dbObj.getUpdatedFieldNames()) {
            FieldUpdater fieldUpdater = FieldUpdater.createFieldUpdater(this, dbObj, fieldName);
            fieldUpdater.deleteValuesForField();
        }
        this.m_dbTran.deleteObjectRow(this.m_tableDef, dbObj.getObjectID());
    }

    private boolean updateExistingObject(DBObject dbObj, Map<String, String> currScalarMap) {
        if (this.objectIsChangingShards(dbObj, currScalarMap)) {
            return this.updateShardedObjectMove(dbObj);
        }
        return this.updateObjectSameShard(dbObj, currScalarMap);
    }

    private boolean updateObjectSameShard(DBObject dbObj, Map<String, String> currScalarMap) {
        boolean bUpdated = false;
        this.checkForNewShard(dbObj);
        this.checkNewlySharded(dbObj, currScalarMap);
        for (String fieldName : dbObj.getUpdatedFieldNames()) {
            FieldUpdater fieldUpdater = FieldUpdater.createFieldUpdater(this, dbObj, fieldName);
            bUpdated |= fieldUpdater.updateValuesForField(currScalarMap.get(fieldName));
        }
        return bUpdated;
    }

    private boolean updateShardedObjectMove(DBObject dbObj) {
        DBObject currDBObj = SpiderService.instance().getObject(this.m_tableDef, dbObj.getObjectID());
        m_logger.debug("Update forcing move of object {} from shard {} to shard {}", new Object[]{dbObj.getObjectID(), this.m_tableDef.getShardNumber(currDBObj), this.m_tableDef.getShardNumber(dbObj)});
        this.deleteObject(currDBObj);
        this.mergeAllFieldValues(dbObj, currDBObj);
        this.addBrandNewObject(currDBObj);
        return true;
    }

    private void mergeAllFieldValues(DBObject srcDBObj, DBObject tgtDBObj) {
        for (String fieldName : srcDBObj.getUpdatedFieldNames()) {
            FieldDefinition fieldDef = this.m_tableDef.getFieldDef(fieldName);
            if (fieldDef != null && (fieldDef.isCollection() || fieldDef.isLinkField())) {
                Set<String> newValueSet = ScalarFieldUpdater.mergeMVFieldValues(tgtDBObj.getFieldValues(fieldName), srcDBObj.getRemoveValues(fieldName), srcDBObj.getFieldValues(fieldName));
                tgtDBObj.clearValues(fieldName);
                tgtDBObj.addFieldValues(fieldName, newValueSet);
                continue;
            }
            tgtDBObj.clearValues(fieldName);
            tgtDBObj.addFieldValue(fieldName, srcDBObj.getFieldValue(fieldName));
        }
    }

    private boolean objectIsChangingShards(DBObject dbObj, Map<String, String> currScalarMap) {
        if (!this.m_tableDef.isSharded()) {
            return false;
        }
        int oldShardNumber = 0;
        String shardingFieldName = this.m_tableDef.getShardingField().getName();
        String currShardFieldValue = currScalarMap.get(shardingFieldName);
        if (currShardFieldValue != null) {
            oldShardNumber = this.m_tableDef.computeShardNumber(Utils.dateFromString((String)currShardFieldValue));
        }
        int newShardNumber = this.m_tableDef.getShardNumber(dbObj);
        String newShardFieldValue = dbObj.getFieldValue(shardingFieldName);
        if (newShardFieldValue == null && currShardFieldValue != null) {
            dbObj.addFieldValue(shardingFieldName, currShardFieldValue);
            return false;
        }
        return oldShardNumber != newShardNumber;
    }
}

