/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.spider;

import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.common.UNode;
import com.dell.doradus.common.Utils;
import com.dell.doradus.core.ServerConfig;
import com.dell.doradus.search.QueryExecutor;
import com.dell.doradus.search.SearchResultList;
import java.util.Map;

public class ObjectQuery {
    private final TableDefinition m_tableDef;
    private String m_text;
    private int m_pageSize = -1;
    private String m_continueID;
    private boolean m_bContinueAfter;
    private String m_fieldSet;
    private int m_skip = 0;
    private String m_sortOrder;
    private boolean m_l2rEnabled;

    public ObjectQuery(TableDefinition tableDef, UNode searchNode) throws IllegalArgumentException {
        this.m_l2rEnabled = ServerConfig.getInstance().l2r_enable;
        assert (tableDef != null);
        assert (searchNode != null);
        this.m_tableDef = tableDef;
        Utils.require((boolean)searchNode.getName().equals("search"), (String)("Root node should be called 'search': " + searchNode));
        for (UNode childNode : searchNode.getMemberList()) {
            Utils.require((boolean)childNode.isValue(), (String)("'search' parameter value must be text: " + childNode));
            String paramName = childNode.getName();
            String paramValue = childNode.getValue();
            if (paramName.equals("continue-after")) {
                Utils.require((this.m_continueID == null ? 1 : 0) != 0, (String)("Parameter can only be specified once: " + paramName));
                this.m_continueID = paramValue;
                this.m_bContinueAfter = true;
                continue;
            }
            if (paramName.equals("continue-at")) {
                Utils.require((this.m_continueID == null ? 1 : 0) != 0, (String)("Parameter can only be specified once: " + paramName));
                this.m_continueID = paramValue;
                this.m_bContinueAfter = false;
                continue;
            }
            if (paramName.equals("fields")) {
                Utils.require((this.m_fieldSet == null ? 1 : 0) != 0, (String)("Parameter can only be specified once: " + paramName));
                this.m_fieldSet = paramValue;
                continue;
            }
            if (paramName.equals("query")) {
                Utils.require((this.m_text == null ? 1 : 0) != 0, (String)("Parameter can only be specified once: " + paramName));
                this.m_text = paramValue;
                Utils.require((this.m_text != null && this.m_text.length() > 0 ? 1 : 0) != 0, (String)"'query' parameter cannot be empty");
                continue;
            }
            if (paramName.equals("skip")) {
                Utils.require((this.m_skip == 0 ? 1 : 0) != 0, (String)("Parameter can only be specified once: " + paramName));
                try {
                    this.m_skip = Integer.parseInt(paramValue);
                    if (this.m_skip >= 0) continue;
                    throw new Exception();
                }
                catch (Exception e) {
                    Utils.require((boolean)false, (String)("Invalid 'skip' value: " + paramValue));
                }
                continue;
            }
            if (paramName.equals("order")) {
                Utils.require((this.m_sortOrder == null ? 1 : 0) != 0, (String)("Parameter can only be specified once: " + paramName));
                this.m_sortOrder = paramValue;
                Utils.require((this.m_sortOrder != null && this.m_sortOrder.length() > 0 ? 1 : 0) != 0, (String)"'order' parameter cannot be empty");
                continue;
            }
            if (paramName.equals("size")) {
                Utils.require((this.m_pageSize == -1 ? 1 : 0) != 0, (String)("Parameter can only be specified once: " + paramName));
                try {
                    this.m_pageSize = Integer.parseInt(paramValue);
                    if (this.m_pageSize > 0) continue;
                    throw new Exception();
                }
                catch (Exception e) {
                    Utils.require((boolean)false, (String)("Invalid 'size' value: " + paramValue));
                }
                continue;
            }
            Utils.require((boolean)false, (String)("Unknown 'search' parameter: " + paramName));
        }
        Utils.require((this.m_text != null ? 1 : 0) != 0, (String)"'query' parameter is required in 'search' request");
        if (this.m_skip > 0) {
            Utils.require((this.m_sortOrder != null ? 1 : 0) != 0, (String)"'skip' parameter is only allowed for 'ordered' requests");
            Utils.require((this.m_continueID == null ? 1 : 0) != 0, (String)"'skip' parameter is not allowed for 'continuation' requests");
        }
    }

    public ObjectQuery(TableDefinition tableDef, String queryParam) throws IllegalArgumentException {
        this.m_l2rEnabled = ServerConfig.getInstance().l2r_enable;
        assert (tableDef != null);
        assert (queryParam != null && queryParam.length() > 0);
        this.m_tableDef = tableDef;
        Map paramMap = Utils.parseURIQuery((String)queryParam);
        for (Map.Entry mapEntry : paramMap.entrySet()) {
            String name = (String)mapEntry.getKey();
            String value = (String)mapEntry.getValue();
            if (name.equals("q")) {
                Utils.require((this.m_text == null ? 1 : 0) != 0, (String)("Query parameter can only be specified once: " + name));
                this.m_text = value;
                continue;
            }
            if (name.equals("s")) {
                Utils.require((this.m_pageSize == -1 ? 1 : 0) != 0, (String)("Query parameter can only be specified once: " + name));
                try {
                    this.m_pageSize = Integer.parseInt(value);
                    if (this.m_pageSize >= 0) continue;
                    throw new NumberFormatException();
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid pagesize value: " + name);
                }
            }
            if (name.equals("e")) {
                Utils.require((this.m_continueID == null ? 1 : 0) != 0, (String)("Query parameter can only be specified once: " + name));
                this.m_continueID = value;
                this.m_bContinueAfter = false;
                continue;
            }
            if (name.equals("g")) {
                Utils.require((this.m_continueID == null ? 1 : 0) != 0, (String)("Query parameter can only be specified once: " + name));
                this.m_continueID = value;
                this.m_bContinueAfter = true;
                continue;
            }
            if (name.equals("f")) {
                Utils.require((this.m_fieldSet == null ? 1 : 0) != 0, (String)("Query parameter can only be specified once: " + name));
                this.m_fieldSet = value;
                continue;
            }
            if (name.equals("k")) {
                Utils.require((this.m_skip == 0 ? 1 : 0) != 0, (String)("Query parameter can only be specified once: " + name));
                try {
                    this.m_skip = Integer.parseInt(value);
                    if (this.m_skip >= 0) continue;
                    throw new NumberFormatException();
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid skip value: " + name);
                }
            }
            if (name.equals("o")) {
                Utils.require((this.m_sortOrder == null ? 1 : 0) != 0, (String)("Query parameter can only be specified once: " + name));
                this.m_sortOrder = value;
                continue;
            }
            if (name.equals("l2r")) {
                this.m_l2rEnabled = "true".equals(value);
                continue;
            }
            throw new IllegalArgumentException("Unrecognized query parameter: " + name);
        }
        Utils.require((this.m_text != null ? 1 : 0) != 0, (String)"Query missing required parameter: 'q'");
        if (this.m_skip > 0) {
            Utils.require((this.m_sortOrder != null ? 1 : 0) != 0, (String)"'k' parameter is only allowed for 'ordered' requests");
            Utils.require((this.m_continueID == null ? 1 : 0) != 0, (String)"'k' parameter is not allowed for 'continuation' requests");
        }
    }

    public TableDefinition getTableDef() {
        return this.m_tableDef;
    }

    public String getContinueID() {
        return this.m_continueID;
    }

    public String getFieldSet() {
        return this.m_fieldSet;
    }

    public int getPageSize() {
        return this.m_pageSize;
    }

    public String getText() {
        return this.m_text;
    }

    public String getSortOrder() {
        return this.m_sortOrder;
    }

    public int getSkip() {
        return this.m_skip;
    }

    public boolean isContinueAfter() {
        return this.m_bContinueAfter;
    }

    public boolean isL2REnabled() {
        return this.m_l2rEnabled;
    }

    public SearchResultList query() {
        QueryExecutor query = new QueryExecutor(this.getTableDef());
        if (this.getPageSize() >= 0) {
            query.setPageSize(this.getPageSize());
        }
        if (this.getSkip() > 0) {
            query.setSkip(this.getSkip());
        }
        if (this.getContinueID() != null) {
            if (this.isContinueAfter()) {
                query.setContinueAfterID(this.getContinueID());
            } else {
                query.setContinueBeforeID(this.getContinueID());
            }
        }
        query.setL2rEnabled(this.isL2REnabled());
        return query.search(this.getText(), this.getFieldSet(), this.getSortOrder());
    }
}

