/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.spider;

import com.dell.doradus.common.DBObject;
import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.service.spider.FieldUpdater;
import com.dell.doradus.service.spider.ObjectUpdater;
import com.dell.doradus.service.spider.SpiderService;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LinkFieldUpdater
extends FieldUpdater {
    private final FieldDefinition m_linkDef;
    private final TableDefinition m_invTableDef;
    private final FieldDefinition m_invLinkDef;
    private final Map<String, Integer> m_targetObjShardNos;

    protected LinkFieldUpdater(ObjectUpdater objUpdater, DBObject dbObj, String fieldName) {
        super(objUpdater, dbObj, fieldName);
        Map<String, Map<String, Integer>> tableShardNoMap;
        this.m_linkDef = this.m_tableDef.getFieldDef(this.m_fieldName);
        this.m_invTableDef = this.m_linkDef.getInverseTableDef();
        this.m_invLinkDef = this.m_linkDef.getInverseLinkDef();
        this.m_targetObjShardNos = this.m_invTableDef.isSharded() ? ((tableShardNoMap = objUpdater.getTargetObjectShardNos()) != null ? tableShardNoMap.get(this.m_invTableDef.getTableName()) : null) : null;
    }

    @Override
    public void addValuesForField() {
        this.updateLinkAddValues();
    }

    @Override
    public boolean updateValuesForField(String currentValue) {
        boolean bUpdated = false;
        bUpdated |= this.updateLinkRemoveValues();
        return bUpdated |= this.updateLinkAddValues();
    }

    @Override
    public void deleteValuesForField() {
        for (String targetObjID : this.m_dbObj.getFieldValues(this.m_fieldName)) {
            this.deleteLinkInverseValue(targetObjID);
        }
        if (this.m_linkDef.isSharded()) {
            this.deleteShardedLinkTermRows();
        }
    }

    private void addInverseLinkValue(String targetObjID) {
        int shardNo = this.m_tableDef.getShardNumber(this.m_dbObj);
        if (shardNo > 0 && this.m_invLinkDef.isSharded()) {
            this.m_dbTran.addShardedLinkValue(targetObjID, this.m_invLinkDef, this.m_dbObj.getObjectID(), shardNo);
        } else {
            this.m_dbTran.addLinkValue(targetObjID, this.m_invLinkDef, this.m_dbObj.getObjectID());
        }
        this.m_dbTran.addIDValueColumn(this.m_invTableDef, targetObjID);
        int targetShardNo = this.getTargetObjectShardNumber(targetObjID);
        this.m_dbTran.addAllObjectsColumn(this.m_invTableDef, targetObjID, targetShardNo);
    }

    private void addLinkValue(String targetObjID) {
        int targetShardNo = this.getTargetObjectShardNumber(targetObjID);
        if (targetShardNo > 0 && this.m_linkDef.isSharded()) {
            this.m_dbTran.addShardedLinkValue(this.m_dbObj.getObjectID(), this.m_linkDef, targetObjID, targetShardNo);
        } else {
            this.m_dbTran.addLinkValue(this.m_dbObj.getObjectID(), this.m_linkDef, targetObjID);
        }
        this.addInverseLinkValue(targetObjID);
    }

    private int getTargetObjectShardNumber(String targetObjID) {
        int targetShardNo = 0;
        if (this.m_invTableDef.isSharded() && this.m_targetObjShardNos != null && this.m_targetObjShardNos.containsKey(targetObjID)) {
            targetShardNo = this.m_targetObjShardNos.get(targetObjID);
        }
        return targetShardNo;
    }

    private void deleteLinkInverseValue(String targetObjID) {
        int shardNo = this.m_tableDef.getShardNumber(this.m_dbObj);
        if (shardNo > 0 && this.m_invLinkDef.isSharded()) {
            this.m_dbTran.deleteShardedLinkValue(targetObjID, this.m_invLinkDef, this.m_dbObj.getObjectID(), shardNo);
        } else {
            this.m_dbTran.deleteLinkValue(targetObjID, this.m_invLinkDef, this.m_dbObj.getObjectID());
        }
    }

    private void deleteLinkValue(String targetObjID) {
        int targetShardNo = this.getTargetObjectShardNumber(targetObjID);
        if (targetShardNo > 0 && this.m_linkDef.isSharded()) {
            this.m_dbTran.deleteShardedLinkValue(targetObjID, this.m_linkDef, this.m_dbObj.getObjectID(), targetShardNo);
        } else {
            this.m_dbTran.deleteLinkValue(this.m_dbObj.getObjectID(), this.m_linkDef, targetObjID);
        }
        this.deleteLinkInverseValue(targetObjID);
    }

    private void deleteShardedLinkTermRows() {
        Set<Integer> shardNums = SpiderService.instance().getShards(this.m_invTableDef).keySet();
        for (Integer shardNumber : shardNums) {
            this.m_dbTran.deleteShardedLinkRow(this.m_linkDef, this.m_dbObj.getObjectID(), shardNumber);
        }
    }

    private boolean updateLinkAddValues() {
        List linkValues = this.m_dbObj.getFieldValues(this.m_linkDef.getName());
        if (linkValues == null || linkValues.size() == 0) {
            return false;
        }
        HashSet linkValueSet = new HashSet(linkValues);
        for (String targetObjID : linkValueSet) {
            this.addLinkValue(targetObjID);
        }
        return true;
    }

    private boolean updateLinkRemoveValues() {
        Set removeSet = this.m_dbObj.getRemoveValues(this.m_fieldName);
        List addSet = this.m_dbObj.getFieldValues(this.m_fieldName);
        if (removeSet != null && addSet != null) {
            removeSet.removeAll(addSet);
        }
        if (removeSet == null || removeSet.size() == 0) {
            return false;
        }
        for (String removeObjID : removeSet) {
            this.deleteLinkValue(removeObjID);
        }
        return true;
    }
}

