/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.spider;

import com.dell.doradus.common.DBObject;
import com.dell.doradus.common.Utils;
import com.dell.doradus.service.spider.ObjectUpdater;
import com.dell.doradus.service.spider.ScalarFieldUpdater;

public class IDFieldUpdater
extends ScalarFieldUpdater {
    protected IDFieldUpdater(ObjectUpdater objUpdater, DBObject dbObj) {
        super(objUpdater, dbObj, "_ID");
    }

    @Override
    public void addValuesForField() {
        String objID = this.m_dbObj.getObjectID();
        assert (!Utils.isEmpty((String)objID));
        this.m_dbTran.addIDValueColumn(this.m_tableDef, objID);
        this.m_dbTran.addAllObjectsColumn(this.m_tableDef, objID, this.m_tableDef.getShardNumber(this.m_dbObj));
    }

    @Override
    public void deleteValuesForField() {
        int shardNo = this.m_tableDef.getShardNumber(this.m_dbObj);
        this.m_dbTran.deleteAllObjectsColumn(this.m_tableDef, this.m_dbObj.getObjectID(), shardNo);
    }

    @Override
    public boolean updateValuesForField(String currentValue) {
        Utils.require((boolean)this.m_dbObj.getObjectID().equals(currentValue), (String)"Object ID cannot be changed");
        return false;
    }
}

