/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.spider;

import com.dell.doradus.common.DBObject;
import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.common.Utils;
import com.dell.doradus.service.spider.IDFieldUpdater;
import com.dell.doradus.service.spider.LinkFieldUpdater;
import com.dell.doradus.service.spider.NullFieldUpdater;
import com.dell.doradus.service.spider.ObjectUpdater;
import com.dell.doradus.service.spider.ScalarFieldUpdater;
import com.dell.doradus.service.spider.SpiderTransaction;

public abstract class FieldUpdater {
    protected final SpiderTransaction m_dbTran;
    protected final DBObject m_dbObj;
    protected final String m_fieldName;
    protected final TableDefinition m_tableDef;

    public static FieldUpdater createFieldUpdater(ObjectUpdater objUpdater, DBObject dbObj, String fieldName) {
        if (fieldName.charAt(0) == '_') {
            if (fieldName.equals("_ID")) {
                return new IDFieldUpdater(objUpdater, dbObj);
            }
            return new NullFieldUpdater(objUpdater, dbObj, fieldName);
        }
        TableDefinition tableDef = objUpdater.getTableDef();
        if (tableDef.isLinkField(fieldName)) {
            return new LinkFieldUpdater(objUpdater, dbObj, fieldName);
        }
        Utils.require((boolean)FieldDefinition.isValidFieldName((String)fieldName), (String)"Invalid field name: %s", (Object[])new Object[]{fieldName});
        return new ScalarFieldUpdater(objUpdater, dbObj, fieldName);
    }

    protected FieldUpdater(ObjectUpdater objUpdater, DBObject dbObj, String fieldName) {
        this.m_dbTran = objUpdater.getTransaction();
        this.m_tableDef = objUpdater.getTableDef();
        this.m_dbObj = dbObj;
        this.m_fieldName = fieldName;
    }

    public abstract void addValuesForField();

    public abstract boolean updateValuesForField(String var1);

    public abstract void deleteValuesForField();
}

