/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.spider;

import com.dell.doradus.common.BatchResult;
import com.dell.doradus.common.DBObject;
import com.dell.doradus.common.DBObjectBatch;
import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.ObjectResult;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.common.Utils;
import com.dell.doradus.core.ServerConfig;
import com.dell.doradus.service.db.DBService;
import com.dell.doradus.service.db.DBTransaction;
import com.dell.doradus.service.db.Tenant;
import com.dell.doradus.service.spider.ObjectUpdater;
import com.dell.doradus.service.spider.SpiderService;
import com.dell.doradus.service.spider.SpiderTransaction;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchObjectUpdater {
    private final SpiderTransaction m_parentTran = new SpiderTransaction();
    private final TableDefinition m_tableDef;
    private static Logger m_logger = LoggerFactory.getLogger((String)BatchObjectUpdater.class.getSimpleName());

    public BatchObjectUpdater(TableDefinition tableDef) {
        this.m_tableDef = tableDef;
    }

    public BatchResult addBatch(DBObjectBatch dbObjBatch) {
        Utils.require((dbObjBatch.getObjectCount() > 0 ? 1 : 0) != 0, (String)"Batch cannot be empty");
        BatchResult batchResult = new BatchResult();
        try {
            if (this.addOrUpdateBatch(dbObjBatch, batchResult)) {
                m_logger.debug("addBatch(): processed batch of {} objects", (Object)dbObjBatch.getObjectCount());
            } else {
                batchResult.setComment("No updates made");
                m_logger.debug("addBatch(): no updates made for {} objects", (Object)dbObjBatch.getObjectCount());
            }
        }
        catch (Throwable ex) {
            this.buildErrorStatus(batchResult, ex);
        }
        return batchResult;
    }

    public BatchResult updateBatch(DBObjectBatch dbObjBatch) {
        Utils.require((dbObjBatch.getObjectCount() > 0 ? 1 : 0) != 0, (String)"Batch cannot be empty");
        BatchResult batchResult = new BatchResult();
        try {
            if (this.updateBatch(dbObjBatch, batchResult)) {
                m_logger.debug("updateBatch(): processed batch of {} objects", (Object)dbObjBatch.getObjectCount());
            } else {
                batchResult.setComment("No updates made");
                m_logger.debug("updateBatch(): no updates made for {} objects", (Object)dbObjBatch.getObjectCount());
            }
        }
        catch (Throwable ex) {
            this.buildErrorStatus(batchResult, ex);
        }
        return batchResult;
    }

    public BatchResult deleteBatch(Set<String> objIDSet) {
        BatchResult batchResult = new BatchResult();
        try {
            for (String objID : objIDSet) {
                this.checkCommit();
                ObjectUpdater objUpdater = new ObjectUpdater(this.m_tableDef);
                ObjectResult objResult = objUpdater.deleteObject(this.m_parentTran, objID);
                batchResult.addObjectResult(objResult);
            }
            this.commitTransaction();
        }
        catch (Throwable ex) {
            this.buildErrorStatus(batchResult, ex);
        }
        return batchResult;
    }

    private void commitTransaction() {
        DBTransaction dbTran = DBService.instance().startTransaction(Tenant.getTenant(this.m_tableDef));
        this.m_parentTran.applyUpdates(dbTran);
        DBService.instance().commit(dbTran);
        this.m_parentTran.clear();
    }

    private boolean addOrUpdateBatch(DBObjectBatch dbObjBatch, BatchResult batchResult) throws IOException {
        Map<String, Map<String, String>> objCurrScalarMap = this.getCurrentScalars(dbObjBatch);
        Map<String, Map<String, Integer>> targObjShardNos = this.getLinkTargetShardNumbers(dbObjBatch);
        for (DBObject dbObj : dbObjBatch.getObjects()) {
            this.checkCommit();
            Map<String, String> currScalarMap = objCurrScalarMap.get(dbObj.getObjectID());
            ObjectResult objResult = this.addOrUpdateObject(dbObj, currScalarMap, targObjShardNos);
            batchResult.addObjectResult(objResult);
        }
        this.commitTransaction();
        return true;
    }

    private boolean updateBatch(DBObjectBatch dbObjBatch, BatchResult batchResult) throws IOException {
        Map<String, Map<String, String>> objCurrScalarMap = this.getCurrentScalars(dbObjBatch);
        Map<String, Map<String, Integer>> targObjShardNos = this.getLinkTargetShardNumbers(dbObjBatch);
        for (DBObject dbObj : dbObjBatch.getObjects()) {
            this.checkCommit();
            Map<String, String> currScalarMap = objCurrScalarMap.get(dbObj.getObjectID());
            ObjectResult objResult = this.updateObject(dbObj, currScalarMap, targObjShardNos);
            batchResult.addObjectResult(objResult);
        }
        this.commitTransaction();
        return batchResult.hasUpdates();
    }

    private ObjectResult updateObject(DBObject dbObj, Map<String, String> currScalarMap, Map<String, Map<String, Integer>> targObjShardNos) {
        ObjectResult objResult = null;
        if (Utils.isEmpty((String)dbObj.getObjectID())) {
            objResult = ObjectResult.newErrorResult((String)"Object ID is required", null);
        } else if (currScalarMap == null) {
            objResult = ObjectResult.newErrorResult((String)"No object found", (String)dbObj.getObjectID());
        } else {
            ObjectUpdater objUpdater = new ObjectUpdater(this.m_tableDef);
            if (targObjShardNos.size() > 0) {
                objUpdater.setTargetObjectShardNumbers(targObjShardNos);
            }
            objResult = objUpdater.updateObject(this.m_parentTran, dbObj, currScalarMap);
        }
        return objResult;
    }

    private ObjectResult addOrUpdateObject(DBObject dbObj, Map<String, String> currScalarMap, Map<String, Map<String, Integer>> targObjShardNos) throws IOException {
        ObjectUpdater objUpdater = new ObjectUpdater(this.m_tableDef);
        if (targObjShardNos.size() > 0) {
            objUpdater.setTargetObjectShardNumbers(targObjShardNos);
        }
        if (currScalarMap == null) {
            return objUpdater.addNewObject(this.m_parentTran, dbObj);
        }
        return objUpdater.updateObject(this.m_parentTran, dbObj, currScalarMap);
    }

    private void buildErrorStatus(BatchResult result, Throwable ex) {
        result.setStatus(BatchResult.Status.ERROR);
        result.setErrorMessage(ex.getLocalizedMessage());
        if (ex instanceof IllegalArgumentException) {
            m_logger.debug("Batch update error: {}", (Object)ex.toString());
        } else {
            result.setStackTrace(Utils.getStackTrace((Throwable)ex));
            m_logger.debug("Batch update error: {} stacktrace: {}", (Object)ex.toString(), (Object)Utils.getStackTrace((Throwable)ex));
        }
    }

    private void checkCommit() throws IOException {
        if (this.m_parentTran.getUpdateCount() >= ServerConfig.getInstance().batch_mutation_threshold) {
            this.commitTransaction();
        }
    }

    private Map<String, Map<String, String>> getCurrentScalars(DBObjectBatch dbObjBatch) throws IOException {
        HashSet<String> objIDSet = new HashSet<String>();
        HashSet<String> fieldNameSet = new HashSet<String>();
        for (DBObject dbObj : dbObjBatch.getObjects()) {
            if (Utils.isEmpty((String)dbObj.getObjectID())) continue;
            Utils.require((boolean)objIDSet.add(dbObj.getObjectID()), (String)("Cannot update the same object ID twice: " + dbObj.getObjectID()));
            fieldNameSet.addAll(dbObj.getUpdatedScalarFieldNames(this.m_tableDef));
        }
        if (this.m_tableDef.isSharded()) {
            fieldNameSet.add(this.m_tableDef.getShardingField().getName());
        }
        return SpiderService.instance().getObjectScalars(this.m_tableDef, objIDSet, fieldNameSet);
    }

    private Map<String, Map<String, Integer>> getLinkTargetShardNumbers(DBObjectBatch dbObjBatch) {
        HashMap<String, Map<String, Integer>> result = new HashMap<String, Map<String, Integer>>();
        Map<String, Set<String>> tableTargetObjIDMap = this.getAllLinkTargetObjIDs(dbObjBatch);
        for (String targetTableName : tableTargetObjIDMap.keySet()) {
            Map<String, Integer> shardNoMap = this.getShardNumbers(targetTableName, tableTargetObjIDMap.get(targetTableName));
            if (shardNoMap.size() <= 0) continue;
            HashMap<String, Integer> tableShardNoMap = (HashMap<String, Integer>)result.get(targetTableName);
            if (tableShardNoMap == null) {
                tableShardNoMap = new HashMap<String, Integer>();
                result.put(targetTableName, tableShardNoMap);
            }
            tableShardNoMap.putAll(shardNoMap);
        }
        return result;
    }

    private Map<String, Set<String>> getAllLinkTargetObjIDs(DBObjectBatch dbObjBatch) {
        HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>();
        for (FieldDefinition fieldDef : this.m_tableDef.getFieldDefinitions()) {
            Set<String> targObjIDs;
            if (!fieldDef.isLinkField() || !fieldDef.getInverseTableDef().isSharded() || (targObjIDs = this.getLinkTargetObjIDs(fieldDef, dbObjBatch)).size() == 0) continue;
            String targetTableName = fieldDef.getInverseTableDef().getTableName();
            HashSet<String> tableObjIDs = (HashSet<String>)resultMap.get(targetTableName);
            if (tableObjIDs == null) {
                tableObjIDs = new HashSet<String>();
                resultMap.put(targetTableName, tableObjIDs);
            }
            tableObjIDs.addAll(targObjIDs);
        }
        return resultMap;
    }

    private Set<String> getLinkTargetObjIDs(FieldDefinition linkDef, DBObjectBatch dbObjBatch) {
        HashSet<String> targObjIDs = new HashSet<String>();
        for (DBObject dbObj : dbObjBatch.getObjects()) {
            Set removeIDs;
            List objIDs = dbObj.getFieldValues(linkDef.getName());
            if (objIDs != null) {
                targObjIDs.addAll(objIDs);
            }
            if ((removeIDs = dbObj.getRemoveValues(linkDef.getName())) == null) continue;
            targObjIDs.addAll(removeIDs);
        }
        return targObjIDs;
    }

    private Map<String, Integer> getShardNumbers(String tableName, Set<String> targObjIDs) {
        TableDefinition tableDef = this.m_tableDef.getAppDef().getTableDef(tableName);
        FieldDefinition shardField = tableDef.getShardingField();
        Map<String, String> shardFieldMap = SpiderService.instance().getObjectScalar(tableDef, targObjIDs, shardField.getName());
        HashMap<String, Integer> shardNoMap = new HashMap<String, Integer>();
        for (String objID : shardFieldMap.keySet()) {
            Date shardingFieldDate = Utils.dateFromString((String)shardFieldMap.get(objID));
            int shardNo = tableDef.computeShardNumber(shardingFieldDate);
            shardNoMap.put(objID, shardNo);
        }
        return shardNoMap;
    }
}

