/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.schema;

import com.dell.doradus.common.ApplicationDefinition;
import com.dell.doradus.common.ContentType;
import com.dell.doradus.common.UNode;
import com.dell.doradus.common.Utils;
import com.dell.doradus.core.DoradusServer;
import com.dell.doradus.core.ServerConfig;
import com.dell.doradus.service.Service;
import com.dell.doradus.service.StorageService;
import com.dell.doradus.service.db.DBService;
import com.dell.doradus.service.db.DBTransaction;
import com.dell.doradus.service.db.DColumn;
import com.dell.doradus.service.db.DRow;
import com.dell.doradus.service.db.Tenant;
import com.dell.doradus.service.rest.RESTCommand;
import com.dell.doradus.service.rest.RESTService;
import com.dell.doradus.service.tenant.TenantService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SchemaService
extends Service {
    public static final String APPS_STORE_NAME = "Applications";
    private static final String COLNAME_APP_SCHEMA = "_application";
    private static final String COLNAME_APP_SCHEMA_FORMAT = "_format";
    private static final String COLNAME_APP_SCHEMA_VERSION = "_version";
    private static final SchemaService INSTANCE = new SchemaService();
    private static final int CURRENT_SCHEMA_LEVEL = 2;
    private static final List<RESTCommand> REST_RULES = Arrays.asList(new RESTCommand("GET    /_applications                     com.dell.doradus.service.schema.ListApplicationsCmd"), new RESTCommand("GET    /_applications/{application}       com.dell.doradus.service.schema.ListApplicationCmd"), new RESTCommand("POST   /_applications                     com.dell.doradus.service.schema.DefineApplicationCmd"), new RESTCommand("PUT    /_applications/{application}       com.dell.doradus.service.schema.ModifyApplicationCmd"), new RESTCommand("DELETE /_applications/{application}       com.dell.doradus.service.schema.DeleteApplicationCmd"), new RESTCommand("DELETE /_applications/{application}/{key} com.dell.doradus.service.schema.DeleteApplicationCmd"));

    public static SchemaService instance() {
        return INSTANCE;
    }

    @Override
    public void initService() {
        RESTService.instance().registerGlobalCommands(REST_RULES);
    }

    @Override
    public void startService() {
        TenantService.instance().waitForFullService();
        TenantService.instance().createDefaultTenant();
        this.checkAppStores();
    }

    @Override
    public void stopService() {
    }

    public void defineApplication(ApplicationDefinition appDef) {
        this.checkServiceState();
        Tenant tenant = TenantService.instance().getDefaultTenant();
        this.defineApplication(tenant, appDef);
    }

    public void defineApplication(Tenant tenant, ApplicationDefinition appDef) {
        this.checkServiceState();
        this.setTenant(appDef, tenant);
        ApplicationDefinition currAppDef = this.checkApplicationKey(appDef);
        StorageService storageService = this.verifyStorageServiceOption(currAppDef, appDef);
        storageService.validateSchema(appDef);
        this.initializeApplication(currAppDef, appDef);
    }

    public Collection<ApplicationDefinition> getAllApplications(Tenant tenant) {
        this.checkServiceState();
        return this.findAllApplications(tenant);
    }

    public ApplicationDefinition getApplication(String appName) {
        this.checkServiceState();
        Tenant tenant = TenantService.instance().getDefaultTenant();
        return this.getApplicationDefinition(tenant, appName);
    }

    public ApplicationDefinition getApplication(Tenant tenant, String appName) {
        this.checkServiceState();
        return this.getApplicationDefinition(tenant, appName);
    }

    public StorageService getStorageService(ApplicationDefinition appDef) {
        this.checkServiceState();
        String ssName = this.getStorageServiceOption(appDef);
        StorageService storageService = DoradusServer.instance().findStorageService(ssName);
        Utils.require((storageService != null ? 1 : 0) != 0, (String)("StorageService is unknown or hasn't been initialized: " + ssName));
        return storageService;
    }

    public String getStorageServiceOption(ApplicationDefinition appDef) {
        String ssName = appDef.getOption("StorageService");
        if (Utils.isEmpty((String)ssName)) {
            ssName = DoradusServer.instance().getDefaultStorageService();
            appDef.setOption("StorageService", ssName);
        }
        return ssName;
    }

    public void deleteApplication(String appName) {
        this.checkServiceState();
        ApplicationDefinition appDef = this.getApplication(appName);
        if (appDef == null) {
            return;
        }
        this.deleteApplication(appName, appDef.getKey());
    }

    public void deleteApplication(String appName, String key) {
        this.checkServiceState();
        ApplicationDefinition appDef = this.getApplication(appName);
        if (appDef == null) {
            return;
        }
        this.deleteApplication(appDef, key);
    }

    public void deleteApplication(ApplicationDefinition appDef, String key) {
        this.checkServiceState();
        String appKey = appDef.getKey();
        if (Utils.isEmpty((String)appKey)) {
            Utils.require((boolean)Utils.isEmpty((String)key), (String)"Application key does not match: %s", (Object[])new Object[]{key});
        } else {
            Utils.require((boolean)appKey.equals(key), (String)"Application key does not match: %s", (Object[])new Object[]{key});
        }
        assert (Tenant.getTenant(appDef) != null);
        this.m_logger.info("Deleting application: {}", (Object)appDef.getAppName());
        StorageService storageService = this.getStorageService(appDef);
        storageService.deleteApplication(appDef);
        this.deleteAppProperties(appDef);
    }

    private SchemaService() {
    }

    private void checkAppStores() {
        this.m_logger.info("The following tenants and applications are defined:");
        Collection<Tenant> tenantList = TenantService.instance().getTenants();
        for (Tenant tenant : tenantList) {
            this.m_logger.info("   Tenant: {}", (Object)tenant.getKeyspace());
            Iterator<DRow> rowIter = DBService.instance().getAllRowsAllColumns(tenant, APPS_STORE_NAME);
            if (!rowIter.hasNext()) {
                this.m_logger.info("      <no applications>");
            }
            while (rowIter.hasNext()) {
                DRow row = rowIter.next();
                ApplicationDefinition appDef = this.loadAppRow(tenant, this.getColumnMap(row.getColumns()));
                if (appDef == null) continue;
                String appName = appDef.getAppName();
                String ssName = this.getStorageServiceOption(appDef);
                this.m_logger.info("      Application '{}': StorageService={}; keyspace={}", new Object[]{appName, ssName, tenant.getKeyspace()});
                if (DoradusServer.instance().findStorageService(ssName) != null) continue;
                this.m_logger.warn("      >>>Application '{}' uses storage service '{}' which has not been initialized; application will not be accessible via this server", (Object)appDef.getAppName(), (Object)ssName);
            }
        }
        if (tenantList.size() == 0) {
            this.m_logger.info("   <no tenants>");
        }
    }

    private void deleteAppProperties(ApplicationDefinition appDef) {
        Tenant tenant = Tenant.getTenant(appDef);
        DBTransaction dbTran = DBService.instance().startTransaction(tenant);
        dbTran.deleteRow(APPS_STORE_NAME, appDef.getAppName());
        DBService.instance().commit(dbTran);
    }

    private void initializeApplication(ApplicationDefinition currAppDef, ApplicationDefinition appDef) {
        Tenant tenant = Tenant.getTenant(appDef);
        if (tenant.getKeyspace().equals(ServerConfig.getInstance().keyspace)) {
            TenantService.instance().createDefaultTenant();
        }
        this.storeApplicationSchema(appDef);
        this.getStorageService(appDef).initializeApplication(currAppDef, appDef);
    }

    private void storeApplicationSchema(ApplicationDefinition appDef) {
        String appName = appDef.getAppName();
        Tenant tenant = Tenant.getTenant(appDef);
        DBTransaction dbTran = DBService.instance().startTransaction(tenant);
        dbTran.addColumn(APPS_STORE_NAME, appName, COLNAME_APP_SCHEMA, appDef.toDoc().toJSON());
        dbTran.addColumn(APPS_STORE_NAME, appName, COLNAME_APP_SCHEMA_FORMAT, ContentType.APPLICATION_JSON.toString());
        dbTran.addColumn(APPS_STORE_NAME, appName, COLNAME_APP_SCHEMA_VERSION, Integer.toString(2));
        DBService.instance().commit(dbTran);
    }

    private ApplicationDefinition checkApplicationKey(ApplicationDefinition appDef) {
        Tenant tenant = Tenant.getTenant(appDef);
        ApplicationDefinition currAppDef = this.getApplication(tenant, appDef.getAppName());
        if (currAppDef == null) {
            this.m_logger.info("Defining application: {}", (Object)appDef.getAppName());
        } else {
            this.m_logger.info("Updating application: {}", (Object)appDef.getAppName());
            String appKey = currAppDef.getKey();
            Utils.require((Utils.isEmpty((String)appKey) || appKey.equals(appDef.getKey()) ? 1 : 0) != 0, (String)"Application key cannot be changed: %s", (Object[])new Object[]{appDef.getKey()});
        }
        return currAppDef;
    }

    private void setTenant(ApplicationDefinition appDef, Tenant tenant) {
        appDef.setOption("Tenant", tenant.getKeyspace());
    }

    private StorageService verifyStorageServiceOption(ApplicationDefinition currAppDef, ApplicationDefinition appDef) {
        String ssName = this.getStorageServiceOption(appDef);
        StorageService storageService = this.getStorageService(appDef);
        Utils.require((storageService != null ? 1 : 0) != 0, (String)"StorageService is unknown or hasn't been initialized: %s", (Object[])new Object[]{ssName});
        if (currAppDef != null) {
            String currSSName = this.getStorageServiceOption(currAppDef);
            Utils.require((boolean)currSSName.equals(ssName), (String)"'StorageService' cannot be changed for application: %s", (Object[])new Object[]{appDef.getAppName()});
        }
        return storageService;
    }

    private Map<String, String> getColumnMap(Iterator<DColumn> colIter) {
        HashMap<String, String> colMap = new HashMap<String, String>();
        while (colIter.hasNext()) {
            DColumn col = colIter.next();
            colMap.put(col.getName(), col.getValue());
        }
        return colMap;
    }

    private ApplicationDefinition loadAppRow(Tenant tenant, Map<String, String> colMap) {
        int schemaVersion;
        ApplicationDefinition appDef = new ApplicationDefinition();
        String appSchema = colMap.get(COLNAME_APP_SCHEMA);
        if (appSchema == null) {
            return null;
        }
        String format = colMap.get(COLNAME_APP_SCHEMA_FORMAT);
        ContentType contentType = Utils.isEmpty((String)format) ? ContentType.TEXT_XML : new ContentType(format);
        String versionStr = colMap.get(COLNAME_APP_SCHEMA_VERSION);
        int n = schemaVersion = Utils.isEmpty((String)versionStr) ? 2 : Integer.parseInt(versionStr);
        if (schemaVersion > 2) {
            this.m_logger.warn("Skipping schema with advanced version: {}", (Object)schemaVersion);
            return null;
        }
        try {
            appDef.parse(UNode.parse((String)appSchema, (ContentType)contentType));
        }
        catch (Exception e) {
            this.m_logger.warn("Error parsing schema for application '" + appDef.getAppName() + "'; skipped", (Throwable)e);
            return null;
        }
        this.setTenant(appDef, tenant);
        return appDef;
    }

    private ApplicationDefinition getApplicationDefinition(Tenant tenant, String appName) {
        Iterator<DColumn> colIter = DBService.instance().getAllColumns(tenant, APPS_STORE_NAME, appName);
        if (colIter == null) {
            return null;
        }
        return this.loadAppRow(tenant, this.getColumnMap(colIter));
    }

    private Collection<ApplicationDefinition> findAllApplications(Tenant tenant) {
        ArrayList<ApplicationDefinition> result = new ArrayList<ApplicationDefinition>();
        Iterator<DRow> rowIter = DBService.instance().getAllRowsAllColumns(tenant, APPS_STORE_NAME);
        while (rowIter.hasNext()) {
            DRow row = rowIter.next();
            ApplicationDefinition appDef = this.loadAppRow(tenant, this.getColumnMap(row.getColumns()));
            if (appDef == null) continue;
            result.add(appDef);
        }
        return result;
    }
}

