/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.rest;

import com.dell.doradus.common.ApplicationDefinition;
import com.dell.doradus.common.HttpCode;
import com.dell.doradus.common.Pair;
import com.dell.doradus.common.RESTResponse;
import com.dell.doradus.common.Utils;
import com.dell.doradus.service.db.DBNotAvailableException;
import com.dell.doradus.service.db.DuplicateException;
import com.dell.doradus.service.db.Tenant;
import com.dell.doradus.service.db.UnauthorizedException;
import com.dell.doradus.service.rest.NotFoundException;
import com.dell.doradus.service.rest.RESTCallback;
import com.dell.doradus.service.rest.RESTCommand;
import com.dell.doradus.service.rest.RESTRequest;
import com.dell.doradus.service.rest.RESTService;
import com.dell.doradus.service.schema.SchemaService;
import com.dell.doradus.service.tenant.TenantService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final Logger m_logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getSimpleName());

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            long startNano = System.nanoTime();
            RESTService.instance().onNewrequest();
            RESTResponse restResponse = this.validateAndExecuteRequest(request);
            if (restResponse.getCode().getCode() >= 300) {
                RESTService.instance().onRequestRejected(restResponse.getCode().toString());
            } else {
                RESTService.instance().onRequestSuccess(startNano);
            }
            this.sendResponse(response, restResponse);
            this.m_logger.debug("Elapsed time: {} millis; request={}", (Object)Float.valueOf((float)(System.nanoTime() - startNano) / 1000000.0f), (Object)this.getFullURI(request));
        }
        catch (IllegalArgumentException e) {
            RESTResponse restResponse = new RESTResponse(HttpCode.BAD_REQUEST, e.getMessage());
            this.m_logger.info("Returning client error: {}; request: {}", (Object)restResponse.toString(), (Object)this.getFullURI(request));
            RESTService.instance().onRequestRejected(restResponse.getCode().toString());
            this.sendResponse(response, restResponse);
        }
        catch (NotFoundException e) {
            RESTResponse restResponse = new RESTResponse(HttpCode.NOT_FOUND, e.getMessage());
            this.m_logger.info("Returning client error: {}; request: {}", (Object)restResponse.toString(), (Object)this.getFullURI(request));
            RESTService.instance().onRequestRejected(restResponse.getCode().toString());
            this.sendResponse(response, restResponse);
        }
        catch (DBNotAvailableException e) {
            RESTResponse restResponse = new RESTResponse(HttpCode.SERVICE_UNAVAILABLE, e.getMessage());
            this.m_logger.info("Returning service error: {}; request: {}", (Object)restResponse.toString(), (Object)this.getFullURI(request));
            RESTService.instance().onRequestRejected(restResponse.getCode().toString());
            this.sendResponse(response, restResponse);
        }
        catch (UnauthorizedException e) {
            RESTResponse restResponse = new RESTResponse(HttpCode.UNAUTHORIZED, e.getMessage());
            this.m_logger.info("Returning client error: {}; request: {}", (Object)restResponse.toString(), (Object)this.getFullURI(request));
            RESTService.instance().onRequestRejected(restResponse.getCode().toString());
            this.sendResponse(response, restResponse);
        }
        catch (DuplicateException e) {
            RESTResponse restResponse = new RESTResponse(HttpCode.CONFLICT, e.getMessage());
            this.m_logger.info("Returning client error: {}; request: {}", (Object)restResponse.toString(), (Object)this.getFullURI(request));
            RESTService.instance().onRequestRejected(restResponse.getCode().toString());
            this.sendResponse(response, restResponse);
        }
        catch (Throwable e) {
            this.m_logger.error("Unexpected exception handling request: " + this.getFullURI(request), e);
            String stackTrace = Utils.getStackTrace((Throwable)e);
            RESTResponse restResponse = new RESTResponse(HttpCode.INTERNAL_ERROR, stackTrace);
            RESTService.instance().onRequestFailed(e);
            this.sendResponse(response, restResponse);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private RESTResponse validateAndExecuteRequest(HttpServletRequest request) {
        HashMap<String, String> variableMap = new HashMap<String, String>();
        String query = this.extractQueryParam(request, variableMap);
        Tenant tenant = this.getTenant(variableMap);
        String uri = request.getPathInfo();
        ApplicationDefinition appDef = this.getApplication(uri, tenant);
        RESTCommand cmd = RESTService.instance().matchCommand(appDef, request.getMethod(), uri, query, variableMap);
        if (cmd == null) {
            throw new NotFoundException("Request does not match a known URI: " + request.getRequestURL());
        }
        this.validateTenantAccess(request, tenant, cmd);
        RESTRequest restRequest = new RESTRequest(tenant, appDef, request, variableMap);
        RESTCallback callback = cmd.getNewCallback(restRequest);
        return callback.invoke();
    }

    private ApplicationDefinition getApplication(String uri, Tenant tenant) {
        if (uri.length() < 2 || uri.startsWith("/_")) {
            return null;
        }
        String[] pathNodes = uri.substring(1).split("/");
        String appName = Utils.urlDecode((String)pathNodes[0]);
        ApplicationDefinition appDef = SchemaService.instance().getApplication(tenant, appName);
        if (appDef == null) {
            throw new NotFoundException("Unknown application: " + appName);
        }
        return appDef;
    }

    private Tenant getTenant(Map<String, String> variableMap) {
        String tenantName = variableMap.get("tenant");
        if (Utils.isEmpty((String)tenantName)) {
            return TenantService.instance().getDefaultTenant();
        }
        return new Tenant(tenantName);
    }

    private void validateTenantAccess(HttpServletRequest request, Tenant tenant, RESTCommand cmd) {
        String authString = request.getHeader("Authorization");
        StringBuilder userID = new StringBuilder();
        StringBuilder password = new StringBuilder();
        this.decodeAuthorizationHeader(authString, userID, password);
        TenantService.instance().validateTenantAuthorization(tenant, userID.toString(), password.toString(), cmd);
    }

    private void decodeAuthorizationHeader(String authString, StringBuilder userID, StringBuilder password) {
        userID.setLength(0);
        password.setLength(0);
        if (!Utils.isEmpty((String)authString) && authString.toLowerCase().startsWith("basic ")) {
            String decoded = Utils.base64ToString((String)authString.substring("basic ".length()));
            int inx = decoded.indexOf(58);
            if (inx < 0) {
                userID.append(decoded);
            } else {
                userID.append(decoded.substring(0, inx));
                password.append(decoded.substring(inx + 1));
            }
        }
    }

    private void sendResponse(HttpServletResponse servletResponse, RESTResponse restResponse) throws IOException {
        byte[] bodyBytes;
        servletResponse.setStatus(restResponse.getCode().getCode());
        Map responseHeaders = restResponse.getHeaders();
        if (responseHeaders != null) {
            for (Map.Entry mapEntry : responseHeaders.entrySet()) {
                if (((String)mapEntry.getKey()).equalsIgnoreCase("CONTENT-TYPE")) {
                    servletResponse.setContentType((String)mapEntry.getValue());
                    continue;
                }
                servletResponse.setHeader((String)mapEntry.getKey(), (String)mapEntry.getValue());
            }
        }
        int bodyLen = (bodyBytes = restResponse.getBodyBytes()) == null ? 0 : bodyBytes.length;
        servletResponse.setContentLength(bodyLen);
        if (bodyLen > 0 && servletResponse.getContentType() == null) {
            servletResponse.setContentType("text/plain");
        }
        if (bodyLen > 0) {
            servletResponse.getOutputStream().write(restResponse.getBodyBytes());
        }
    }

    private String extractQueryParam(HttpServletRequest request, Map<String, String> restParams) {
        String query = request.getQueryString();
        if (Utils.isEmpty((String)query)) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(query);
        String[] parts = Utils.splitURIQuery((String)buffer.toString());
        ArrayList<Pair<String, String>> unusedList = new ArrayList<Pair<String, String>>();
        boolean bRewrite = false;
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            Pair<String, String> param = this.extractParam(string);
            switch (((String)param.firstItemInPair).toLowerCase()) {
                case "api": {
                    bRewrite = true;
                    restParams.put("api", (String)param.secondItemInPair);
                    break;
                }
                case "format": {
                    bRewrite = true;
                    if (((String)param.secondItemInPair).equalsIgnoreCase("xml")) {
                        restParams.put("format", "text/xml");
                        break;
                    }
                    if (!((String)param.secondItemInPair).equalsIgnoreCase("json")) break;
                    restParams.put("format", "application/json");
                    break;
                }
                case "tenant": {
                    bRewrite = true;
                    restParams.put("tenant", (String)param.secondItemInPair);
                    break;
                }
                default: {
                    unusedList.add(param);
                }
            }
            ++n2;
        }
        if (bRewrite) {
            buffer.setLength(0);
            for (Pair pair : unusedList) {
                if (buffer.length() > 0) {
                    buffer.append("&");
                }
                buffer.append(Utils.urlEncode((String)((String)pair.firstItemInPair)));
                if (pair.secondItemInPair == null) continue;
                buffer.append("=");
                buffer.append(Utils.urlEncode((String)((String)pair.secondItemInPair)));
            }
        }
        return buffer.toString();
    }

    private Pair<String, String> extractParam(String part) {
        String paramValue;
        String paramName;
        int eqInx = part.indexOf(61);
        if (eqInx < 0) {
            paramName = part;
            paramValue = null;
        } else {
            paramName = part.substring(0, eqInx);
            paramValue = part.substring(eqInx + 1);
        }
        return Pair.create((Object)paramName, paramValue);
    }

    private String getFullURI(HttpServletRequest request) {
        StringBuilder buffer = new StringBuilder(request.getMethod());
        buffer.append(" ");
        buffer.append(request.getRequestURI());
        String queryParam = request.getQueryString();
        if (!Utils.isEmpty((String)queryParam)) {
            buffer.append("?");
            buffer.append(queryParam);
        }
        return buffer.toString();
    }
}

