/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.rest;

import com.dell.doradus.common.ApplicationDefinition;
import com.dell.doradus.core.ServerConfig;
import com.dell.doradus.service.Service;
import com.dell.doradus.service.StorageService;
import com.dell.doradus.service.rest.RESTCommand;
import com.dell.doradus.service.rest.RESTCommandSet;
import com.dell.doradus.service.rest.RESTServlet;
import com.dell.doradus.service.rest.WebServer;
import com.dell.doradus.service.schema.SchemaService;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;

public class RESTService
extends Service {
    private static final RESTService INSTANCE = new RESTService();
    private WebServer m_webservice;
    private final RESTCommandSet m_commandSet = new RESTCommandSet();

    public static RESTService instance() {
        return INSTANCE;
    }

    @Override
    public void initService() {
        boolean loadWebServer = ServerConfig.getInstance().load_webserver;
        if (loadWebServer) {
            try {
                Class<?> serviceClass = Class.forName(ServerConfig.getInstance().webserver_class);
                Method instanceMethod = serviceClass.getMethod("instance", null);
                this.m_webservice = (WebServer)instanceMethod.invoke(null, null);
                this.m_webservice.init(RESTServlet.class.getName());
            }
            catch (Exception e) {
                throw new RuntimeException("Error initializing WebServer: " + ServerConfig.getInstance().webserver_class, e);
            }
        }
    }

    @Override
    public void startService() {
        this.m_commandSet.freezeCommandSet(true);
        this.displayCommandSet();
        try {
            if (this.m_webservice != null) {
                this.m_webservice.start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start WebService", e);
        }
    }

    @Override
    public void stopService() {
        try {
            if (this.m_webservice != null) {
                this.m_webservice.stop();
            }
        }
        catch (Exception e) {
            this.m_logger.warn("WebService stop failed", (Throwable)e);
        }
        this.m_commandSet.clear();
    }

    public void registerRequestCallback(RequestCallback callback) {
        if (this.m_webservice != null) {
            this.m_webservice.registerRequestCallback(callback);
        }
    }

    public void registerGlobalCommands(Iterable<RESTCommand> restCommands) {
        this.m_commandSet.addCommands(null, restCommands);
    }

    public void registerApplicationCommands(Iterable<RESTCommand> restCommands, StorageService service) {
        assert (service != null);
        this.m_commandSet.addCommands(service.getClass().getSimpleName(), restCommands);
    }

    public void registerApplicationCommands(Iterable<RESTCommand> restCommands, StorageService service, StorageService parentService) {
        assert (service != null);
        this.m_commandSet.setParent(service.getClass().getSimpleName(), parentService.getClass().getSimpleName());
        this.m_commandSet.addCommands(service.getClass().getSimpleName(), restCommands);
    }

    public RESTCommand matchCommand(ApplicationDefinition appDef, String method, String uri, String query, Map<String, String> variableMap) {
        String cmdOwner = null;
        if (appDef != null) {
            StorageService ss = SchemaService.instance().getStorageService(appDef);
            cmdOwner = ss.getClass().getSimpleName();
        }
        return this.m_commandSet.findMatch(cmdOwner, method, uri, query, variableMap);
    }

    void onNewrequest() {
        if (this.m_webservice != null) {
            this.m_webservice.notifyNewRequest();
        }
    }

    void onRequestSuccess(long startTimeNanos) {
        if (this.m_webservice != null) {
            this.m_webservice.notifyRequestSuccess(startTimeNanos);
        }
    }

    void onRequestRejected(String reason) {
        if (this.m_webservice != null) {
            this.m_webservice.notifyRequestRejected(reason);
        }
    }

    void onRequestFailed(Throwable e) {
        if (this.m_webservice != null) {
            this.m_webservice.notifyRequestFailed(e);
        }
    }

    private RESTService() {
    }

    private void displayCommandSet() {
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug("Registered REST Commands:");
            Collection<String> commands = this.m_commandSet.getCommands();
            for (String command : commands) {
                this.m_logger.debug(command);
            }
        }
    }

    public static interface RequestCallback {
        public void onConnectionOpened();

        public void onConnectionClosed();

        public void onNewRequest();

        public void onRequestSucceeded(long var1);

        public void onRequestRejected(String var1);

        public void onRequestFailed(Throwable var1);
    }
}

