/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.rest;

import com.dell.doradus.common.ApplicationDefinition;
import com.dell.doradus.common.ContentType;
import com.dell.doradus.common.HttpMethod;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.common.Utils;
import com.dell.doradus.service.db.Tenant;
import com.dell.doradus.service.rest.NotFoundException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class RESTRequest {
    private final HttpServletRequest m_request;
    private final Map<String, String> m_variableMap;
    private final Tenant m_tenant;
    private final ApplicationDefinition m_appDef;
    private ContentType m_contentTypeIn;
    private ContentType m_contentTypeOut;
    private byte[] m_requestEntity;
    private boolean m_bEntityCompressed;

    public RESTRequest(Tenant tenant, ApplicationDefinition appDef, HttpServletRequest request, Map<String, String> variableMap) {
        this.m_tenant = tenant;
        this.m_appDef = appDef;
        this.m_request = request;
        this.m_variableMap = variableMap;
        this.setRequestMembers();
    }

    public ApplicationDefinition getAppDef() throws NotFoundException {
        if (this.m_appDef == null) {
            throw new RuntimeException("getAppDef() called for non-application command");
        }
        return this.m_appDef;
    }

    public TableDefinition getTableDef(ApplicationDefinition appDef) {
        assert (appDef != null);
        String table = this.getVariableDecoded("table");
        if (Utils.isEmpty((String)table)) {
            throw new RuntimeException("Missing {table} variable");
        }
        TableDefinition tableDef = this.m_appDef.getTableDef(table);
        if (tableDef == null) {
            throw new IllegalArgumentException("Unknown table for application '" + this.m_appDef.getAppName() + "': " + table);
        }
        return tableDef;
    }

    public Tenant getTenant() {
        return this.m_tenant;
    }

    public Map<String, String> getVariables() {
        return this.m_variableMap;
    }

    public String getVariable(String variableName) {
        return this.m_variableMap.get(variableName);
    }

    public String getVariableDecoded(String variableName) {
        String value = this.m_variableMap.get(variableName);
        if (value == null) {
            return null;
        }
        return Utils.urlDecode((String)value);
    }

    public int getContentLength() {
        return this.m_request.getContentLength();
    }

    public ContentType getInputContentType() {
        return this.m_contentTypeIn;
    }

    public ContentType getOutputContentType() {
        return this.m_contentTypeOut;
    }

    public String getInputBody() {
        if (this.m_requestEntity.length == 0 || !this.m_bEntityCompressed) {
            return Utils.toString((byte[])this.m_requestEntity);
        }
        try {
            return Utils.toString((byte[])Utils.decompressGZIP((byte[])this.m_requestEntity));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error decompressing input: " + e.toString());
        }
    }

    public InputStream getInputStream() {
        ByteArrayInputStream bis;
        if (this.m_requestEntity.length == 0) {
            return null;
        }
        InputStream inStream = bis = new ByteArrayInputStream(this.m_requestEntity);
        if (this.m_bEntityCompressed) {
            try {
                inStream = new GZIPInputStream(bis);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error decompressing input: " + e.toString());
            }
        }
        return inStream;
    }

    public HttpMethod getMethod() {
        return HttpMethod.methodFromString((String)this.m_request.getMethod());
    }

    public String getRequestHeader(String headerName) {
        return this.m_request.getHeader(headerName);
    }

    private void setRequestMembers() {
        this.m_contentTypeIn = this.getContentType();
        this.m_contentTypeOut = this.getAcceptType();
        this.m_requestEntity = this.readRequestBody();
        this.m_bEntityCompressed = this.isMessageCompressed();
    }

    private ContentType getContentType() {
        String contentTypeValue = this.m_request.getContentType();
        if (contentTypeValue == null) {
            return ContentType.TEXT_XML;
        }
        return new ContentType(contentTypeValue);
    }

    private ContentType getAcceptType() {
        String format = this.m_variableMap.get("format");
        if (format != null) {
            return new ContentType(format);
        }
        String acceptParts = this.m_request.getHeader("ACCEPT");
        if (!Utils.isEmpty((String)acceptParts)) {
            String[] stringArray = acceptParts.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String acceptPart = stringArray[n2];
                ContentType acceptType = new ContentType(acceptPart);
                if (acceptType.isJSON() || acceptType.isXML() || acceptType.isPlainText()) {
                    return acceptType;
                }
                ++n2;
            }
        }
        return this.getContentType();
    }

    private boolean isMessageCompressed() {
        String contentEncoding = this.m_request.getHeader("CONTENT-ENCODING");
        if (contentEncoding != null) {
            if (!contentEncoding.equalsIgnoreCase("gzip")) {
                throw new IllegalArgumentException("Unsupported Content-Encoding: " + contentEncoding);
            }
            return true;
        }
        return false;
    }

    private byte[] readRequestBody() {
        int bytesLeft = this.m_request.getContentLength();
        if (bytesLeft <= 0) {
            return new byte[0];
        }
        int totalBytesRead = 0;
        try {
            byte[] byteBuffer = new byte[bytesLeft];
            Throwable throwable = null;
            Object var5_8 = null;
            try (ServletInputStream inputStream = this.m_request.getInputStream();){
                int bytesRead = -1;
                int offset = 0;
                while ((bytesRead = inputStream.read(byteBuffer, offset, bytesLeft)) > 0) {
                    offset += bytesRead;
                    bytesLeft -= bytesRead;
                    totalBytesRead += bytesRead;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return byteBuffer;
        }
        catch (IOException e) {
            String errMsg = String.format("Error reading from input request; expected %d bytes; only read %d bytes", this.m_request.getContentLength(), totalBytesRead);
            throw new RuntimeException(errMsg, e);
        }
    }
}

