/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.rest;

import com.dell.doradus.common.Utils;
import com.dell.doradus.service.rest.RESTCommand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class RESTCommandSet {
    private static final String SYSTEM_OWNER = "_";
    private final Map<String, Map<String, SortedSet<RESTCommand>>> m_cmdMap = new HashMap<String, Map<String, SortedSet<RESTCommand>>>();
    private final Map<String, String> m_parentMap = new HashMap<String, String>();
    private boolean m_bCmdSetIsFrozen;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommands(String commandOwner, Iterable<RESTCommand> commands) {
        if (this.m_bCmdSetIsFrozen) {
            throw new RuntimeException("New commands cannot be added: command set is frozen");
        }
        Map<String, Map<String, SortedSet<RESTCommand>>> map = this.m_cmdMap;
        synchronized (map) {
            for (RESTCommand command : commands) {
                SortedSet<RESTCommand> cmdSet;
                List<String> pathList = command.getPath();
                String cmdOwner = pathList.size() > 0 && pathList.get(0).equals("{application}") ? commandOwner : SYSTEM_OWNER;
                String ownerKey = Utils.isEmpty((String)cmdOwner) ? SYSTEM_OWNER : cmdOwner;
                Map<String, SortedSet<RESTCommand>> ownerCmdSet = this.m_cmdMap.get(ownerKey);
                if (ownerCmdSet == null) {
                    ownerCmdSet = new HashMap<String, SortedSet<RESTCommand>>();
                    this.m_cmdMap.put(ownerKey, ownerCmdSet);
                }
                if ((cmdSet = ownerCmdSet.get(command.getMethod())) == null) {
                    cmdSet = new TreeSet<RESTCommand>();
                    ownerCmdSet.put(command.getMethod(), cmdSet);
                }
                Utils.require((!cmdSet.contains(command) ? 1 : 0) != 0, (String)"Duplicate REST command: Owner=%s, command=%s", (Object[])new Object[]{ownerKey, command.toString()});
                cmdSet.add(command);
            }
        }
    }

    public void setParent(String cmdOwnerName, String parentCmdOwnerName) {
        this.m_parentMap.put(cmdOwnerName, parentCmdOwnerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, Map<String, SortedSet<RESTCommand>>> map = this.m_cmdMap;
        synchronized (map) {
            this.m_cmdMap.clear();
            this.m_parentMap.clear();
        }
    }

    public void freezeCommandSet(boolean bFreeze) {
        this.m_bCmdSetIsFrozen = bFreeze;
    }

    public RESTCommand findMatch(String ownerService, String method, String uri, String query, Map<String, String> variableMap) {
        String ownerKey = Utils.isEmpty((String)ownerService) ? SYSTEM_OWNER : ownerService;
        RESTCommand cmd = null;
        while (cmd == null && !Utils.isEmpty((String)ownerKey)) {
            cmd = this.searchOwnerCommands(ownerKey, method, uri, query, variableMap);
            ownerKey = this.m_parentMap.get(ownerKey);
        }
        return cmd;
    }

    public Collection<String> getCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        for (String cmdOwner : this.m_cmdMap.keySet()) {
            Map<String, SortedSet<RESTCommand>> ownerCmdMap = this.m_cmdMap.get(cmdOwner);
            for (String method : ownerCmdMap.keySet()) {
                for (RESTCommand cmd : ownerCmdMap.get(method)) {
                    commands.add(String.valueOf(cmdOwner) + ": " + cmd.toString());
                }
            }
        }
        return commands;
    }

    private RESTCommand searchOwnerCommands(String ownerKey, String method, String uri, String query, Map<String, String> variableMap) {
        String[] pathNodes;
        Map<String, SortedSet<RESTCommand>> ownerCmdMap = this.m_cmdMap.get(ownerKey);
        if (ownerCmdMap == null) {
            return null;
        }
        SortedSet<RESTCommand> cmdSet = ownerCmdMap.get(method.toUpperCase());
        if (cmdSet == null) {
            return null;
        }
        ArrayList<String> pathNodeList = new ArrayList<String>();
        String[] stringArray = pathNodes = uri.split("/");
        int n = pathNodes.length;
        int n2 = 0;
        while (n2 < n) {
            String pathNode = stringArray[n2];
            if (pathNode.length() > 0) {
                pathNodeList.add(pathNode);
            }
            ++n2;
        }
        for (RESTCommand cmd : cmdSet) {
            if (!cmd.matchesURL(method, pathNodeList, query, variableMap)) continue;
            return cmd;
        }
        return null;
    }
}

