/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.rest;

import com.dell.doradus.common.Utils;
import com.dell.doradus.service.rest.RESTCallback;
import com.dell.doradus.service.rest.RESTRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class RESTCommand
implements Comparable<RESTCommand> {
    private String m_method;
    private List<String> m_pathNodes;
    private String m_query;
    private Class<RESTCallback> m_callbackClass;
    private final boolean m_bPrivileged;

    public RESTCommand(String ruleString) {
        this.m_bPrivileged = false;
        this.parseRuleString(ruleString);
    }

    public RESTCommand(String ruleString, boolean bPrivileged) {
        this.m_bPrivileged = bPrivileged;
        this.parseRuleString(ruleString);
    }

    public boolean matchesURL(String method, List<String> pathNodeList, String query, Map<String, String> variableMap) {
        if (!this.m_method.equalsIgnoreCase(method) || pathNodeList.size() != this.m_pathNodes.size()) {
            return false;
        }
        HashMap<String, String> matchedVarMap = new HashMap<String, String>();
        int index = 0;
        while (index < pathNodeList.size()) {
            if (!RESTCommand.matches(pathNodeList.get(index), this.m_pathNodes.get(index), matchedVarMap)) {
                return false;
            }
            ++index;
        }
        if (RESTCommand.matches(query, this.m_query, matchedVarMap)) {
            variableMap.putAll(matchedVarMap);
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(RESTCommand other) {
        int index = 0;
        while (index < Math.min(this.m_pathNodes.size(), other.m_pathNodes.size())) {
            String node2;
            String node1 = this.m_pathNodes.get(index);
            int diff = RESTCommand.compareNodes(node1, node2 = other.m_pathNodes.get(index));
            if (diff != 0) {
                return diff;
            }
            ++index;
        }
        if (this.m_pathNodes.size() < other.m_pathNodes.size()) {
            return 1;
        }
        if (this.m_pathNodes.size() > other.m_pathNodes.size()) {
            return -1;
        }
        int diff = RESTCommand.compareNodes(this.getQuery(), other.getQuery());
        return diff;
    }

    public boolean isPrivileged() {
        return this.m_bPrivileged;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.m_method);
        buffer.append(" /");
        for (String node : this.m_pathNodes) {
            buffer.append(node);
            buffer.append("/");
        }
        if (this.m_query.length() > 0) {
            buffer.append("?");
            buffer.append(this.m_query);
        }
        buffer.append(" -> ");
        buffer.append(this.m_callbackClass.toString());
        return buffer.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof RESTCommand)) {
            return false;
        }
        RESTCommand otherCmd = (RESTCommand)other;
        if (!this.m_method.equalsIgnoreCase(otherCmd.m_method)) {
            return false;
        }
        if (this.m_pathNodes.size() != otherCmd.m_pathNodes.size()) {
            return false;
        }
        int index = 0;
        while (index < this.m_pathNodes.size()) {
            if (!RESTCommand.samePattern(this.m_pathNodes.get(index), otherCmd.m_pathNodes.get(index))) {
                return false;
            }
            ++index;
        }
        return RESTCommand.samePattern(this.m_query, otherCmd.m_query);
    }

    public int hashCode() {
        int code = this.m_method.hashCode();
        String query = this.m_query.length() > 0 && this.m_query.startsWith("{") ? "{" : this.m_query;
        code ^= query.hashCode();
        for (String partNode : this.m_pathNodes) {
            if (partNode.length() > 0 && partNode.startsWith("{")) {
                partNode = "{";
            }
            code ^= partNode.hashCode();
        }
        return code;
    }

    public String getMethod() {
        return this.m_method;
    }

    public List<String> getPath() {
        return this.m_pathNodes;
    }

    public String getQuery() {
        return this.m_query;
    }

    public RESTCallback getNewCallback(RESTRequest request) {
        try {
            RESTCallback callback = this.m_callbackClass.newInstance();
            callback.setRequest(request);
            return callback;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to invoke callback", e);
        }
    }

    private void parseRuleString(String ruleString) {
        String[] parts = ruleString.split(" +");
        Utils.require((parts.length == 3 ? 1 : 0) != 0, (String)("Invalid rule format: " + ruleString));
        this.m_method = parts[0].toUpperCase();
        ArrayList pathNodeList = new ArrayList();
        StringBuilder query = new StringBuilder();
        StringBuilder fragment = new StringBuilder();
        Utils.parseURI((String)parts[1], pathNodeList, (StringBuilder)query, (StringBuilder)fragment);
        if (pathNodeList.size() == 0) {
            throw new IllegalArgumentException("Invalid URI path: " + parts[1]);
        }
        this.m_pathNodes = new ArrayList<String>();
        for (String encodedNode : pathNodeList) {
            this.m_pathNodes.add(Utils.urlDecode((String)encodedNode));
        }
        this.m_query = Utils.urlDecode((String)query.toString());
        String cmdClassPath = parts[2];
        try {
            this.m_callbackClass = Class.forName(cmdClassPath);
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating callback object '" + cmdClassPath + "'", e);
        }
    }

    private static String getVariableName(String value) {
        assert (value.charAt(0) == '{');
        assert (value.charAt(value.length() - 1) == '}');
        return value.substring(1, value.length() - 1);
    }

    private static boolean samePattern(String value1, String value2) {
        if (value1.length() == 0) {
            return value2.length() == 0;
        }
        if (value1.charAt(0) == '{') {
            return value2.length() > 0 && value2.charAt(0) == '{';
        }
        return value1.equals(value2);
    }

    private static boolean matches(String value, String component, Map<String, String> variableMap) {
        if (Utils.isEmpty((String)component)) {
            return Utils.isEmpty((String)value);
        }
        if (component.charAt(0) == '{') {
            if (!Utils.isEmpty((String)value)) {
                String varName = RESTCommand.getVariableName(component);
                variableMap.put(varName, value);
            }
            return true;
        }
        return component.equals(value);
    }

    private static int compareNodes(String node1, String node2) {
        assert (node1 != null);
        assert (node2 != null);
        if (node1.equals(node2)) {
            return 0;
        }
        if (node1.length() > 0 && node1.charAt(0) == '{') {
            if (node2.length() > 0 && node2.charAt(0) == '{') {
                return 0;
            }
            return 1;
        }
        if (node2.length() > 0 && node2.charAt(0) == '{') {
            return -1;
        }
        return node1.compareTo(node2);
    }
}

