/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.olap.mono;

import com.dell.doradus.common.AggregateResult;
import com.dell.doradus.common.ApplicationDefinition;
import com.dell.doradus.common.BatchResult;
import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.common.UNode;
import com.dell.doradus.common.Utils;
import com.dell.doradus.olap.OlapBatch;
import com.dell.doradus.search.SearchResult;
import com.dell.doradus.search.SearchResultList;
import com.dell.doradus.service.StorageService;
import com.dell.doradus.service.olap.OLAPService;
import com.dell.doradus.service.olap.mono.OLAPShardMerger;
import com.dell.doradus.service.rest.RESTCommand;
import com.dell.doradus.service.rest.RESTService;
import com.dell.doradus.service.taskmanager.Task;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class OLAPMonoService
extends StorageService {
    public static final String MONO_SHARD_NAME = "_mono";
    private static final OLAPMonoService INSTANCE = new OLAPMonoService();
    private static final List<RESTCommand> REST_RULES = Arrays.asList(new RESTCommand("GET    /{application}/{table}/_query?{params}      com.dell.doradus.service.olap.mono.QueryURICmd"), new RESTCommand("GET    /{application}/{table}/_query               com.dell.doradus.service.olap.mono.QueryDocCmd"), new RESTCommand("PUT    /{application}/{table}/_query               com.dell.doradus.service.olap.mono.QueryDocCmd"), new RESTCommand("GET    /{application}/{table}/_aggregate?{params}  com.dell.doradus.service.olap.mono.AggregateURICmd"), new RESTCommand("GET    /{application}/{table}/_aggregate           com.dell.doradus.service.olap.mono.AggregateDocCmd"), new RESTCommand("PUT    /{application}/{table}/_aggregate           com.dell.doradus.service.olap.mono.AggregateDocCmd"), new RESTCommand("PUT    /{application}/_data?{params}       com.dell.doradus.service.olap.mono.UpdateBatchCmd"), new RESTCommand("POST   /{application}/_data?{params}       com.dell.doradus.service.olap.mono.UpdateBatchCmd"), new RESTCommand("GET    /{application}/_stats               com.dell.doradus.service.olap.mono.ShardStatsCmd"), new RESTCommand("GET    /{application}/_statistics?{params} com.dell.doradus.service.olap.mono.ShardStatisticsCmd"), new RESTCommand("POST   /{application}/_merge               com.dell.doradus.service.olap.mono.MergeShardCmd"));

    private OLAPMonoService() {
    }

    public static OLAPMonoService instance() {
        return INSTANCE;
    }

    @Override
    public void initService() {
        RESTService.instance().registerApplicationCommands(REST_RULES, this, OLAPService.instance());
    }

    @Override
    public void startService() {
        Utils.require((boolean)OLAPService.instance().getState().isInitialized(), (String)"OLAPMonoService requires the OLAPService");
        OLAPService.instance().waitForFullService();
    }

    @Override
    public void stopService() {
    }

    @Override
    public void deleteApplication(ApplicationDefinition appDef) {
        this.checkServiceState();
        OLAPService.instance().deleteApplication(appDef);
    }

    @Override
    public void initializeApplication(ApplicationDefinition oldAppDef, ApplicationDefinition appDef) {
        this.checkServiceState();
        OLAPService.instance().initializeApplication(oldAppDef, appDef);
    }

    @Override
    public void validateSchema(ApplicationDefinition appDef) {
        this.checkServiceState();
        this.validateApplication(appDef);
    }

    @Override
    public Collection<Task> getAppTasks(ApplicationDefinition appDef) {
        this.checkServiceState();
        ArrayList<Task> appTasks = new ArrayList<Task>();
        appTasks.add(new Task(appDef.getAppName(), null, "shard-merging", "1 MINUTE", OLAPShardMerger.class));
        return appTasks;
    }

    public SearchResultList objectQueryURI(TableDefinition tableDef, String uriQuery) {
        String monoURIQuery = OLAPMonoService.addMonoShard(uriQuery);
        SearchResultList resultList = OLAPService.instance().objectQueryURI(tableDef, monoURIQuery);
        for (SearchResult result : resultList.results) {
            result.scalars.remove("_shard");
        }
        return resultList;
    }

    public SearchResultList objectQueryDoc(TableDefinition tableDef, UNode rootNode) {
        UNode monoRootNode = OLAPMonoService.addMonoShard(rootNode);
        SearchResultList resultList = OLAPService.instance().objectQueryDoc(tableDef, monoRootNode);
        for (SearchResult result : resultList.results) {
            result.scalars.remove("_shard");
        }
        return resultList;
    }

    public AggregateResult aggregateQueryURI(TableDefinition tableDef, String uriQuery) {
        String monoURIQuery = OLAPMonoService.addMonoShard(uriQuery);
        return OLAPService.instance().aggregateQueryURI(tableDef, monoURIQuery);
    }

    public AggregateResult aggregateQueryDoc(TableDefinition tableDef, UNode rootNode) {
        UNode monoRootNode = OLAPMonoService.addMonoShard(rootNode);
        return OLAPService.instance().aggregateQueryDoc(tableDef, monoRootNode);
    }

    public BatchResult addBatch(ApplicationDefinition appDef, String shardName, OlapBatch batch) {
        Utils.require((boolean)shardName.equals(MONO_SHARD_NAME), (String)"Shard name must be: _mono");
        return OLAPService.instance().addBatch(appDef, shardName, batch);
    }

    public BatchResult addBatch(ApplicationDefinition appDef, String shardName, OlapBatch batch, Map<String, String> options) {
        Utils.require((boolean)shardName.equals(MONO_SHARD_NAME), (String)"Shard name must be: _mono");
        return OLAPService.instance().addBatch(appDef, shardName, batch, options);
    }

    public BatchResult addBatch(ApplicationDefinition appDef, OlapBatch batch) {
        return OLAPService.instance().addBatch(appDef, MONO_SHARD_NAME, batch);
    }

    public BatchResult addBatch(ApplicationDefinition appDef, OlapBatch batch, Map<String, String> options) {
        return OLAPService.instance().addBatch(appDef, MONO_SHARD_NAME, batch, options);
    }

    public static String addMonoShard(String uriQuery) {
        Map uriParams = Utils.parseURIQuery((String)uriQuery);
        Utils.require((!uriParams.containsKey("range") ? 1 : 0) != 0, (String)"'range' parameter not allowed");
        Utils.require((!uriParams.containsKey("shards") ? 1 : 0) != 0, (String)"'shards' parameter not allowed");
        uriParams.put("shards", MONO_SHARD_NAME);
        return Utils.joinURIQuery((Map)uriParams);
    }

    public static UNode addMonoShard(UNode rootNode) {
        Utils.require((rootNode.getMember("shards") == null ? 1 : 0) != 0, (String)"'shards' parameter not allowed");
        Utils.require((rootNode.getMember("shards-range") == null ? 1 : 0) != 0, (String)"'shards-range' parameter not allowed");
        Utils.require((rootNode.getMember("x-shards") == null ? 1 : 0) != 0, (String)"'x-shards' parameter not allowed");
        Utils.require((rootNode.getMember("x-shards-range") == null ? 1 : 0) != 0, (String)"'x-shards-range' parameter not allowed");
        rootNode.addValueNode("shards", MONO_SHARD_NAME);
        return rootNode;
    }

    private void validateApplication(ApplicationDefinition appDef) {
        block8: for (String optName : appDef.getOptionNames()) {
            String optValue = appDef.getOption(optName);
            switch (optName) {
                case "StorageService": {
                    assert (optValue.equals(this.getClass().getSimpleName()));
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("Unknown option for OLAPMonoService application: " + optName);
                }
                case "Tenant": 
            }
        }
        for (TableDefinition tableDef : appDef.getTableDefinitions().values()) {
            this.validateTable(tableDef);
        }
    }

    private void validateTable(TableDefinition tableDef) {
        for (String optName : tableDef.getOptionNames()) {
            Utils.require((boolean)false, (String)("Unknown option for OLAPMonoService table: " + optName));
        }
        for (FieldDefinition fieldDef : tableDef.getFieldDefinitions()) {
            this.validateField(fieldDef);
        }
    }

    private void validateField(FieldDefinition fieldDef) {
        if (fieldDef.isScalarField()) {
            Utils.require((boolean)Utils.isEmpty((String)fieldDef.getAnalyzerName()), (String)("'analyzer' not allowed for OLAPMono application fields:" + fieldDef));
        } else if (fieldDef.isXLinkField()) {
            Utils.require((boolean)false, (String)("XLinks are not allowed for OLAPMono applications: " + fieldDef));
        } else if (fieldDef.isLinkField()) {
            Utils.require((!fieldDef.isSharded() ? 1 : 0) != 0, (String)"Link fields cannot be sharded: {}", (Object[])new Object[]{fieldDef});
        }
    }
}

