/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.olap;

import com.dell.doradus.common.AggregateResult;
import com.dell.doradus.common.ApplicationDefinition;
import com.dell.doradus.common.BatchResult;
import com.dell.doradus.common.FieldDefinition;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.common.UNode;
import com.dell.doradus.common.Utils;
import com.dell.doradus.olap.MergeOptions;
import com.dell.doradus.olap.Olap;
import com.dell.doradus.olap.OlapAggregate;
import com.dell.doradus.olap.OlapBatch;
import com.dell.doradus.olap.OlapQuery;
import com.dell.doradus.olap.OlapStatistics;
import com.dell.doradus.olap.Olapp;
import com.dell.doradus.olap.aggregate.AggregateResultConverter;
import com.dell.doradus.olap.aggregate.AggregationResult;
import com.dell.doradus.olap.store.CubeSearcher;
import com.dell.doradus.olap.store.SegmentStats;
import com.dell.doradus.search.SearchResultList;
import com.dell.doradus.service.StorageService;
import com.dell.doradus.service.db.Tenant;
import com.dell.doradus.service.olap.OLAPDataAger;
import com.dell.doradus.service.rest.RESTCommand;
import com.dell.doradus.service.rest.RESTService;
import com.dell.doradus.service.schema.SchemaService;
import com.dell.doradus.service.taskmanager.Task;
import com.dell.doradus.service.taskmanager.TaskFrequency;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class OLAPService
extends StorageService {
    private static final OLAPService INSTANCE = new OLAPService();
    private Olap m_olap = null;
    private static final List<RESTCommand> REST_RULES = Arrays.asList(new RESTCommand("GET    /{application}/{table}/_query?{params}      com.dell.doradus.service.olap.QueryURICmd"), new RESTCommand("GET    /{application}/{table}/_query               com.dell.doradus.service.olap.QueryDocCmd"), new RESTCommand("PUT    /{application}/{table}/_query               com.dell.doradus.service.olap.QueryDocCmd"), new RESTCommand("GET    /{application}/{table}/_aggregate?{params}  com.dell.doradus.service.olap.AggregateURICmd"), new RESTCommand("GET    /{application}/{table}/_aggregate           com.dell.doradus.service.olap.AggregateDocCmd"), new RESTCommand("PUT    /{application}/{table}/_aggregate           com.dell.doradus.service.olap.AggregateDocCmd"), new RESTCommand("POST   /{application}/{shard}                      com.dell.doradus.service.olap.AddObjectsCmd"), new RESTCommand("POST   /{application}/{shard}?{params}             com.dell.doradus.service.olap.AddObjectsCmd"), new RESTCommand("PUT    /{application}/{shard}                      com.dell.doradus.service.olap.AddObjectsCmd"), new RESTCommand("PUT    /{application}/{shard}?{params}             com.dell.doradus.service.olap.AddObjectsCmd"), new RESTCommand("POST   /{application}/_shards/{shard}              com.dell.doradus.service.olap.MergeSegmentCmd"), new RESTCommand("POST   /{application}/_shards/{shard}?{params}     com.dell.doradus.service.olap.MergeSegmentCmd"), new RESTCommand("DELETE /{application}/_shards/{shard}              com.dell.doradus.service.olap.DeleteSegmentCmd"), new RESTCommand("GET    /{application}/_shards                      com.dell.doradus.service.olap.ListShardsCmd"), new RESTCommand("GET    /{application}/_shards/{shard}              com.dell.doradus.service.olap.ShardStatsCmd"), new RESTCommand("GET    /{application}/_statistics/{shard}?{params} com.dell.doradus.service.olap.ShardStatisticsCmd"), new RESTCommand("GET    /{application}/{table}/_duplicates?{params} com.dell.doradus.service.olap.DuplicatesCmd"), new RESTCommand("GET    /_olapp?{params}                             com.dell.doradus.service.olap.OlappCmd"));

    public static OLAPService instance() {
        return INSTANCE;
    }

    @Override
    public void initService() {
        RESTService.instance().registerApplicationCommands(REST_RULES, this);
    }

    @Override
    public void startService() {
        SchemaService.instance().waitForFullService();
        this.m_olap = new Olap();
    }

    @Override
    public void stopService() {
        this.m_olap = null;
    }

    @Override
    public void deleteApplication(ApplicationDefinition appDef) {
        this.checkServiceState();
        this.m_olap.deleteApplication(appDef);
    }

    @Override
    public void initializeApplication(ApplicationDefinition oldAppDef, ApplicationDefinition appDef) {
        this.checkServiceState();
        this.m_olap.createApplication(Tenant.getTenant(appDef), appDef.getAppName());
    }

    @Override
    public void validateSchema(ApplicationDefinition appDef) {
        this.checkServiceState();
        this.validateApplication(appDef);
    }

    @Override
    public Collection<Task> getAppTasks(ApplicationDefinition appDef) {
        this.checkServiceState();
        ArrayList<Task> appTasks = new ArrayList<Task>();
        String agingFreq = appDef.getOption("aging-check-frequency");
        if (agingFreq != null) {
            Task task = new Task(appDef.getAppName(), null, "data-aging", agingFreq, OLAPDataAger.class);
            appTasks.add(task);
        }
        return appTasks;
    }

    public SearchResultList objectQueryURI(TableDefinition tableDef, String uriQuery) {
        this.checkServiceState();
        OlapQuery olapQuery = new OlapQuery(uriQuery);
        return this.m_olap.search(tableDef.getAppDef(), tableDef.getTableName(), olapQuery);
    }

    public SearchResultList objectQueryDoc(TableDefinition tableDef, UNode rootNode) {
        this.checkServiceState();
        OlapQuery olapQuery = new OlapQuery(rootNode);
        return this.m_olap.search(tableDef.getAppDef(), tableDef.getTableName(), olapQuery);
    }

    public AggregateResult aggregateQueryURI(TableDefinition tableDef, String uriQuery) {
        this.checkServiceState();
        OlapAggregate request = new OlapAggregate(uriQuery);
        AggregationResult result = this.m_olap.aggregate(tableDef.getAppDef(), tableDef.getTableName(), request);
        return AggregateResultConverter.create(result, request);
    }

    public AggregateResult aggregateQueryDoc(TableDefinition tableDef, UNode rootNode) {
        this.checkServiceState();
        OlapAggregate request = new OlapAggregate(rootNode);
        AggregationResult result = this.m_olap.aggregate(tableDef.getAppDef(), tableDef.getTableName(), request);
        return AggregateResultConverter.create(result, request);
    }

    public BatchResult addBatch(ApplicationDefinition appDef, String shardName, OlapBatch batch) {
        return this.addBatch(appDef, shardName, batch, null);
    }

    public BatchResult addBatch(ApplicationDefinition appDef, String shardName, OlapBatch batch, Map<String, String> options) {
        this.checkServiceState();
        String guid = this.m_olap.addSegment(appDef, shardName, batch, this.getOverwriteOption(options));
        BatchResult result = new BatchResult();
        result.setStatus(BatchResult.Status.OK);
        result.setComment("GUID=" + guid);
        return result;
    }

    public String browseOlapp(Tenant tenant, Map<String, String> parameters) {
        this.checkServiceState();
        return Olapp.process(tenant, this.m_olap, parameters);
    }

    public void deleteShard(ApplicationDefinition appDef, String shard) {
        this.checkServiceState();
        this.m_olap.deleteShard(appDef, shard);
    }

    public List<ApplicationDefinition> getAllOLAPApplications(Tenant tenant) {
        ArrayList<ApplicationDefinition> appDefs = new ArrayList<ApplicationDefinition>();
        for (ApplicationDefinition appDef : SchemaService.instance().getAllApplications(tenant)) {
            if (!OLAPService.class.getSimpleName().equals(appDef.getStorageService())) continue;
            appDefs.add(appDef);
        }
        return appDefs;
    }

    public Olap getOlap() {
        this.checkServiceState();
        return this.m_olap;
    }

    public SegmentStats getStats(ApplicationDefinition appDef, String shard) {
        this.checkServiceState();
        return this.m_olap.getStats(appDef, shard);
    }

    public UNode getStatistics(ApplicationDefinition appDef, String shard, Map<String, String> paramMap) {
        this.checkServiceState();
        CubeSearcher searcher = this.m_olap.getSearcher(appDef, shard);
        String file = paramMap.get("file");
        if (file != null) {
            return OlapStatistics.getFileData(searcher, file);
        }
        String sort = paramMap.get("sort");
        boolean memStats = !"false".equals(paramMap.get("mem"));
        return OlapStatistics.getStatistics(searcher, sort, memStats);
    }

    public List<String> listShards(ApplicationDefinition appDef) {
        this.checkServiceState();
        return this.m_olap.listShards(appDef);
    }

    public void mergeShard(ApplicationDefinition appDef, String shard, MergeOptions options) {
        this.checkServiceState();
        this.m_olap.merge(appDef, shard, options);
    }

    public Date getExpirationDate(ApplicationDefinition appDef, String shard) {
        this.checkServiceState();
        return this.m_olap.getExpirationDate(appDef, shard);
    }

    public SearchResultList getDuplicateIDs(ApplicationDefinition appDef, String table, String range) {
        this.checkServiceState();
        return this.m_olap.getDuplicateIDs(appDef, table, range);
    }

    private OLAPService() {
    }

    private boolean getOverwriteOption(Map<String, String> options) {
        boolean bOverwrite = true;
        if (options != null) {
            for (String name : options.keySet()) {
                if ("overwrite".equals(name.toLowerCase())) {
                    bOverwrite = Boolean.parseBoolean(options.get(name));
                    continue;
                }
                Utils.require((boolean)false, (String)("Unknown OLAP batch option: " + name));
            }
        }
        return bOverwrite;
    }

    private void validateApplication(ApplicationDefinition appDef) {
        boolean bSawAgingFreq = false;
        block10: for (String optName : appDef.getOptionNames()) {
            String optValue = appDef.getOption(optName);
            switch (optName) {
                case "StorageService": {
                    assert (optValue.equals(this.getClass().getSimpleName()));
                    continue block10;
                }
                case "aging-check-frequency": {
                    new TaskFrequency(optValue);
                    bSawAgingFreq = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown option for OLAPService application: " + optName);
                }
                case "Tenant": 
            }
        }
        for (TableDefinition tableDef : appDef.getTableDefinitions().values()) {
            this.validateTable(tableDef);
        }
        if (!bSawAgingFreq) {
            appDef.setOption("aging-check-frequency", "1 DAY");
        }
    }

    private void validateTable(TableDefinition tableDef) {
        for (String optName : tableDef.getOptionNames()) {
            Utils.require((boolean)false, (String)("Unknown option for OLAPService table: " + optName));
        }
        for (FieldDefinition fieldDef : tableDef.getFieldDefinitions()) {
            this.validateField(fieldDef);
        }
    }

    private void validateField(FieldDefinition fieldDef) {
        if (fieldDef.isScalarField()) {
            Utils.require((boolean)Utils.isEmpty((String)fieldDef.getAnalyzerName()), (String)("'analyzer' not allowed for OLAP application fields:" + fieldDef));
        } else if (fieldDef.isLinkType()) {
            Utils.require((!fieldDef.isSharded() ? 1 : 0) != 0, (String)"Link and xlink fields cannot be sharded: {}", (Object[])new Object[]{fieldDef});
        }
    }
}

