/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.db.thrift;

import com.dell.doradus.common.Utils;
import com.dell.doradus.core.ServerConfig;
import com.dell.doradus.service.db.DBNotAvailableException;
import com.dell.doradus.service.db.DBService;
import com.dell.doradus.service.db.DBTransaction;
import com.dell.doradus.service.db.DColumn;
import com.dell.doradus.service.db.DRow;
import com.dell.doradus.service.db.Tenant;
import com.dell.doradus.service.db.thrift.CassandraSchemaMgr;
import com.dell.doradus.service.db.thrift.CassandraTransaction;
import com.dell.doradus.service.db.thrift.DBConn;
import com.dell.doradus.service.tenant.UserDefinition;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Random;

public class ThriftService
extends DBService {
    private static final ThriftService INSTANCE = new ThriftService();
    private final Object m_lastHostLock = new Object();
    private String m_lastHost;
    private boolean m_bUseSecondaryHosts;
    private long m_lastPrimaryHostCheckTimeMillis;
    private final Map<String, Queue<DBConn>> m_dbKeyspaceDBConns = new HashMap<String, Queue<DBConn>>();

    private ThriftService() {
    }

    public static ThriftService instance() {
        return INSTANCE;
    }

    @Override
    public void initService() {
        ServerConfig config = ServerConfig.getInstance();
        this.m_logger.info("Using Thrift API");
        this.m_logger.info("Cassandra host list: {}", (Object)Arrays.toString(config.dbhost.split(",")));
        this.m_logger.info("Cassandra port: {}", (Object)config.dbport);
        this.m_logger.info("Default application keyspace: {}", (Object)config.keyspace);
    }

    @Override
    public void startService() {
        this.initializeDBConnections();
    }

    @Override
    public void stopService() {
        this.purgeAllConnections();
    }

    @Override
    public void createTenant(Tenant tenant, Map<String, String> options) {
        this.checkState();
        String keyspace = tenant.getKeyspace();
        Throwable throwable = null;
        Object var5_6 = null;
        try (DBConn dbConn = this.createAndConnectConn(null);){
            CassandraSchemaMgr schemaMgr = new CassandraSchemaMgr(dbConn.getClientSession());
            if (!schemaMgr.keyspaceExists(keyspace)) {
                schemaMgr.createKeyspace(keyspace, options);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void modifyTenant(Tenant tenant, Map<String, String> options) {
        throw new RuntimeException("This command is not supported for the Thrift API");
    }

    @Override
    public void dropTenant(Tenant tenant) {
        this.checkState();
        String keyspace = tenant.getKeyspace();
        Throwable throwable = null;
        Object var4_5 = null;
        try (DBConn dbConn = this.createAndConnectConn(null);){
            CassandraSchemaMgr schemaMgr = new CassandraSchemaMgr(dbConn.getClientSession());
            if (!schemaMgr.keyspaceExists(keyspace)) {
                schemaMgr.dropKeyspace(keyspace);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void addUsers(Tenant tenant, Iterable<UserDefinition> users) {
        throw new RuntimeException("This method is not supported for the Thrift API");
    }

    @Override
    public void modifyUsers(Tenant tenant, Iterable<UserDefinition> users) {
        throw new RuntimeException("This method is not supported for the Thrift API");
    }

    @Override
    public void deleteUsers(Tenant tenant, Iterable<UserDefinition> users) {
        throw new RuntimeException("This method is not supported for the Thrift API");
    }

    @Override
    public Collection<Tenant> getTenants() {
        this.checkState();
        ArrayList<Tenant> tenantList = new ArrayList<Tenant>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (DBConn dbConn = this.createAndConnectConn(null);){
            CassandraSchemaMgr schemaMgr = new CassandraSchemaMgr(dbConn.getClientSession());
            Collection<String> keyspaceList = schemaMgr.getKeyspaces();
            for (String keyspace : keyspaceList) {
                if (!schemaMgr.columnFamilyExists(keyspace, "Applications")) continue;
                tenantList.add(new Tenant(keyspace));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return tenantList;
    }

    @Override
    public void createStoreIfAbsent(Tenant tenant, String storeName, boolean bBinaryValues) {
        this.checkState();
        String keyspace = tenant.getKeyspace();
        DBConn dbConn = this.getDBConnection(keyspace);
        try {
            CassandraSchemaMgr schemaMgr = new CassandraSchemaMgr(dbConn.getClientSession());
            if (!schemaMgr.columnFamilyExists(keyspace, storeName)) {
                schemaMgr.createColumnFamily(keyspace, storeName, bBinaryValues);
            }
        }
        finally {
            this.returnDBConnection(dbConn);
        }
    }

    @Override
    public void deleteStoreIfPresent(Tenant tenant, String storeName) {
        this.checkState();
        String keyspace = tenant.getKeyspace();
        DBConn dbConn = this.getDBConnection(keyspace);
        try {
            CassandraSchemaMgr schemaMgr = new CassandraSchemaMgr(dbConn.getClientSession());
            if (schemaMgr.columnFamilyExists(keyspace, storeName)) {
                schemaMgr.deleteColumnFamily(storeName);
            }
        }
        finally {
            this.returnDBConnection(dbConn);
        }
    }

    @Override
    public DBTransaction startTransaction(Tenant tenant) {
        this.checkState();
        return new CassandraTransaction(tenant);
    }

    @Override
    public void commit(DBTransaction dbTran) {
        this.checkState();
        CassandraTransaction cassDBTran = (CassandraTransaction)dbTran;
        DBConn dbConn = this.getDBConnection(cassDBTran.getKeyspace());
        try {
            dbConn.commit(dbTran);
        }
        finally {
            this.returnDBConnection(dbConn);
        }
    }

    @Override
    public Iterator<DColumn> getAllColumns(Tenant tenant, String storeName, String rowKey) {
        this.checkState();
        String keyspace = tenant.getKeyspace();
        DBConn dbConn = this.getDBConnection(keyspace);
        try {
            Iterator<DColumn> iterator = dbConn.getAllColumns(storeName, rowKey);
            return iterator;
        }
        finally {
            this.returnDBConnection(dbConn);
        }
    }

    @Override
    public Iterator<DColumn> getColumnSlice(Tenant tenant, String storeName, String rowKey, String startCol, String endCol, boolean reversed) {
        this.checkState();
        String keyspace = tenant.getKeyspace();
        DBConn dbConn = this.getDBConnection(keyspace);
        try {
            Iterator<DColumn> iterator = dbConn.getColumnSlice(storeName, rowKey, startCol, endCol, reversed);
            return iterator;
        }
        finally {
            this.returnDBConnection(dbConn);
        }
    }

    @Override
    public Iterator<DColumn> getColumnSlice(Tenant tenant, String storeName, String rowKey, String startCol, String endCol) {
        this.checkState();
        return this.getColumnSlice(tenant, storeName, rowKey, startCol, endCol, false);
    }

    @Override
    public Iterator<DRow> getAllRowsAllColumns(Tenant tenant, String storeName) {
        this.checkState();
        String keyspace = tenant.getKeyspace();
        DBConn dbConn = this.getDBConnection(keyspace);
        try {
            Iterator<DRow> iterator = dbConn.getAllRowsAllColumns(storeName);
            return iterator;
        }
        finally {
            this.returnDBConnection(dbConn);
        }
    }

    @Override
    public DColumn getColumn(Tenant tenant, String storeName, String rowKey, String colName) {
        this.checkState();
        String keyspace = tenant.getKeyspace();
        DBConn dbConn = this.getDBConnection(keyspace);
        try {
            DColumn dColumn = dbConn.getColumn(storeName, rowKey, colName);
            return dColumn;
        }
        finally {
            this.returnDBConnection(dbConn);
        }
    }

    @Override
    public Iterator<DRow> getRowsAllColumns(Tenant tenant, String storeName, Collection<String> rowKeys) {
        this.checkState();
        String keyspace = tenant.getKeyspace();
        DBConn dbConn = this.getDBConnection(keyspace);
        try {
            Iterator<DRow> iterator = dbConn.getRowsAllColumns(storeName, rowKeys);
            return iterator;
        }
        finally {
            this.returnDBConnection(dbConn);
        }
    }

    @Override
    public Iterator<DRow> getRowsColumns(Tenant tenant, String storeName, Collection<String> rowKeys, Collection<String> colNames) {
        this.checkState();
        String keyspace = tenant.getKeyspace();
        DBConn dbConn = this.getDBConnection(keyspace);
        try {
            Iterator<DRow> iterator = dbConn.getRowsColumns(storeName, rowKeys, colNames);
            return iterator;
        }
        finally {
            this.returnDBConnection(dbConn);
        }
    }

    @Override
    public Iterator<DRow> getRowsColumnSlice(Tenant tenant, String storeName, Collection<String> rowKeys, String startCol, String endCol) {
        this.checkState();
        String keyspace = tenant.getKeyspace();
        DBConn dbConn = this.getDBConnection(keyspace);
        try {
            Iterator<DRow> iterator = dbConn.getRowsColumns(storeName, rowKeys, startCol, endCol);
            return iterator;
        }
        finally {
            this.returnDBConnection(dbConn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DBConn getDBConnection(String keyspace) {
        DBConn dbConn = null;
        Map<String, Queue<DBConn>> map = this.m_dbKeyspaceDBConns;
        synchronized (map) {
            Queue<DBConn> dbQueue = this.m_dbKeyspaceDBConns.get(keyspace);
            if (dbQueue == null) {
                dbQueue = new ArrayDeque<DBConn>();
                this.m_dbKeyspaceDBConns.put(keyspace, dbQueue);
            }
            dbConn = dbQueue.size() > 0 ? dbQueue.poll() : this.createAndConnectConn(keyspace);
        }
        return dbConn;
    }

    void returnDBConnection(DBConn dbConn) {
        if (dbConn == null) {
            return;
        }
        if (!this.getState().isRunning()) {
            dbConn.close();
        } else if (dbConn.isFailed()) {
            dbConn.close();
            this.m_logger.info("Purging database connection pool");
            this.purgeAllConnections();
        } else {
            this.returnGoodConnection(dbConn);
        }
    }

    void connectDBConn(DBConn dbConn) throws DBNotAvailableException, RuntimeException {
        int attempt;
        String[] dbHosts;
        if (this.m_bUseSecondaryHosts && System.currentTimeMillis() - this.m_lastPrimaryHostCheckTimeMillis > (long)ServerConfig.getInstance().primary_host_recheck_millis) {
            this.m_bUseSecondaryHosts = false;
        }
        DBNotAvailableException lastException = null;
        if (!this.m_bUseSecondaryHosts) {
            dbHosts = ServerConfig.getInstance().dbhost.split(",");
            attempt = 1;
            while (attempt <= dbHosts.length) {
                try {
                    dbConn.connect(this.chooseHost(dbHosts));
                }
                catch (DBNotAvailableException ex) {
                    lastException = ex;
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                ++attempt;
            }
            this.m_lastPrimaryHostCheckTimeMillis = System.currentTimeMillis();
        }
        if (!dbConn.isOpen() && !Utils.isEmpty((String)ServerConfig.getInstance().secondary_dbhost)) {
            if (!this.m_bUseSecondaryHosts) {
                this.m_logger.info("All connections to 'dbhost' failed; trying 'secondary_dbhost'");
            }
            dbHosts = ServerConfig.getInstance().secondary_dbhost.split(",");
            attempt = 1;
            while (attempt <= dbHosts.length) {
                try {
                    dbConn.connect(this.chooseHost(dbHosts));
                }
                catch (DBNotAvailableException e) {
                    lastException = e;
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                ++attempt;
            }
            if (dbConn.isOpen()) {
                this.m_bUseSecondaryHosts = true;
            }
        }
        if (!dbConn.isOpen()) {
            this.m_logger.error("All Thrift connection attempts failed.", lastException);
            throw lastException;
        }
    }

    private DBConn createAndConnectConn(String keyspace) throws DBNotAvailableException, RuntimeException {
        DBConn dbConn = new DBConn(keyspace);
        this.connectDBConn(dbConn);
        return dbConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String chooseHost(String[] dbHosts) {
        String host = null;
        Object object = this.m_lastHostLock;
        synchronized (object) {
            if (dbHosts.length == 1) {
                host = dbHosts[0];
            } else if (!Utils.isEmpty((String)this.m_lastHost)) {
                int index = 0;
                while (host == null && index < dbHosts.length) {
                    if (dbHosts[index].equals(this.m_lastHost)) {
                        host = dbHosts[++index % dbHosts.length];
                    }
                    ++index;
                }
            }
            if (host == null) {
                host = dbHosts[new Random().nextInt(dbHosts.length)];
            }
            this.m_lastHost = host;
        }
        return host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnGoodConnection(DBConn dbConn) {
        String keyspace = dbConn.getKeyspace();
        assert (!Utils.isEmpty((String)keyspace));
        Map<String, Queue<DBConn>> map = this.m_dbKeyspaceDBConns;
        synchronized (map) {
            Queue<DBConn> connQueue = this.m_dbKeyspaceDBConns.get(keyspace);
            if (connQueue == null) {
                connQueue = new ArrayDeque<DBConn>();
                this.m_dbKeyspaceDBConns.put(keyspace, connQueue);
            }
            connQueue.add(dbConn);
        }
    }

    private void initializeDBConnections() {
        boolean bSuccess = false;
        while (!bSuccess) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (DBConn dbConn = this.createAndConnectConn(null);){
                    new CassandraSchemaMgr(dbConn.getClientSession()).getKeyspaces();
                    bSuccess = true;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (DBNotAvailableException ex) {
                this.m_logger.info("Database is not reachable. Waiting to retry");
                try {
                    Thread.sleep(ServerConfig.getInstance().db_connect_retry_wait_millis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeAllConnections() {
        Map<String, Queue<DBConn>> map = this.m_dbKeyspaceDBConns;
        synchronized (map) {
            for (String keyspace : this.m_dbKeyspaceDBConns.keySet()) {
                Iterator iter = this.m_dbKeyspaceDBConns.get(keyspace).iterator();
                while (iter.hasNext()) {
                    DBConn dbConn = (DBConn)iter.next();
                    dbConn.close();
                    iter.remove();
                }
            }
            this.m_dbKeyspaceDBConns.clear();
        }
    }

    public static /* bridge */ /* synthetic */ DBService instance() {
        return ThriftService.instance();
    }
}

