/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.db.thrift;

import com.dell.doradus.common.Utils;
import com.dell.doradus.core.ServerConfig;
import com.dell.doradus.service.db.DBNotAvailableException;
import com.dell.doradus.service.db.DBTransaction;
import com.dell.doradus.service.db.DColumn;
import com.dell.doradus.service.db.DRow;
import com.dell.doradus.service.db.thrift.CassandraColumnBatch;
import com.dell.doradus.service.db.thrift.CassandraDefs;
import com.dell.doradus.service.db.thrift.CassandraRow;
import com.dell.doradus.service.db.thrift.CassandraRowBatch;
import com.dell.doradus.service.db.thrift.CassandraTransaction;
import com.dell.doradus.service.db.thrift.ThriftService;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBConn
implements AutoCloseable {
    protected final Logger m_logger = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
    private Cassandra.Client m_client;
    private boolean m_bDBOpen;
    private boolean m_bFailed;
    private String m_keyspace;
    public static final String COLUMN_FAMILY_APPS = "Applications";
    public static final ColumnParent COLUMN_PARENT_APPS = new ColumnParent("Applications");

    public DBConn(String keyspace) {
        this.m_keyspace = keyspace;
    }

    public void connect(String dbhost) throws DBNotAvailableException, RuntimeException {
        assert (!this.m_bDBOpen);
        ServerConfig config = ServerConfig.getInstance();
        try {
            TSocket socket = null;
            if (config.dbtls) {
                this.m_logger.debug("Connecting to Cassandra node {}:{} using TLS", (Object)dbhost, (Object)config.dbport);
                socket = this.createTLSSocket(dbhost);
            } else {
                this.m_logger.debug("Connecting to Cassandra node {}:{}", (Object)dbhost, (Object)config.dbport);
                socket = new TSocket(dbhost, config.dbport, config.db_timeout_millis);
                socket.open();
            }
            TFramedTransport transport = new TFramedTransport((TTransport)socket);
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
            this.m_client = new Cassandra.Client((TProtocol)protocol);
        }
        catch (Exception e) {
            throw new DBNotAvailableException(e);
        }
        if (!Utils.isEmpty((String)this.m_keyspace)) {
            try {
                this.m_client.set_keyspace(this.m_keyspace);
            }
            catch (Exception e) {
                this.m_logger.error("Cannot use Keyspace '" + this.m_keyspace + "'", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        this.m_bDBOpen = true;
        this.m_bFailed = false;
    }

    public String getKeyspace() {
        return this.m_keyspace;
    }

    public Cassandra.Client getClientSession() {
        return this.m_client;
    }

    @Override
    public void close() {
        TTransport transport;
        TProtocol protocol;
        if (this.m_client != null && (protocol = this.m_client.getInputProtocol()) != null && (transport = protocol.getTransport()) != null) {
            transport.close();
        }
        this.m_client = null;
        this.m_bFailed = true;
        this.m_bDBOpen = false;
    }

    public boolean isFailed() {
        return this.m_bFailed;
    }

    public boolean isOpen() {
        return this.m_bDBOpen;
    }

    public Map<String, Map<String, String>> getAllAppProperties() {
        Iterator<DRow> rowIter = this.fetchAllRows(COLUMN_PARENT_APPS);
        HashMap<String, Map<String, String>> appPropMap = new HashMap<String, Map<String, String>>();
        while (rowIter.hasNext()) {
            DRow row = rowIter.next();
            if (row.getKey().charAt(0) == '_') continue;
            HashMap<String, String> propMap = new HashMap<String, String>();
            appPropMap.put(row.getKey(), propMap);
            Iterator<DColumn> colIter = row.getColumns();
            while (colIter.hasNext()) {
                DColumn col = colIter.next();
                propMap.put(col.getName(), col.getValue());
            }
        }
        return appPropMap;
    }

    public Map<String, String> getAppProperties(String appName) {
        Iterator<DColumn> colIter = this.fetchAllColumns(COLUMN_PARENT_APPS, Utils.toBytes((String)appName));
        if (colIter == null) {
            return null;
        }
        HashMap<String, String> propMap = new HashMap<String, String>();
        while (colIter.hasNext()) {
            DColumn col = colIter.next();
            propMap.put(col.getName(), col.getValue());
        }
        return propMap;
    }

    public void commit(DBTransaction dbTran) {
        CassandraTransaction cassDBTran = (CassandraTransaction)dbTran;
        if (this.m_logger.isTraceEnabled()) {
            cassDBTran.traceMutations(this.m_logger);
        }
        try {
            this.commitMutations(cassDBTran);
            this.commitDeletes(cassDBTran);
        }
        finally {
            dbTran.clear();
        }
    }

    public Iterator<DColumn> getAllColumns(String storeName, String rowKey) {
        return this.fetchAllColumns(CassandraDefs.columnParent(storeName), Utils.toBytes((String)rowKey));
    }

    public Iterator<DColumn> getColumnSlice(String storeName, String rowKey, String startCol, String endCol, boolean reversed) {
        return this.getColumnSlice(CassandraDefs.columnParent(storeName), Utils.toBytes((String)rowKey), Utils.toBytes((String)startCol), Utils.toBytes((String)endCol), reversed);
    }

    public Iterator<DColumn> getColumnSlice(String storeName, String rowKey, String startCol, String endCol) {
        return this.getColumnSlice(CassandraDefs.columnParent(storeName), Utils.toBytes((String)rowKey), Utils.toBytes((String)startCol), Utils.toBytes((String)endCol));
    }

    public DColumn getColumn(String storeName, String rowKey, String colName) {
        return this.fetchColumn(CassandraDefs.columnParent(storeName), Utils.toBytes((String)rowKey), Utils.toBytes((String)colName));
    }

    public Iterator<DRow> getAllRowsAllColumns(String storeName) {
        return this.fetchAllRows(CassandraDefs.columnParent(storeName));
    }

    public Iterator<DRow> getRowsAllColumns(String storeName, Collection<String> rowKeys) {
        ArrayList<byte[]> rowKeyList = new ArrayList<byte[]>();
        for (String rowKey : rowKeys) {
            rowKeyList.add(Utils.toBytes((String)rowKey));
        }
        return this.fetchRowsAllColumns(CassandraDefs.columnParent(storeName), rowKeyList);
    }

    public Iterator<DRow> getRowsColumns(String storeName, Collection<String> rowKeys, Collection<String> colNames) {
        ArrayList<byte[]> rowKeyList = new ArrayList<byte[]>();
        for (String rowKey : rowKeys) {
            rowKeyList.add(Utils.toBytes((String)rowKey));
        }
        ArrayList<byte[]> colNameList = new ArrayList<byte[]>();
        for (String colName : colNames) {
            colNameList.add(Utils.toBytes((String)colName));
        }
        return this.fetchRowsColumns(CassandraDefs.columnParent(storeName), rowKeyList, colNameList);
    }

    public Iterator<DRow> getRowsColumns(String storeName, Collection<String> rowKeys, String startCol, String endCol) {
        return this.getRowsColumns(storeName, rowKeys, startCol, endCol, false);
    }

    public Iterator<DRow> getRowsColumns(String storeName, Collection<String> rowKeys, String startCol, String endCol, boolean reversed) {
        ArrayList<byte[]> rowKeyList = new ArrayList<byte[]>();
        for (String rowKey : rowKeys) {
            rowKeyList.add(Utils.toBytes((String)rowKey));
        }
        return this.fetchColumnSlice(CassandraDefs.columnParent(storeName), rowKeyList, Utils.toBytes((String)startCol), Utils.toBytes((String)endCol), reversed);
    }

    List<KeySlice> getRangeSlices(ColumnParent colParent, SlicePredicate slicePred, KeyRange keyRange) {
        this.m_logger.debug("Fetching {}.{} from {}", new Object[]{DBConn.toString(keyRange), DBConn.toString(slicePred), DBConn.toString(colParent)});
        List keySliceList = null;
        boolean bSuccess = false;
        int attempts = 1;
        while (!bSuccess) {
            try {
                Date startDate = new Date();
                keySliceList = this.m_client.get_range_slices(colParent, slicePred, keyRange, ConsistencyLevel.ONE);
                this.timing("get_range_slices", startDate);
                if (attempts > 1) {
                    this.m_logger.info("get_range_slices() succeeded on attempt #{}", (Object)attempts);
                }
                bSuccess = true;
            }
            catch (Exception ex) {
                if (attempts >= ServerConfig.getInstance().max_read_attempts) {
                    String errMsg = "All retries exceeded; abandoning get_range_slices() for table: " + colParent.getColumn_family();
                    this.m_bFailed = true;
                    this.m_logger.error(errMsg, (Throwable)ex);
                    throw new RuntimeException(errMsg, ex);
                }
                this.m_logger.warn("get_range_slices() attempt #{} failed: {}", (Object)attempts, (Object)ex);
                try {
                    Thread.sleep(attempts * ServerConfig.getInstance().retry_wait_millis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.reconnect(ex);
            }
            ++attempts;
        }
        return keySliceList;
    }

    List<ColumnOrSuperColumn> getSlice(ColumnParent colParent, SlicePredicate slicePred, ByteBuffer key) {
        this.m_logger.debug("Fetching {}.{} from {}", new Object[]{Utils.toString((ByteBuffer)key), DBConn.toString(slicePred), DBConn.toString(colParent)});
        List columnList = null;
        boolean bSuccess = false;
        int attempts = 1;
        while (!bSuccess) {
            try {
                Date startDate = new Date();
                columnList = this.m_client.get_slice(key, colParent, slicePred, ConsistencyLevel.ONE);
                this.timing("get_slice", startDate);
                if (attempts > 1) {
                    this.m_logger.info("get_slice() succeeded on attempt #{}", (Object)attempts);
                }
                bSuccess = true;
            }
            catch (Exception ex) {
                if (attempts >= ServerConfig.getInstance().max_read_attempts) {
                    String errMsg = "All retries exceeded; abandoning get_slice() for table: " + colParent.getColumn_family();
                    this.m_bFailed = true;
                    this.m_logger.error(errMsg, (Throwable)ex);
                    throw new RuntimeException(errMsg, ex);
                }
                this.m_logger.warn("get_slice() attempt #{} failed: {}", (Object)attempts, (Object)ex);
                try {
                    Thread.sleep(attempts * ServerConfig.getInstance().retry_wait_millis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.reconnect(ex);
            }
            ++attempts;
        }
        return columnList;
    }

    private Iterator<DRow> fetchColumnSlice(ColumnParent colPar, List<byte[]> rowKeys, byte[] startColName, byte[] endColName, boolean reversed) {
        ArrayList<CassandraRow> rowList = new ArrayList<CassandraRow>();
        Map<ByteBuffer, List<ColumnOrSuperColumn>> keyMap = this.multigetSlice(CassandraDefs.convertByteKeys(rowKeys), colPar, CassandraDefs.slicePredicateStartEndCol(startColName, endColName, reversed));
        for (ByteBuffer rowKeyBB : keyMap.keySet()) {
            List<ColumnOrSuperColumn> coscList = keyMap.get(rowKeyBB);
            if (coscList.size() == 0) continue;
            byte[] rowKey = Utils.getBytes((ByteBuffer)rowKeyBB);
            rowList.add(new CassandraRow(rowKey, new CassandraColumnBatch(this.m_keyspace, colPar, rowKey, coscList)));
        }
        return rowList.iterator();
    }

    private ColumnOrSuperColumn getColumn(ByteBuffer key, ColumnPath colPath) {
        this.m_logger.debug("Fetching {}.{}", new Object[]{Utils.toString((ByteBuffer)key), DBConn.toString(colPath)});
        ColumnOrSuperColumn column = null;
        boolean bSuccess = false;
        int attempts = 1;
        while (!bSuccess) {
            try {
                Date startDate = new Date();
                column = this.m_client.get(key, colPath, ConsistencyLevel.ONE);
                this.timing("get", startDate);
                if (attempts > 1) {
                    this.m_logger.info("get() succeeded on attempt #{}", (Object)attempts);
                }
                bSuccess = true;
            }
            catch (NotFoundException ex) {
                return null;
            }
            catch (Exception ex) {
                if (attempts >= ServerConfig.getInstance().max_read_attempts) {
                    String errMsg = "All retries exceeded; abandoning get() for table: " + colPath.getColumn_family();
                    this.m_bFailed = true;
                    this.m_logger.error(errMsg, (Throwable)ex);
                    throw new RuntimeException(errMsg, ex);
                }
                this.m_logger.warn("get() attempt #{} failed: {}", (Object)attempts, (Object)ex);
                try {
                    Thread.sleep(attempts * ServerConfig.getInstance().retry_wait_millis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.reconnect(ex);
            }
            ++attempts;
        }
        return column;
    }

    private Map<ByteBuffer, List<ColumnOrSuperColumn>> multigetSlice(List<ByteBuffer> rowKeyList, ColumnParent colParent, SlicePredicate slicePred) {
        this.m_logger.debug("Fetching {} keys {} from {}", new Object[]{rowKeyList.size(), DBConn.toString(slicePred), DBConn.toString(colParent)});
        Map keyMap = null;
        boolean bSuccess = false;
        int attempts = 1;
        while (!bSuccess) {
            try {
                Date startDate = new Date();
                keyMap = this.m_client.multiget_slice(rowKeyList, colParent, slicePred, ConsistencyLevel.ONE);
                this.timing("multiget_slice", startDate);
                if (attempts > 1) {
                    this.m_logger.info("multiget_slice() succeeded on attempt #{}", (Object)attempts);
                }
                bSuccess = true;
            }
            catch (Exception ex) {
                if (attempts >= ServerConfig.getInstance().max_read_attempts) {
                    String errMsg = "All retries exceeded; abandoning multiget_slice() for table: " + colParent.getColumn_family();
                    this.m_bFailed = true;
                    this.m_logger.error(errMsg, (Throwable)ex);
                    throw new RuntimeException(errMsg, ex);
                }
                this.m_logger.warn("multiget_slice() attempt #{} failed: {}", (Object)attempts, (Object)ex);
                try {
                    Thread.sleep(attempts * ServerConfig.getInstance().retry_wait_millis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.reconnect(ex);
            }
            ++attempts;
        }
        return keyMap;
    }

    private void commitDeletes(CassandraTransaction cassDBTran) {
        Map<String, Set<ByteBuffer>> rowDeleteMap = cassDBTran.getRowDeletionMap();
        if (rowDeleteMap.size() == 0) {
            return;
        }
        for (String colFamName : rowDeleteMap.keySet()) {
            Set<ByteBuffer> rowKeySet = rowDeleteMap.get(colFamName);
            for (ByteBuffer rowKey : rowKeySet) {
                this.removeRow(cassDBTran.getTimestamp(), rowKey, new ColumnPath(colFamName));
            }
        }
    }

    private void commitMutations(CassandraTransaction cassDBTran) {
        Map<ByteBuffer, Map<String, List<Mutation>>> colMutMap = cassDBTran.getUpdateMap();
        if (colMutMap.size() == 0) {
            return;
        }
        this.m_logger.debug("Committing {} mutations", (Object)cassDBTran.totalColumnMutations());
        boolean bSuccess = false;
        int attempts = 1;
        while (!bSuccess) {
            try {
                Date startDate = new Date();
                this.m_client.batch_mutate(colMutMap, ConsistencyLevel.ONE);
                this.timing("commitMutations", startDate);
                if (attempts > 1) {
                    this.m_logger.info("batch_mutate() succeeded on attempt #{}", (Object)attempts);
                }
                bSuccess = true;
            }
            catch (Exception ex) {
                if (attempts >= ServerConfig.getInstance().max_commit_attempts) {
                    this.m_bFailed = true;
                    this.m_logger.error("All retries exceeded; abandoning batch_mutate()", (Throwable)ex);
                    throw new RuntimeException("All retries exceeded; abandoning batch_mutate()", ex);
                }
                this.m_logger.warn("batch_mutate() attempt #{} failed: {}", (Object)attempts, (Object)ex);
                try {
                    Thread.sleep(attempts * ServerConfig.getInstance().retry_wait_millis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.reconnect(ex);
            }
            ++attempts;
        }
    }

    private TSocket createTLSSocket(String host) throws TTransportException {
        ServerConfig config = ServerConfig.getInstance();
        String[] cipherSuites = config.dbtls_cipher_suites.toArray(new String[0]);
        TSSLTransportFactory.TSSLTransportParameters sslParams = new TSSLTransportFactory.TSSLTransportParameters("SSL", cipherSuites);
        if (!Utils.isEmpty((String)config.keystore)) {
            sslParams.setKeyStore(config.keystore, config.keystorepassword);
        }
        if (!Utils.isEmpty((String)config.truststore)) {
            sslParams.setTrustStore(config.truststore, config.truststorepassword);
        }
        return TSSLTransportFactory.getClientSocket((String)host, (int)config.dbport, (int)config.db_timeout_millis, (TSSLTransportFactory.TSSLTransportParameters)sslParams);
    }

    private DColumn fetchColumn(ColumnParent colPar, byte[] rowKey, byte[] colName) {
        ColumnPath colPath = new ColumnPath();
        colPath.setColumn_family(colPar.getColumn_family());
        colPath.setColumn(colName);
        ColumnOrSuperColumn cosc = this.getColumn(ByteBuffer.wrap(rowKey), colPath);
        if (cosc == null) {
            return null;
        }
        Column col = cosc.getColumn();
        return new DColumn(col.getName(), col.getValue());
    }

    private Iterator<DRow> fetchRowsAllColumns(ColumnParent colPar, Collection<byte[]> rowKeys) {
        ArrayList<CassandraRow> rowList = new ArrayList<CassandraRow>();
        Map<ByteBuffer, List<ColumnOrSuperColumn>> keyMap = this.multigetSlice(CassandraDefs.convertByteKeys(rowKeys), colPar, CassandraDefs.SLICE_PRED_ALL_COLS);
        for (ByteBuffer rowKeyBB : keyMap.keySet()) {
            List<ColumnOrSuperColumn> coscList = keyMap.get(rowKeyBB);
            if (coscList.size() == 0) continue;
            byte[] rowKey = Utils.getBytes((ByteBuffer)rowKeyBB);
            rowList.add(new CassandraRow(rowKey, new CassandraColumnBatch(this.m_keyspace, colPar, rowKey, coscList)));
        }
        return rowList.iterator();
    }

    private Iterator<DColumn> fetchAllColumns(ColumnParent colPar, byte[] rowKey) {
        CassandraColumnBatch colBatch = new CassandraColumnBatch(this, colPar, rowKey, CassandraDefs.SLICE_PRED_ALL_COLS);
        return colBatch.hasNext() ? colBatch : null;
    }

    private Iterator<DColumn> getColumnSlice(ColumnParent colPar, byte[] rowKey, byte[] startColName, byte[] endColName, boolean reversed) {
        return new CassandraColumnBatch(this, colPar, rowKey, CassandraDefs.slicePredicateStartEndCol(startColName, endColName, reversed));
    }

    private Iterator<DColumn> getColumnSlice(ColumnParent colPar, byte[] rowKey, byte[] startColName, byte[] endColName) {
        return new CassandraColumnBatch(this, colPar, rowKey, CassandraDefs.slicePredicateStartEndCol(startColName, endColName));
    }

    private Iterator<DRow> fetchAllRows(ColumnParent colPar) {
        return new CassandraRowBatch(this, colPar);
    }

    private Iterator<DRow> fetchRowsColumns(ColumnParent colPar, Collection<byte[]> rowKeys, Collection<byte[]> colNames) {
        ArrayList<CassandraRow> rowList = new ArrayList<CassandraRow>();
        Map<ByteBuffer, List<ColumnOrSuperColumn>> keyMap = this.multigetSlice(CassandraDefs.convertByteKeys(rowKeys), colPar, CassandraDefs.slicePredicateColNames(colNames));
        for (ByteBuffer rowKeyBB : keyMap.keySet()) {
            List<ColumnOrSuperColumn> coscList = keyMap.get(rowKeyBB);
            if (coscList.size() == 0) continue;
            byte[] rowKey = Utils.getBytes((ByteBuffer)rowKeyBB);
            rowList.add(new CassandraRow(rowKey, new CassandraColumnBatch(this.m_keyspace, colPar, rowKey, coscList)));
        }
        return rowList.iterator();
    }

    private void reconnect(Exception reconnectEx) {
        this.m_logger.warn("Reconnecting to Cassandra due to error", (Throwable)reconnectEx);
        boolean bSuccess = false;
        int attempt = 1;
        while (!bSuccess) {
            try {
                this.close();
                ThriftService.instance().connectDBConn(this);
                this.m_logger.debug("Reconnected successful");
                bSuccess = true;
            }
            catch (Exception ex) {
                if (attempt >= ServerConfig.getInstance().max_reconnect_attempts) {
                    this.m_logger.error("All reconnect attempts failed; abandoning reconnect", (Throwable)ex);
                    throw new DBNotAvailableException("All reconnect attempts failed", ex);
                }
                this.m_logger.warn("Reconnect attempt #" + attempt + " failed", (Throwable)ex);
                try {
                    Thread.sleep(ServerConfig.getInstance().retry_wait_millis * attempt);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++attempt;
        }
    }

    private void removeRow(long timestamp, ByteBuffer key, ColumnPath colPath) {
        assert (key != null);
        assert (colPath != null);
        this.m_logger.debug("Removing row {} from {}", (Object)Utils.toString((byte[])Utils.copyBytes((ByteBuffer)key)), (Object)DBConn.toString(colPath));
        boolean bSuccess = false;
        int attempts = 1;
        while (!bSuccess) {
            try {
                Date startDate = new Date();
                this.m_client.remove(key, colPath, timestamp, ConsistencyLevel.ONE);
                this.timing("remove", startDate);
                if (attempts > 1) {
                    this.m_logger.info("remove() succeeded on attempt #{}", (Object)attempts);
                }
                bSuccess = true;
            }
            catch (Exception ex) {
                if (attempts >= ServerConfig.getInstance().max_commit_attempts) {
                    this.m_bFailed = true;
                    String errMsg = "All retries exceeded; abandoning remove() for table: " + colPath.getColumn_family();
                    this.m_logger.error(errMsg, (Throwable)ex);
                    throw new RuntimeException(errMsg, ex);
                }
                this.m_logger.warn("remove() attempt #{} failed: {}", (Object)attempts, (Object)ex);
                try {
                    Thread.sleep(attempts * ServerConfig.getInstance().retry_wait_millis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.reconnect(ex);
            }
            ++attempts;
        }
    }

    private void timing(String metric, Date startDate) {
        this.m_logger.trace("Time for '{}': {}", (Object)metric, (Object)(String.valueOf(new Date().getTime() - startDate.getTime()) + " millis"));
    }

    private static String toString(KeyRange keyRange) {
        ByteBuffer startKey = keyRange.start_key;
        String startKeyStr = "<null>";
        if (startKey != null) {
            startKeyStr = Utils.toString((byte[])startKey.array(), (int)startKey.arrayOffset(), (int)startKey.limit());
        }
        if (startKeyStr.length() == 0) {
            startKeyStr = "<first>";
        }
        ByteBuffer endKey = keyRange.end_key;
        String endKeyStr = "<null>";
        if (endKey != null) {
            endKeyStr = Utils.toString((byte[])endKey.array(), (int)endKey.arrayOffset(), (int)endKey.limit());
        }
        if (endKeyStr.length() == 0) {
            endKeyStr = "<last>";
        }
        StringBuilder buffer = new StringBuilder();
        if (startKeyStr.equals("<first>") && endKeyStr.equals("<last>")) {
            buffer.append("Keys(<all>)");
        } else if (startKeyStr.equals(endKeyStr)) {
            buffer.append("Key('");
            buffer.append(startKeyStr);
            buffer.append("')");
        } else {
            buffer.append("Keys('");
            buffer.append(startKeyStr);
            buffer.append("' to '");
            buffer.append(endKeyStr);
            buffer.append("')");
        }
        return buffer.toString();
    }

    private static String toString(SlicePredicate slicePred) {
        StringBuilder buffer = new StringBuilder();
        if (slicePred.isSetColumn_names()) {
            buffer.append("Columns(");
            buffer.append(slicePred.getColumn_names().size());
            buffer.append(" total)");
        } else if (slicePred.isSetSlice_range()) {
            SliceRange sliceRange = slicePred.getSlice_range();
            ByteBuffer startCol = sliceRange.start;
            String startColStr = "<null>";
            if (startCol != null) {
                startColStr = Utils.toString((byte[])startCol.array(), (int)startCol.arrayOffset(), (int)startCol.limit());
            }
            if (startColStr.length() == 0) {
                startColStr = "<first>";
            }
            ByteBuffer endCol = sliceRange.finish;
            String endColStr = "<null>";
            if (endCol != null) {
                endColStr = Utils.toString((byte[])endCol.array(), (int)endCol.arrayOffset(), (int)endCol.limit());
            }
            if (endColStr.length() == 0) {
                endColStr = "<last>";
            }
            if (startColStr.equals("<first>") && endColStr.equals("<last>")) {
                buffer.append("Slice(<all>)");
            } else {
                buffer.append("Slice('");
                buffer.append(startColStr);
                buffer.append("' to '");
                buffer.append(endColStr);
                buffer.append("')");
            }
        }
        return buffer.toString();
    }

    private static String toString(ColumnParent colParent) {
        return "CF '" + colParent.getColumn_family() + "'";
    }

    private static String toString(ColumnPath colPath) {
        return "CF '" + colPath.getColumn_family() + "'";
    }
}

