/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.db.thrift;

import com.dell.doradus.common.Utils;
import com.dell.doradus.service.db.DBTransaction;
import com.dell.doradus.service.db.Tenant;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.Deletion;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.thrift.SuperColumn;
import org.slf4j.Logger;

public class CassandraTransaction
extends DBTransaction {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final long m_timestamp;
    private final Map<ByteBuffer, Map<String, List<Mutation>>> m_mutationMap = new HashMap<ByteBuffer, Map<String, List<Mutation>>>();
    private final Map<String, Set<ByteBuffer>> m_deletionMap = new HashMap<String, Set<ByteBuffer>>();
    private int m_colUpdates;
    private int m_rowDeletes;
    private final String m_keyspace;

    public CassandraTransaction(Tenant tenant) {
        this.m_keyspace = tenant.getKeyspace();
        this.m_timestamp = Utils.getTimeMicros();
    }

    @Override
    public void clear() {
        this.m_mutationMap.clear();
        this.m_deletionMap.clear();
        this.m_colUpdates = 0;
        this.m_rowDeletes = 0;
    }

    @Override
    public int getUpdateCount() {
        return this.m_colUpdates + this.m_rowDeletes;
    }

    public String getKeyspace() {
        return this.m_keyspace;
    }

    @Override
    public void addColumn(String storeName, String rowKey, String colName) {
        Mutation mutation = this.createMutation(Utils.toBytes((String)colName), EMPTY_BYTES, this.m_timestamp);
        this.addMutation(storeName, rowKey, mutation);
    }

    @Override
    public void addColumn(String storeName, String rowKey, String colName, String colValue) {
        Mutation mutation = this.createMutation(Utils.toBytes((String)colName), Utils.toBytes((String)colValue), this.m_timestamp);
        this.addMutation(storeName, rowKey, mutation);
    }

    @Override
    public void addColumn(String storeName, String rowKey, String colName, byte[] colValue) {
        Mutation mutation = this.createMutation(Utils.toBytes((String)colName), colValue, this.m_timestamp);
        this.addMutation(storeName, rowKey, mutation);
    }

    @Override
    public void addColumn(String storeName, String rowKey, String colName, long colValue) {
        Mutation mutation = this.createMutation(Utils.toBytes((String)colName), Utils.toBytes((String)Long.toString(colValue)), this.m_timestamp);
        this.addMutation(storeName, rowKey, mutation);
    }

    @Override
    public void deleteColumn(String storeName, String rowKey, String colName) {
        Mutation mutation = this.createDeleteColumnMutation(Utils.toBytes((String)colName));
        this.addMutation(storeName, rowKey, mutation);
    }

    @Override
    public void deleteColumns(String storeName, String rowKey, Collection<String> colNames) {
        ArrayList<ByteBuffer> colNamesList = new ArrayList<ByteBuffer>();
        for (String colName : colNames) {
            colNamesList.add(ByteBuffer.wrap(Utils.toBytes((String)colName)));
        }
        Mutation mutation = this.createDeleteColumnMutation(colNamesList);
        this.addMutation(storeName, rowKey, mutation);
    }

    @Override
    public void deleteRow(String storeName, String objectID) {
        Set<ByteBuffer> keySet = this.m_deletionMap.get(storeName);
        if (keySet == null) {
            keySet = new HashSet<ByteBuffer>();
            this.m_deletionMap.put(storeName, keySet);
        }
        keySet.add(ByteBuffer.wrap(Utils.toBytes((String)objectID)));
        ++this.m_rowDeletes;
    }

    public long getTimestamp() {
        return this.m_timestamp;
    }

    public Map<String, Set<ByteBuffer>> getRowDeletionMap() {
        return this.m_deletionMap;
    }

    public Map<ByteBuffer, Map<String, List<Mutation>>> getUpdateMap() {
        return this.m_mutationMap;
    }

    public int totalColumnMutations() {
        return this.m_colUpdates;
    }

    public int totalRowDeletes() {
        return this.m_rowDeletes;
    }

    public void traceMutations(Logger logger) {
        for (Map.Entry<ByteBuffer, Map<String, List<Mutation>>> mapEntry : this.m_mutationMap.entrySet()) {
            ByteBuffer rowKey = mapEntry.getKey();
            Map<String, List<Mutation>> colFamMap = mapEntry.getValue();
            for (String colFam : colFamMap.keySet()) {
                List<Mutation> mutationList = colFamMap.get(colFam);
                logger.trace("{}['{}'] has {} column mutations:", new Object[]{colFam, Utils.deWhite((ByteBuffer)rowKey), mutationList.size()});
                for (Mutation mutation : mutationList) {
                    if (mutation.isSetDeletion()) {
                        Deletion deletion = mutation.getDeletion();
                        SlicePredicate predicate = deletion.getPredicate();
                        if (predicate.isSetColumn_names()) {
                            List colNames = predicate.getColumn_names();
                            StringBuilder buffer = new StringBuilder();
                            for (ByteBuffer colName : colNames) {
                                if (buffer.length() > 0) {
                                    buffer.append(", ");
                                }
                                buffer.append(Utils.deWhite((ByteBuffer)colName));
                            }
                            logger.trace("   Deleted: {}", (Object)buffer.toString());
                            continue;
                        }
                        SliceRange sliceRange = predicate.getSlice_range();
                        logger.trace("   Deleted: {} to {}", (Object)Utils.deWhite((byte[])sliceRange.getStart()), (Object)Utils.deWhite((byte[])sliceRange.getFinish()));
                        continue;
                    }
                    ColumnOrSuperColumn cosc = mutation.getColumn_or_supercolumn();
                    if (cosc.isSetCounter_column()) {
                        CounterColumn counterCol = cosc.getCounter_column();
                        logger.trace("   {} += ({})", (Object)Utils.deWhite((byte[])counterCol.getName()), (Object)counterCol.getValue());
                        continue;
                    }
                    if (cosc.isSetColumn()) {
                        Column col = cosc.getColumn();
                        String colValue = Utils.deWhite((byte[])col.getValue());
                        if (colValue == null || colValue.length() == 0) {
                            colValue = "[null]";
                        }
                        logger.trace("   {} : {}", (Object)Utils.deWhite((byte[])col.getName()), (Object)colValue);
                        continue;
                    }
                    if (!cosc.isSetSuper_column()) continue;
                    SuperColumn superCol = cosc.getSuper_column();
                    logger.trace("   Supercolumn '{}' set", (Object)Utils.deWhite((byte[])superCol.getName()));
                }
            }
        }
    }

    public void addMutationList(String cfName, String rowKey, List<Mutation> mutations) {
        List<Mutation> mutationList;
        ByteBuffer rowKeyBB = ByteBuffer.wrap(Utils.toBytes((String)rowKey));
        Map<String, List<Mutation>> colFamMap = this.m_mutationMap.get(rowKeyBB);
        if (colFamMap == null) {
            colFamMap = new HashMap<String, List<Mutation>>();
            this.m_mutationMap.put(rowKeyBB, colFamMap);
        }
        if ((mutationList = colFamMap.get(cfName)) == null) {
            mutationList = new ArrayList<Mutation>();
            colFamMap.put(cfName, mutationList);
        }
        mutationList.addAll(mutations);
        this.m_colUpdates += mutations.size();
    }

    private void addMutation(String cfName, String rowKey, Mutation mutation) {
        List<Mutation> mutationList;
        ByteBuffer rowKeyBB = ByteBuffer.wrap(Utils.toBytes((String)rowKey));
        Map<String, List<Mutation>> colFamMap = this.m_mutationMap.get(rowKeyBB);
        if (colFamMap == null) {
            colFamMap = new HashMap<String, List<Mutation>>();
            this.m_mutationMap.put(rowKeyBB, colFamMap);
        }
        if ((mutationList = colFamMap.get(cfName)) == null) {
            mutationList = new ArrayList<Mutation>();
            colFamMap.put(cfName, mutationList);
        }
        mutationList.add(mutation);
        ++this.m_colUpdates;
    }

    private Mutation createMutation(byte[] colName, byte[] colValue, long timestamp) {
        if (colValue == null) {
            colValue = EMPTY_BYTES;
        }
        Column col = new Column();
        col.setName(colName);
        col.setValue(colValue);
        col.setTimestamp(timestamp);
        ColumnOrSuperColumn cosc = new ColumnOrSuperColumn();
        cosc.setColumn(col);
        Mutation mutation = new Mutation();
        mutation.setColumn_or_supercolumn(cosc);
        return mutation;
    }

    private Mutation createDeleteColumnMutation(byte[] colName) {
        SlicePredicate slicePred = new SlicePredicate();
        slicePred.addToColumn_names(ByteBuffer.wrap(colName));
        Deletion deletion = new Deletion();
        deletion.setPredicate(slicePred);
        deletion.setTimestamp(this.m_timestamp);
        Mutation mutation = new Mutation();
        mutation.setDeletion(deletion);
        return mutation;
    }

    private Mutation createDeleteColumnMutation(List<ByteBuffer> colNames) {
        SlicePredicate slicePred = new SlicePredicate();
        slicePred.setColumn_names(colNames);
        Deletion deletion = new Deletion();
        deletion.setPredicate(slicePred);
        deletion.setTimestamp(this.m_timestamp);
        Mutation mutation = new Mutation();
        mutation.setDeletion(deletion);
        return mutation;
    }
}

