/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.db.thrift;

import com.dell.doradus.core.ServerConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.KsDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraSchemaMgr {
    private static final String DEFAULT_KS_STRATEGY_CLASS = "SimpleStrategy";
    private static final String DEFAULT_KS_REPLICATION_FACTOR = "1";
    private static final List<CfDef> DEFAULT_KS_CF_DEFS = new ArrayList<CfDef>();
    private static final boolean DEFAULT_KS_DURABLE_WRITES = true;
    private final Cassandra.Client m_client;
    private final Logger m_logger = LoggerFactory.getLogger((String)this.getClass().getSimpleName());

    public CassandraSchemaMgr(Cassandra.Client client) {
        this.m_client = client;
    }

    public Collection<String> getKeyspaces() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            for (KsDef ksDef : this.m_client.describe_keyspaces()) {
                result.add(ksDef.getName());
            }
        }
        catch (Exception e) {
            String errMsg = "Failed to get keyspace description";
            this.m_logger.error(errMsg, (Throwable)e);
            throw new RuntimeException(errMsg, e);
        }
        return result;
    }

    public void createKeyspace(String keyspace, Map<String, String> options) {
        this.m_logger.info("Creating Keyspace '{}'", (Object)keyspace);
        try {
            KsDef ksDef = this.setKeySpaceOptions(keyspace);
            this.overrideKSOptions(ksDef, options);
            this.m_client.system_add_keyspace(ksDef);
        }
        catch (Exception ex) {
            String errMsg = "Failed to create Keyspace '" + keyspace + "'";
            this.m_logger.error(errMsg, (Throwable)ex);
            throw new RuntimeException(errMsg, ex);
        }
    }

    public boolean keyspaceExists(String keyspace) {
        try {
            this.m_client.describe_keyspace(keyspace);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void dropKeyspace(String keyspace) {
        this.m_logger.info("Deleting Keyspace '{}'", (Object)keyspace);
        try {
            this.m_client.system_drop_keyspace(keyspace);
        }
        catch (Exception ex) {
            String errMsg = "Failed to delete Keyspace '" + keyspace + "'";
            this.m_logger.error(errMsg, (Throwable)ex);
            throw new RuntimeException(errMsg, ex);
        }
    }

    public void createColumnFamily(String keyspace, String cfName, boolean bBinaryValues) {
        Map<String, Object> cfOptions;
        this.m_logger.info("Creating ColumnFamily: {}:{}", (Object)keyspace, (Object)cfName);
        CfDef cfDef = new CfDef();
        cfDef.setKeyspace(keyspace);
        cfDef.setName(cfName);
        cfDef.setColumn_type("Standard");
        cfDef.setComparator_type("UTF8Type");
        cfDef.setKey_validation_class("UTF8Type");
        if (bBinaryValues) {
            cfDef.setDefault_validation_class("BytesType");
        } else {
            cfDef.setDefault_validation_class("UTF8Type");
        }
        Map<String, Object> map = cfOptions = cfName.startsWith("OLAP") ? ServerConfig.getInstance().olap_cf_defaults : ServerConfig.getInstance().cf_defaults;
        if (cfOptions != null) {
            for (String optName : cfOptions.keySet()) {
                Object optValue = cfOptions.get(optName);
                CfDef._Fields fieldEnum = CfDef._Fields.findByName((String)optName);
                if (fieldEnum == null) {
                    this.m_logger.warn("Unknown ColumnFamily option: {}", (Object)optName);
                    continue;
                }
                try {
                    cfDef.setFieldValue(fieldEnum, optValue);
                }
                catch (Exception e) {
                    this.m_logger.warn("Error setting ColumnFamily option '" + optName + "' to '" + optValue + "' -- ignoring", (Throwable)e);
                }
            }
        }
        try {
            this.validateSchema(this.m_client.system_add_column_family(cfDef));
        }
        catch (Exception ex) {
            throw new RuntimeException("ColumnFamily creation failed", ex);
        }
    }

    public boolean columnFamilyExists(String keyspace, String cfName) {
        KsDef ksDef = null;
        try {
            ksDef = this.m_client.describe_keyspace(keyspace);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to get keyspace definition for '" + keyspace + "'", ex);
        }
        List cfDefList = ksDef.getCf_defs();
        for (CfDef cfDef : cfDefList) {
            if (!cfDef.getName().equals(cfName)) continue;
            return true;
        }
        return false;
    }

    public void deleteColumnFamily(String cfName) {
        this.m_logger.info("Deleting ColumnFamily: {}", (Object)cfName);
        try {
            this.m_client.system_drop_column_family(cfName);
        }
        catch (Exception ex) {
            throw new RuntimeException("drop_column_family failed", ex);
        }
    }

    public Collection<String> getColumnFamilies(String keyspace) {
        KsDef ksDef = null;
        try {
            ksDef = this.m_client.describe_keyspace(keyspace);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to get keyspace definition for '" + keyspace + "'", ex);
        }
        HashSet<String> result = new HashSet<String>();
        for (CfDef cfDef : ksDef.getCf_defs()) {
            result.add(cfDef.getName());
        }
        return result;
    }

    private KsDef setKeySpaceOptions(String keyspace) {
        KsDef ksDef = new KsDef();
        ksDef.setName(keyspace);
        Map<String, Object> ksOptions = ServerConfig.getInstance().ks_defaults;
        if (ksOptions != null) {
            for (String name : ksOptions.keySet()) {
                Object value = ksOptions.get(name);
                if (name.equals("name") && !keyspace.equals(value)) {
                    this.m_logger.warn("ks_defaults.name: Keyspace name should be set through 'keyspace' option -- ignored");
                    continue;
                }
                try {
                    KsDef._Fields field = KsDef._Fields.findByName((String)name);
                    if (field == null) {
                        this.m_logger.warn("Unknown KeySpace option: {} -- ignoring", (Object)name);
                        continue;
                    }
                    ksDef.setFieldValue(field, value);
                }
                catch (Exception e) {
                    this.m_logger.warn("Error setting Keyspace option '" + name + "' to '" + value + "' -- ignoring", (Throwable)e);
                }
            }
        }
        if (!ksDef.isSetStrategy_class()) {
            ksDef.setStrategy_class(DEFAULT_KS_STRATEGY_CLASS);
        }
        if (!ksDef.isSetStrategy_options()) {
            HashMap<String, String> stratOpts = new HashMap<String, String>();
            stratOpts.put("replication_factor", DEFAULT_KS_REPLICATION_FACTOR);
            ksDef.setStrategy_options(stratOpts);
        }
        if (!ksDef.isSetCf_defs()) {
            ksDef.setCf_defs(DEFAULT_KS_CF_DEFS);
        }
        if (!ksDef.isSetDurable_writes()) {
            ksDef.setDurable_writes(true);
        }
        return ksDef;
    }

    private void overrideKSOptions(KsDef ksDef, Map<String, String> options) {
        String rfOpt;
        if (options != null && (rfOpt = options.get("ReplicationFactor")) != null) {
            HashMap<String, String> stratOpts = new HashMap<String, String>();
            stratOpts.put("replication_factor", rfOpt);
            ksDef.setStrategy_options(stratOpts);
        }
    }

    private void validateSchema(String currentVersionId) {
        Map versions = null;
        long limit = System.currentTimeMillis() + 5000L;
        boolean inAgreement = false;
        block2: do {
            try {
                versions = this.m_client.describe_schema_versions();
            }
            catch (Exception e) {
                continue;
            }
            for (String version : versions.keySet()) {
                if (!version.equals(currentVersionId)) continue;
                inAgreement = true;
                continue block2;
            }
        } while (limit - System.currentTimeMillis() >= 0L && !inAgreement);
        if (!inAgreement) {
            throw new RuntimeException("Cannot get agreement on Cassandra schema versions");
        }
    }
}

