/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.db.thrift;

import com.dell.doradus.service.db.DRow;
import com.dell.doradus.service.db.thrift.CassandraColumnBatch;
import com.dell.doradus.service.db.thrift.CassandraDefs;
import com.dell.doradus.service.db.thrift.CassandraRow;
import com.dell.doradus.service.db.thrift.DBConn;
import com.dell.doradus.service.db.thrift.ThriftService;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.SlicePredicate;

public class CassandraRowBatch
implements Iterator<DRow> {
    private final String m_keyspace;
    private ColumnParent m_columnParent;
    private int m_countRows;
    private byte[] m_lastKey;
    private Iterator<KeySlice> m_iRows;
    private DRow m_next = null;

    public CassandraRowBatch(DBConn dbConn, ColumnParent columnParent) {
        this.m_keyspace = dbConn.getKeyspace();
        this.m_columnParent = columnParent;
        KeyRange keyRange = CassandraDefs.KEY_RANGE_ALL_ROWS;
        SlicePredicate slicePredicate = CassandraDefs.SLICE_PRED_ALL_COLS;
        List<KeySlice> keySliceList = dbConn.getRangeSlices(columnParent, slicePredicate, keyRange);
        this.m_countRows = 0;
        this.m_iRows = keySliceList.iterator();
        this.m_lastKey = CassandraDefs.EMPTY_BYTES;
        this.shiftRow();
    }

    @Override
    public boolean hasNext() {
        return this.m_next != null;
    }

    @Override
    public DRow next() {
        if (this.m_next == null) {
            throw new NoSuchElementException("RowsIterator: No more rows");
        }
        DRow result = this.m_next;
        this.shiftRow();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("RowsIterator: Removing rows is not supported");
    }

    private KeySlice nextSlice() {
        ++this.m_countRows;
        return this.m_iRows.next();
    }

    private void shiftRow() {
        block3: {
            block4: {
                List columnsList;
                while (true) {
                    if (this.m_iRows.hasNext()) {
                        KeySlice keySlice = this.nextSlice();
                        this.m_lastKey = keySlice.getKey();
                        List columnsList2 = keySlice.getColumns();
                        if (columnsList2.isEmpty()) continue;
                        this.m_next = new CassandraRow(this.m_lastKey, new CassandraColumnBatch(this.m_keyspace, this.m_columnParent, this.m_lastKey, columnsList2));
                        break block3;
                    }
                    if (this.m_countRows < 100) {
                        this.m_next = null;
                        break block3;
                    }
                    List<KeySlice> keySliceList = this.getNextBatch(this.m_lastKey);
                    this.m_countRows = 0;
                    this.m_iRows = keySliceList.iterator();
                    if (!this.m_iRows.hasNext()) break block4;
                    KeySlice keySlice = this.nextSlice();
                    columnsList = keySlice.getColumns();
                    boolean equalKeys = Arrays.equals(this.m_lastKey, keySlice.getKey());
                    this.m_lastKey = keySlice.getKey();
                    if (!equalKeys && !columnsList.isEmpty()) break;
                }
                this.m_next = new CassandraRow(this.m_lastKey, new CassandraColumnBatch(this.m_keyspace, this.m_columnParent, this.m_lastKey, columnsList));
                break block3;
            }
            this.m_next = null;
        }
    }

    private List<KeySlice> getNextBatch(byte[] startKey) {
        KeyRange keyRange = CassandraDefs.keyRangeStartRow(startKey);
        SlicePredicate slicePredicate = CassandraDefs.SLICE_PRED_ALL_COLS;
        DBConn dbConn = ThriftService.instance().getDBConnection(this.m_keyspace);
        try {
            List<KeySlice> list = dbConn.getRangeSlices(this.m_columnParent, slicePredicate, keyRange);
            return list;
        }
        finally {
            ThriftService.instance().returnDBConnection(dbConn);
        }
    }
}

