/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.db.thrift;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;

public final class CassandraDefs {
    static final byte[] EMPTY_BYTES = new byte[0];
    static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.wrap(EMPTY_BYTES);
    static final int MAX_COLS_BATCH_SIZE = 10000;
    static final int MAX_ROWS_BATCH_SIZE = 100;
    static final SliceRange SLICE_RANGE_ALL_COLS = new SliceRange(EMPTY_BYTE_BUFFER, EMPTY_BYTE_BUFFER, false, 10000);
    static final SlicePredicate SLICE_PRED_ALL_COLS = new SlicePredicate();
    static final KeyRange KEY_RANGE_ALL_ROWS;

    static {
        SLICE_PRED_ALL_COLS.setSlice_range(SLICE_RANGE_ALL_COLS);
        KEY_RANGE_ALL_ROWS = new KeyRange();
        KEY_RANGE_ALL_ROWS.setStart_key(EMPTY_BYTE_BUFFER);
        KEY_RANGE_ALL_ROWS.setEnd_key(EMPTY_BYTE_BUFFER);
        KEY_RANGE_ALL_ROWS.setCount(100);
    }

    private CassandraDefs() {
    }

    static ColumnParent columnParent(String cfName) {
        return new ColumnParent(cfName);
    }

    static List<ByteBuffer> convertByteKeys(Collection<byte[]> rowKeys) {
        ArrayList<ByteBuffer> rowKeyList = new ArrayList<ByteBuffer>();
        for (byte[] rowKey : rowKeys) {
            rowKeyList.add(ByteBuffer.wrap(rowKey));
        }
        return rowKeyList;
    }

    static KeyRange keyRangeStartRow(byte[] startRowKey) {
        KeyRange keyRange = new KeyRange();
        keyRange.setStart_key(startRowKey);
        keyRange.setEnd_key(EMPTY_BYTE_BUFFER);
        keyRange.setCount(100);
        return keyRange;
    }

    static KeyRange keyRangeSingleRow(byte[] rowKey) {
        KeyRange keyRange = new KeyRange();
        keyRange.setStart_key(rowKey);
        keyRange.setEnd_key(rowKey);
        keyRange.setCount(1);
        return keyRange;
    }

    static SlicePredicate slicePredicateStartCol(byte[] startColName) {
        SliceRange sliceRange = new SliceRange(ByteBuffer.wrap(startColName), EMPTY_BYTE_BUFFER, false, 10000);
        SlicePredicate slicePred = new SlicePredicate();
        slicePred.setSlice_range(sliceRange);
        return slicePred;
    }

    static SlicePredicate slicePredicateStartEndCol(byte[] startColName, byte[] endColName, boolean reversed) {
        SliceRange sliceRange = new SliceRange(ByteBuffer.wrap(startColName), ByteBuffer.wrap(endColName), reversed, 10000);
        SlicePredicate slicePred = new SlicePredicate();
        slicePred.setSlice_range(sliceRange);
        return slicePred;
    }

    static SlicePredicate slicePredicateStartEndCol(byte[] startColName, byte[] endColName) {
        return CassandraDefs.slicePredicateStartEndCol(startColName, endColName, false);
    }

    static SlicePredicate slicePredicateColName(byte[] colName) {
        SlicePredicate slicePred = new SlicePredicate();
        slicePred.addToColumn_names(ByteBuffer.wrap(colName));
        return slicePred;
    }

    static SlicePredicate slicePredicateColNames(Collection<byte[]> colNames) {
        SlicePredicate slicePred = new SlicePredicate();
        for (byte[] colName : colNames) {
            slicePred.addToColumn_names(ByteBuffer.wrap(colName));
        }
        return slicePred;
    }
}

