/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.db.thrift;

import com.dell.doradus.common.Utils;
import com.dell.doradus.service.db.DColumn;
import com.dell.doradus.service.db.thrift.CassandraDefs;
import com.dell.doradus.service.db.thrift.DBConn;
import com.dell.doradus.service.db.thrift.ThriftService;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.SlicePredicate;

public class CassandraColumnBatch
implements Iterator<DColumn> {
    private String m_keyspace;
    private ColumnParent m_columnParent;
    private byte[] m_rowKey;
    private Iterator<ColumnOrSuperColumn> m_iColumns;
    private int m_sliceSize;
    private DColumn m_next = null;

    public CassandraColumnBatch(String keyspace, ColumnParent columnParent, byte[] rowKey, List<ColumnOrSuperColumn> columns) {
        this.m_keyspace = keyspace;
        this.m_columnParent = columnParent;
        this.m_rowKey = rowKey;
        this.m_sliceSize = 0;
        this.m_iColumns = columns.iterator();
        this.shiftColumn();
    }

    public CassandraColumnBatch(DBConn thisConn, ColumnParent columnParent, byte[] rowKey, SlicePredicate slicePredicate) {
        this.m_keyspace = thisConn.getKeyspace();
        this.m_columnParent = columnParent;
        this.m_rowKey = rowKey;
        List<ColumnOrSuperColumn> columns = thisConn.getSlice(this.m_columnParent, slicePredicate, ByteBuffer.wrap(this.m_rowKey));
        this.m_sliceSize = 0;
        this.m_iColumns = columns.iterator();
        if (!this.m_iColumns.hasNext()) {
            return;
        }
        this.shiftColumn();
    }

    @Override
    public boolean hasNext() {
        return this.m_next != null;
    }

    @Override
    public DColumn next() {
        if (this.m_next == null) {
            throw new NoSuchElementException("ColumnsIterator: No more column found");
        }
        DColumn result = this.m_next;
        this.shiftColumn();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("ColumnsIterator: Removing columns is not supported");
    }

    private void shiftColumn() {
        if (this.m_iColumns.hasNext()) {
            ColumnOrSuperColumn cosc = this.m_iColumns.next();
            ++this.m_sliceSize;
            Column column = cosc.getColumn();
            this.m_next = new DColumn(column.getName(), column.getValue());
        } else {
            if (this.m_sliceSize < 10000) {
                this.m_next = null;
                return;
            }
            if (this.m_next != null) {
                String lastName = this.m_next.getName();
                List<ColumnOrSuperColumn> columns = this.getNextSlice(lastName);
                this.m_sliceSize = 0;
                this.m_iColumns = columns.iterator();
                if (!this.m_iColumns.hasNext()) {
                    this.m_next = null;
                    return;
                }
                ColumnOrSuperColumn cosc = this.m_iColumns.next();
                ++this.m_sliceSize;
                Column column = cosc.getColumn();
                this.m_next = new DColumn(column.getName(), column.getValue());
                if (lastName.equals(this.m_next.getName())) {
                    this.shiftColumn();
                }
            }
        }
    }

    private List<ColumnOrSuperColumn> getNextSlice(String lastName) {
        SlicePredicate slicePredicate = CassandraDefs.slicePredicateStartCol(Utils.toBytes((String)lastName));
        DBConn dbConn = ThriftService.instance().getDBConnection(this.m_keyspace);
        try {
            List<ColumnOrSuperColumn> list = dbConn.getSlice(this.m_columnParent, slicePredicate, ByteBuffer.wrap(this.m_rowKey));
            return list;
        }
        finally {
            ThriftService.instance().returnDBConnection(dbConn);
        }
    }
}

