/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.db.memory;

import com.dell.doradus.service.db.DBTransaction;
import com.dell.doradus.service.db.DColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MemoryTransaction
extends DBTransaction {
    private final Map<String, Map<String, List<DColumn>>> m_updateMap = new HashMap<String, Map<String, List<DColumn>>>();
    private final Map<String, Map<String, List<String>>> m_deleteMap = new HashMap<String, Map<String, List<String>>>();
    private final String m_keyspace;
    private int m_updates;

    public MemoryTransaction(String keyspace) {
        this.m_keyspace = keyspace;
    }

    @Override
    public void clear() {
        this.m_updateMap.clear();
        this.m_deleteMap.clear();
        this.m_updates = 0;
    }

    public String getKeyspace() {
        return this.m_keyspace;
    }

    @Override
    public int getUpdateCount() {
        return this.m_updates;
    }

    @Override
    public void addColumn(String storeName, String rowKey, String colName) {
        this.addColumn(storeName, rowKey, colName, "");
    }

    @Override
    public void addColumn(String storeName, String rowKey, String colName, String colValue) {
        List<DColumn> colList = this.getUpdateColList(storeName, rowKey);
        colList.add(new DColumn(colName, colValue));
        ++this.m_updates;
    }

    @Override
    public void addColumn(String storeName, String rowKey, String colName, byte[] colValue) {
        List<DColumn> colList = this.getUpdateColList(storeName, rowKey);
        colList.add(new DColumn(colName, colValue));
        ++this.m_updates;
    }

    @Override
    public void addColumn(String storeName, String rowKey, String colName, long colValue) {
        this.addColumn(storeName, rowKey, colName, Long.toString(colValue));
    }

    @Override
    public void deleteRow(String storeName, String rowKey) {
        Map<String, List<String>> rowKeyMap = this.getDeleteColMap(storeName);
        rowKeyMap.put(rowKey, null);
        ++this.m_updates;
    }

    @Override
    public void deleteColumn(String storeName, String rowKey, String colName) {
        Map<String, List<String>> rowKeyMap = this.getDeleteColMap(storeName);
        List<String> colList = null;
        if (rowKeyMap.containsKey(rowKey) && (colList = rowKeyMap.get(rowKey)) == null) {
            this.m_logger.warn("deleteColumn() called for row being deleted; ignored. table={}, row={}, column={}", new Object[]{storeName, rowKey, colName});
            return;
        }
        if (colList == null) {
            colList = new ArrayList<String>();
            rowKeyMap.put(rowKey, colList);
        }
        colList.add(colName);
        ++this.m_updates;
    }

    @Override
    public void deleteColumns(String storeName, String rowKey, Collection<String> colNames) {
        Map<String, List<String>> rowKeyMap = this.getDeleteColMap(storeName);
        List<String> colList = null;
        if (rowKeyMap.containsKey(rowKey) && (colList = rowKeyMap.get(rowKey)) == null) {
            this.m_logger.warn("deleteColumns() called for row being deleted; ignored. table={}, row={}, # of columns={}", new Object[]{storeName, rowKey, colNames.size()});
            return;
        }
        if (colList == null) {
            colList = new ArrayList<String>();
            rowKeyMap.put(rowKey, colList);
        }
        colList.addAll(colNames);
        this.m_updates += colNames.size();
    }

    public Map<String, Map<String, List<DColumn>>> getUpdateMap() {
        return this.m_updateMap;
    }

    public Map<String, Map<String, List<String>>> getDeleteMap() {
        return this.m_deleteMap;
    }

    public List<DColumn> getUpdateColList(String tableName, String rowKey) {
        List<DColumn> colList;
        Map<String, List<DColumn>> rowMap = this.m_updateMap.get(tableName);
        if (rowMap == null) {
            rowMap = new HashMap<String, List<DColumn>>();
            this.m_updateMap.put(tableName, rowMap);
        }
        if ((colList = rowMap.get(rowKey)) == null) {
            colList = new ArrayList<DColumn>(1000);
            rowMap.put(rowKey, colList);
        }
        return colList;
    }

    public Map<String, List<String>> getDeleteColMap(String tableName) {
        Map<String, List<String>> rowMap = this.m_deleteMap.get(tableName);
        if (rowMap == null) {
            rowMap = new HashMap<String, List<String>>(1000);
            this.m_deleteMap.put(tableName, rowMap);
        }
        return rowMap;
    }
}

