/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.db.memory;

import com.dell.doradus.core.ServerConfig;
import com.dell.doradus.service.db.DBService;
import com.dell.doradus.service.db.DBTransaction;
import com.dell.doradus.service.db.DColumn;
import com.dell.doradus.service.db.DRow;
import com.dell.doradus.service.db.Tenant;
import com.dell.doradus.service.db.memory.MemoryTransaction;
import com.dell.doradus.service.tenant.UserDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class MemoryService
extends DBService {
    private static final MemoryService INSTANCE = new MemoryService();
    private final Object m_sync = new Object();
    private final Map<String, Keyspace> m_Keyspaces = new HashMap<String, Keyspace>();

    private MemoryService() {
    }

    public static MemoryService instance() {
        return INSTANCE;
    }

    @Override
    public void initService() {
        ServerConfig config = ServerConfig.getInstance();
        this.m_logger.info("Using MEMORY API");
        this.m_logger.warn("Memory API is not persistent and can be used ONLY for testing purposes!");
        this.m_logger.debug("Default application keyspace: {}", (Object)config.keyspace);
    }

    @Override
    public void startService() {
    }

    @Override
    public void stopService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTenant(Tenant tenant, Map<String, String> options) {
        Object object = this.m_sync;
        synchronized (object) {
            String keyspace = tenant.getKeyspace();
            if (this.m_Keyspaces.get(keyspace) != null) {
                return;
            }
            Keyspace ks = new Keyspace(keyspace);
            this.m_Keyspaces.put(keyspace, ks);
        }
    }

    @Override
    public void modifyTenant(Tenant tenant, Map<String, String> options) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropTenant(Tenant tenant) {
        Object object = this.m_sync;
        synchronized (object) {
            String keyspace = tenant.getKeyspace();
            if (this.m_Keyspaces.get(keyspace) == null) {
                return;
            }
            this.m_Keyspaces.remove(keyspace);
        }
    }

    @Override
    public void addUsers(Tenant tenant, Iterable<UserDefinition> users) {
        throw new RuntimeException("This method is not supported for the Memory API");
    }

    @Override
    public void modifyUsers(Tenant tenant, Iterable<UserDefinition> users) {
        throw new RuntimeException("This method is not supported for the Memory API");
    }

    @Override
    public void deleteUsers(Tenant tenant, Iterable<UserDefinition> users) {
        throw new RuntimeException("This method is not supported for the Memory API");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Tenant> getTenants() {
        ArrayList<Tenant> tenants = new ArrayList<Tenant>();
        Object object = this.m_sync;
        synchronized (object) {
            for (String keyspace : this.m_Keyspaces.keySet()) {
                tenants.add(new Tenant(keyspace));
            }
        }
        return tenants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createStoreIfAbsent(Tenant tenant, String storeName, boolean bBinaryValues) {
        Object object = this.m_sync;
        synchronized (object) {
            Keyspace ks = this.m_Keyspaces.get(tenant.getKeyspace());
            if (ks == null) {
                throw new RuntimeException("Keyspace does not exist");
            }
            Store st = ks.stores.get(storeName);
            if (st == null) {
                ks.stores.put(storeName, new Store(storeName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteStoreIfPresent(Tenant tenant, String storeName) {
        Object object = this.m_sync;
        synchronized (object) {
            Keyspace ks = this.m_Keyspaces.get(tenant.getKeyspace());
            if (ks == null) {
                throw new RuntimeException("Keyspace does not exist");
            }
            Store st = ks.stores.get(storeName);
            if (st != null) {
                ks.stores.remove(storeName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBTransaction startTransaction(Tenant tenant) {
        Object object = this.m_sync;
        synchronized (object) {
            Keyspace ks = this.getKeyspace(tenant);
            return new MemoryTransaction(ks.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(DBTransaction dbTran) {
        MemoryTransaction t = (MemoryTransaction)dbTran;
        Object object = this.m_sync;
        synchronized (object) {
            Row mrow;
            List<Object> columns;
            String row;
            Store store;
            Map<String, List<Object>> rows;
            String table;
            Keyspace ks = this.m_Keyspaces.get(t.getKeyspace());
            if (ks == null) {
                throw new RuntimeException("Keyspace does not exist");
            }
            for (Map.Entry<String, Map<String, List<DColumn>>> entry : t.getUpdateMap().entrySet()) {
                table = entry.getKey();
                rows = entry.getValue();
                store = ks.stores.get(table);
                if (store == null) {
                    store = new Store(table);
                    ks.stores.put(table, store);
                }
                for (Map.Entry<String, List<Object>> r : rows.entrySet()) {
                    row = r.getKey();
                    columns = r.getValue();
                    mrow = store.rows.get(row);
                    if (mrow == null) {
                        mrow = new Row(row);
                        store.rows.put(row, mrow);
                    }
                    for (Object c : columns) {
                        String col = ((DColumn)c).getName();
                        byte[] val = ((DColumn)c).getRawValue();
                        mrow.columns.put(col, val);
                    }
                }
            }
            for (Map.Entry<String, Map<String, List<Object>>> entry : t.getDeleteMap().entrySet()) {
                table = entry.getKey();
                rows = entry.getValue();
                store = ks.stores.get(table);
                if (store == null) continue;
                for (Map.Entry<String, List<Object>> r : rows.entrySet()) {
                    row = r.getKey();
                    columns = r.getValue();
                    mrow = store.rows.get(row);
                    if (mrow == null) continue;
                    if (columns == null) {
                        store.rows.remove(row);
                        continue;
                    }
                    for (Object c : columns) {
                        mrow.columns.remove(c);
                    }
                }
            }
        }
    }

    private Keyspace getKeyspace(Tenant tenant) {
        String keyspace = tenant.getKeyspace();
        Keyspace ks = this.m_Keyspaces.get(keyspace);
        if (ks == null) {
            ks = new Keyspace(keyspace);
            this.m_Keyspaces.put(keyspace, ks);
        }
        return ks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<DColumn> getAllColumns(Tenant tenant, String storeName, String rowKey) {
        Object object = this.m_sync;
        synchronized (object) {
            Keyspace ks = this.getKeyspace(tenant);
            Store st = ks.stores.get(storeName);
            if (st == null) {
                return new ArrayList(0).iterator();
            }
            Row r = st.rows.get(rowKey);
            if (r == null) {
                return new ArrayList(0).iterator();
            }
            ArrayList<DColumn> list = new ArrayList<DColumn>();
            for (Map.Entry<String, byte[]> e : r.columns.entrySet()) {
                list.add(new DColumn(e.getKey(), e.getValue()));
            }
            return list.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<DColumn> getColumnSlice(Tenant tenant, String storeName, String rowKey, String startCol, String endCol, boolean reversed) {
        if (reversed) {
            throw new RuntimeException("Not supported");
        }
        Object object = this.m_sync;
        synchronized (object) {
            Keyspace ks = this.getKeyspace(tenant);
            Store st = ks.stores.get(storeName);
            if (st == null) {
                throw new RuntimeException("Store does not exist");
            }
            Row r = st.rows.get(rowKey);
            if (r == null) {
                return new ArrayList(0).iterator();
            }
            ArrayList<DColumn> list = new ArrayList<DColumn>();
            for (Map.Entry<String, byte[]> e : r.columns.entrySet()) {
                if (startCol.compareTo(e.getKey()) > 0 || endCol.compareTo(e.getKey()) <= 0) continue;
                list.add(new DColumn(e.getKey(), e.getValue()));
            }
            return list.iterator();
        }
    }

    @Override
    public Iterator<DColumn> getColumnSlice(Tenant tenant, String storeName, String rowKey, String startCol, String endCol) {
        return this.getColumnSlice(tenant, storeName, rowKey, startCol, endCol, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DColumn getColumn(Tenant tenant, String storeName, String rowKey, String colName) {
        Object object = this.m_sync;
        synchronized (object) {
            byte[] val;
            block7: {
                Row r;
                block6: {
                    Keyspace ks = this.getKeyspace(tenant);
                    Store st = ks.stores.get(storeName);
                    if (st == null) {
                        throw new RuntimeException("Store does not exist");
                    }
                    r = st.rows.get(rowKey);
                    if (r != null) break block6;
                    return null;
                }
                val = (byte[])r.columns.get(colName);
                if (val != null) break block7;
                return null;
            }
            return new DColumn(colName, val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<DRow> getAllRowsAllColumns(Tenant tenant, String storeName) {
        Object object = this.m_sync;
        synchronized (object) {
            Keyspace ks = this.getKeyspace(tenant);
            Store st = ks.stores.get(storeName);
            if (st == null) {
                return new ArrayList(0).iterator();
            }
            ArrayList<Row> list = new ArrayList<Row>();
            for (Row row : st.rows.values()) {
                list.add(row);
            }
            return list.iterator();
        }
    }

    @Override
    public Iterator<DRow> getRowsAllColumns(Tenant tenant, String storeName, Collection<String> rowKeys) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public Iterator<DRow> getRowsColumns(Tenant tenant, String storeName, Collection<String> rowKeys, Collection<String> colNames) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public Iterator<DRow> getRowsColumnSlice(Tenant tenant, String storeName, Collection<String> rowKeys, String startCol, String endCol) {
        throw new RuntimeException("Not supported");
    }

    public static /* bridge */ /* synthetic */ DBService instance() {
        return MemoryService.instance();
    }

    public static class Keyspace {
        public String name;
        public Map<String, Store> stores = new HashMap<String, Store>();

        public Keyspace(String name) {
            this.name = name;
        }
    }

    public static class Row
    implements DRow {
        public String name;
        public SortedMap<String, byte[]> columns = new TreeMap<String, byte[]>();

        public Row(String name) {
            this.name = name;
        }

        @Override
        public String getKey() {
            return this.name;
        }

        @Override
        public Iterator<DColumn> getColumns() {
            ArrayList<DColumn> result = new ArrayList<DColumn>();
            for (Map.Entry<String, byte[]> e : this.columns.entrySet()) {
                result.add(new DColumn(e.getKey(), e.getValue()));
            }
            return result.iterator();
        }
    }

    public static class Store {
        public String name;
        public Map<String, Row> rows = new HashMap<String, Row>();

        public Store(String name) {
            this.name = name;
        }
    }
}

