/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.db.fs;

import com.dell.doradus.core.ServerConfig;
import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.service.db.DBService;
import com.dell.doradus.service.db.DBTransaction;
import com.dell.doradus.service.db.DColumn;
import com.dell.doradus.service.db.DRow;
import com.dell.doradus.service.db.Tenant;
import com.dell.doradus.service.db.fs.Database;
import com.dell.doradus.service.db.fs.FsColumn;
import com.dell.doradus.service.db.fs.FsKeyspace;
import com.dell.doradus.service.db.fs.FsRow;
import com.dell.doradus.service.db.fs.FsStorage;
import com.dell.doradus.service.db.fs.FsStore;
import com.dell.doradus.service.db.fs.FsTransaction;
import com.dell.doradus.service.db.fs.RowIter;
import com.dell.doradus.service.tenant.UserDefinition;
import com.dell.doradus.utilities.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsService
extends DBService {
    protected final Logger m_logger = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
    private static final FsService INSTANCE = new FsService();
    private final Object m_sync = new Object();
    private static final BSTR EMPTY = new BSTR(new byte[0]);
    private FsStorage m_storage = new FsStorage();
    private Database m_database;

    private FsService() {
    }

    public static FsService instance() {
        return INSTANCE;
    }

    @Override
    public void initService() {
        ServerConfig config = ServerConfig.getInstance();
        this.m_logger.info("Using FS API");
        this.m_logger.debug("Default application keyspace: {}", (Object)config.keyspace);
    }

    @Override
    public void startService() {
        this.m_database = new Database("c:/temp/doradus.dat");
        Timer t = new Timer();
        while (!this.m_database.isEnd()) {
            int flag = this.m_database.readNextFlag();
            BSTR keyspace = this.m_database.readNext();
            BSTR store = this.m_database.readNext();
            BSTR row = this.m_database.readNext();
            BSTR column = this.m_database.readNext();
            if (flag == 1) {
                long offset = this.m_database.position();
                BSTR value = this.m_database.readNext();
                this.m_storage.add(keyspace, store, row, column, value, offset);
                continue;
            }
            if (flag != 2) continue;
            this.m_storage.delete(keyspace, store, row, column);
        }
        this.m_logger.info("Database loaded in {}", (Object)t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(String dbfile) {
        Database db = new Database(dbfile);
        Object object = this.m_sync;
        synchronized (object) {
            for (FsKeyspace keyspace : this.m_storage.getKeyspaces()) {
                for (FsStore store : keyspace.getStores()) {
                    for (FsRow row : store.getRows()) {
                        for (FsColumn column : row.getColumns()) {
                            BSTR value = null;
                            value = column.hasValue() ? column.getValue() : this.m_database.read(column.getStoredOffset());
                            db.writeFlag(1);
                            db.write(keyspace.getName());
                            db.write(store.getName());
                            db.write(row.getName());
                            db.write(column.getName());
                            db.write(value);
                        }
                    }
                }
            }
        }
        db.flush();
        db.close();
    }

    @Override
    public void stopService() {
        this.m_database.close();
        this.m_database = null;
        this.m_database = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(BSTR keyspace, BSTR store, BSTR row, BSTR column, BSTR value) {
        Object object = this.m_sync;
        synchronized (object) {
            this.m_database.writeFlag(1);
            this.m_database.write(keyspace);
            this.m_database.write(store);
            this.m_database.write(row);
            this.m_database.write(column);
            long offset = this.m_database.length();
            this.m_database.write(value);
            this.m_database.flush();
            this.m_storage.add(keyspace, store, row, column, value, offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete(BSTR keyspace, BSTR store, BSTR row, BSTR column) {
        Object object = this.m_sync;
        synchronized (object) {
            this.m_database.writeFlag(2);
            this.m_database.write(keyspace);
            this.m_database.write(store);
            this.m_database.write(row);
            this.m_database.write(column);
            this.m_storage.delete(keyspace, store, row, column);
            this.m_database.flush();
        }
    }

    @Override
    public void createTenant(Tenant tenant, Map<String, String> options) {
        BSTR keyspace = new BSTR(tenant.getKeyspace());
        this.add(keyspace, EMPTY, EMPTY, EMPTY, EMPTY);
    }

    @Override
    public void modifyTenant(Tenant tenant, Map<String, String> options) {
    }

    @Override
    public void dropTenant(Tenant tenant) {
        BSTR keyspace = new BSTR(tenant.getKeyspace());
        this.delete(keyspace, EMPTY, EMPTY, EMPTY);
    }

    @Override
    public void addUsers(Tenant tenant, Iterable<UserDefinition> users) {
        throw new RuntimeException("This method is not supported for the Memory API");
    }

    @Override
    public void modifyUsers(Tenant tenant, Iterable<UserDefinition> users) {
        throw new RuntimeException("This method is not supported for the Memory API");
    }

    @Override
    public void deleteUsers(Tenant tenant, Iterable<UserDefinition> users) {
        throw new RuntimeException("This method is not supported for the Memory API");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Tenant> getTenants() {
        ArrayList<Tenant> tenants = new ArrayList<Tenant>();
        Object object = this.m_sync;
        synchronized (object) {
            for (FsKeyspace keyspace : this.m_storage.getKeyspaces()) {
                tenants.add(new Tenant(keyspace.getName().toString()));
            }
        }
        return tenants;
    }

    @Override
    public void createStoreIfAbsent(Tenant tenant, String storeName, boolean bBinaryValues) {
        BSTR keyspace = new BSTR(tenant.getKeyspace());
        BSTR store = new BSTR(storeName);
        this.add(keyspace, store, EMPTY, EMPTY, EMPTY);
    }

    @Override
    public void deleteStoreIfPresent(Tenant tenant, String storeName) {
        BSTR keyspace = new BSTR(tenant.getKeyspace());
        BSTR store = new BSTR(storeName);
        this.delete(keyspace, store, EMPTY, EMPTY);
    }

    @Override
    public DBTransaction startTransaction(Tenant tenant) {
        return new FsTransaction(tenant.getKeyspace());
    }

    @Override
    public void commit(DBTransaction dbTran) {
        List<Object> columns;
        BSTR row;
        Map<String, List<Object>> rows;
        BSTR store;
        FsTransaction t = (FsTransaction)dbTran;
        BSTR keyspace = new BSTR(t.getKeyspace());
        for (Map.Entry<String, Map<String, List<DColumn>>> entry : t.getUpdateMap().entrySet()) {
            store = new BSTR(entry.getKey());
            rows = entry.getValue();
            for (Map.Entry<String, List<DColumn>> entry2 : rows.entrySet()) {
                row = new BSTR(entry2.getKey());
                columns = entry2.getValue();
                for (Object c : columns) {
                    BSTR column = new BSTR(((DColumn)c).getName());
                    BSTR value = new BSTR(((DColumn)c).getRawValue());
                    this.add(keyspace, store, row, column, value);
                }
            }
        }
        for (Map.Entry<String, Map<String, List<Object>>> entry : t.getDeleteMap().entrySet()) {
            store = new BSTR(entry.getKey());
            rows = entry.getValue();
            for (Map.Entry<String, List<Object>> entry3 : rows.entrySet()) {
                row = new BSTR(entry3.getKey());
                columns = entry3.getValue();
                if (columns == null) {
                    this.delete(keyspace, store, row, EMPTY);
                    continue;
                }
                for (Object c : columns) {
                    BSTR value = new BSTR((String)c);
                    this.delete(keyspace, store, row, value);
                }
            }
        }
    }

    @Override
    public Iterator<DColumn> getAllColumns(Tenant tenant, String storeName, String rowKey) {
        return this.getColumnSlice(tenant, storeName, rowKey, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<DColumn> getColumnSlice(Tenant tenant, String storeName, String rowKey, String startCol, String endCol, boolean reversed) {
        if (reversed) {
            throw new RuntimeException("Not supported");
        }
        Object object = this.m_sync;
        synchronized (object) {
            BSTR s_keyspace = new BSTR(tenant.getKeyspace());
            BSTR s_store = new BSTR(storeName);
            BSTR s_row = new BSTR(rowKey);
            FsKeyspace keyspace = this.m_storage.getKeyspace(s_keyspace);
            if (keyspace == null) {
                return new ArrayList(0).iterator();
            }
            FsStore store = keyspace.getStore(s_store);
            if (store == null) {
                return new ArrayList(0).iterator();
            }
            FsRow row = store.getRow(s_row);
            if (row == null) {
                return new ArrayList(0).iterator();
            }
            List<FsColumn> columns = row.getColumns();
            ArrayList<DColumn> result = new ArrayList<DColumn>();
            BSTR start = startCol == null ? null : new BSTR(startCol);
            BSTR end = endCol == null ? null : new BSTR(endCol);
            for (FsColumn column : columns) {
                if (start != null && BSTR.compare(start, column.getName()) > 0) continue;
                if (end != null && BSTR.compare(end, column.getName()) <= 0) break;
                if (column.hasValue()) {
                    result.add(new DColumn(column.getName().toString(), column.getValue().buffer));
                    continue;
                }
                BSTR value = this.m_database.read(column.getStoredOffset());
                result.add(new DColumn(column.getName().toString(), value.buffer));
            }
            return result.iterator();
        }
    }

    @Override
    public Iterator<DColumn> getColumnSlice(Tenant tenant, String storeName, String rowKey, String startCol, String endCol) {
        return this.getColumnSlice(tenant, storeName, rowKey, startCol, endCol, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DColumn getColumn(Tenant tenant, String storeName, String rowKey, String colName) {
        Object object = this.m_sync;
        synchronized (object) {
            FsColumn column;
            block11: {
                FsRow row;
                BSTR s_column;
                block10: {
                    FsStore store;
                    BSTR s_row;
                    block9: {
                        FsKeyspace keyspace;
                        BSTR s_store;
                        block8: {
                            BSTR s_keyspace = new BSTR(tenant.getKeyspace());
                            s_store = new BSTR(storeName);
                            s_row = new BSTR(rowKey);
                            s_column = new BSTR(colName);
                            keyspace = this.m_storage.getKeyspace(s_keyspace);
                            if (keyspace != null) break block8;
                            return null;
                        }
                        store = keyspace.getStore(s_store);
                        if (store != null) break block9;
                        return null;
                    }
                    row = store.getRow(s_row);
                    if (row != null) break block10;
                    return null;
                }
                column = row.getColumn(s_column);
                if (column != null) break block11;
                return null;
            }
            if (column.hasValue()) {
                return new DColumn(column.getName().toString(), column.getValue().buffer);
            }
            BSTR value = this.m_database.read(column.getStoredOffset());
            return new DColumn(column.getName().toString(), value.buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<DRow> getAllRowsAllColumns(Tenant tenant, String storeName) {
        Object object = this.m_sync;
        synchronized (object) {
            BSTR s_keyspace = new BSTR(tenant.getKeyspace());
            BSTR s_store = new BSTR(storeName);
            FsKeyspace keyspace = this.m_storage.getKeyspace(s_keyspace);
            if (keyspace == null) {
                return new ArrayList(0).iterator();
            }
            FsStore store = keyspace.getStore(s_store);
            if (store == null) {
                return new ArrayList(0).iterator();
            }
            List<FsRow> rows = store.getRows();
            ArrayList<RowIter> result = new ArrayList<RowIter>();
            for (FsRow row : rows) {
                List<FsColumn> columns = row.getColumns();
                ArrayList<DColumn> r = new ArrayList<DColumn>();
                for (FsColumn column : columns) {
                    if (column.hasValue()) {
                        r.add(new DColumn(column.getName().toString(), column.getValue().buffer));
                        continue;
                    }
                    BSTR value = this.m_database.read(column.getStoredOffset());
                    r.add(new DColumn(column.getName().toString(), value.buffer));
                }
                result.add(new RowIter(row.getName().toString(), r));
            }
            return result.iterator();
        }
    }

    @Override
    public Iterator<DRow> getRowsAllColumns(Tenant tenant, String storeName, Collection<String> rowKeys) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public Iterator<DRow> getRowsColumns(Tenant tenant, String storeName, Collection<String> rowKeys, Collection<String> colNames) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public Iterator<DRow> getRowsColumnSlice(Tenant tenant, String storeName, Collection<String> rowKeys, String startCol, String endCol) {
        throw new RuntimeException("Not supported");
    }

    public static /* bridge */ /* synthetic */ DBService instance() {
        return FsService.instance();
    }
}

