/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.db.fs;

import com.dell.doradus.olap.io.BSTR;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

public class FOutputStream {
    static final int CHUNK_SIZE = 512;
    private SeekableByteChannel m_channel;
    private byte[] m_buffer;
    private int m_positionInBuffer;
    private long m_length;

    public FOutputStream(SeekableByteChannel channel) {
        this.m_channel = channel;
        this.m_buffer = new byte[512];
        try {
            this.m_length = this.m_channel.size();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeBuffer() {
        try {
            this.m_length = this.m_channel.size();
            this.m_channel.position(this.m_length);
            ByteBuffer bb = ByteBuffer.wrap(this.m_buffer, 0, this.m_positionInBuffer);
            this.m_channel.write(bb);
            this.m_length += (long)this.m_positionInBuffer;
            this.m_positionInBuffer = 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void flush() {
        this.writeBuffer();
    }

    public long length() {
        return this.m_length + (long)this.m_positionInBuffer;
    }

    public void writeByte(byte value) {
        this.m_buffer[this.m_positionInBuffer++] = value;
        if (this.m_positionInBuffer == this.m_buffer.length) {
            this.writeBuffer();
        }
    }

    public void write(byte[] buffer, int offset, int count) {
        while (count > 0) {
            int toCopy = Math.min(this.m_buffer.length - this.m_positionInBuffer, count);
            System.arraycopy(buffer, offset, this.m_buffer, this.m_positionInBuffer, toCopy);
            this.m_positionInBuffer += toCopy;
            count -= toCopy;
            offset += toCopy;
            if (this.m_positionInBuffer != this.m_buffer.length) continue;
            this.writeBuffer();
        }
    }

    public void writeVInt(int value) {
        int u = value >>> 7;
        while (u != 0) {
            this.writeByte((byte)(value & 0x7F | 0x80));
            value = u;
            u >>>= 7;
        }
        this.writeByte((byte)value);
    }

    public void writeVLong(long value) {
        long u = value >>> 7;
        while (u != 0L) {
            this.writeByte((byte)(value & 0x7FL | 0x80L));
            value = u;
            u >>>= 7;
        }
        this.writeByte((byte)value);
    }

    public void writeShort(short value) {
        short u = value;
        this.writeByte((byte)u);
        u = (short)(u >>> 8);
        this.writeByte((byte)u);
    }

    public void writeInt(int value) {
        int u = value;
        this.writeByte((byte)u);
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
    }

    public void writeLong(long value) {
        long u = value;
        this.writeByte((byte)u);
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
        this.writeByte((byte)(u >>>= 8));
        u >>>= 8;
    }

    public void write(BSTR bstr) {
        this.writeVInt(bstr.length);
        this.write(bstr.buffer, 0, bstr.length);
    }
}

