/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.db.fs;

import com.dell.doradus.olap.io.BSTR;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

public class FInputStream {
    static final int CHUNK_SIZE = 512;
    private SeekableByteChannel m_channel;
    private byte[] m_buffer;
    private long m_length;
    private long m_bufferOffset;
    private int m_bufferLength;
    private int m_positionInBuffer;
    private ByteBuffer m_temp;

    public FInputStream(SeekableByteChannel channel) {
        this.m_channel = channel;
        this.m_bufferOffset = 0L;
        this.m_buffer = new byte[512];
        this.m_temp = ByteBuffer.wrap(this.m_buffer);
        this.refresh();
    }

    public void refresh() {
        try {
            this.m_length = this.m_channel.size();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long length() {
        return this.m_length;
    }

    public long position() {
        return this.m_bufferOffset + (long)this.m_positionInBuffer;
    }

    public boolean isEnd() {
        return this.length() == this.position();
    }

    public void seek(long position) {
        if (position >= this.m_bufferOffset && position <= this.m_bufferOffset + (long)this.m_bufferLength) {
            this.m_positionInBuffer = (int)(position - this.m_bufferOffset);
        } else {
            this.readBuffer(position);
        }
    }

    private void readBuffer(long position) {
        try {
            this.m_channel.position(position);
            this.m_positionInBuffer = 0;
            this.m_temp.clear();
            this.m_bufferLength = this.m_channel.read(this.m_temp);
            this.m_bufferOffset = position;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int read(byte[] buffer, int offset, int count) {
        int cnt = count;
        while (count > 0) {
            if (this.m_positionInBuffer == this.m_bufferLength) {
                this.readBuffer(this.m_bufferOffset + (long)this.m_bufferLength);
            }
            int toRead = Math.min(this.m_bufferLength - this.m_positionInBuffer, count);
            System.arraycopy(this.m_buffer, this.m_positionInBuffer, buffer, offset, toRead);
            count -= toRead;
            this.m_positionInBuffer += toRead;
            offset += toRead;
        }
        return cnt;
    }

    public int readByte() {
        if (this.m_positionInBuffer == this.m_bufferLength) {
            this.readBuffer(this.m_bufferOffset + (long)this.m_bufferLength);
        }
        return this.m_buffer[this.m_positionInBuffer++] & 0xFF;
    }

    public int readVInt() {
        int b = this.readByte();
        int u = b & 0x7F;
        int shift = 7;
        while (b > 127) {
            b = this.readByte();
            u += (b & 0x7F) << shift;
            shift += 7;
        }
        return u;
    }

    public long readVLong() {
        long b = this.readByte();
        long u = b & 0x7FL;
        int shift = 7;
        while (b > 127L) {
            b = this.readByte();
            u += (b & 0x7FL) << shift;
            shift += 7;
        }
        return u;
    }

    public short readShort() {
        int u = this.readByte() | this.readByte() << 8;
        return (short)u;
    }

    public int readInt() {
        int u = this.readByte() | this.readByte() << 8 | this.readByte() << 16 | this.readByte() << 24;
        return u;
    }

    public long readLong() {
        long u = (long)this.readByte() | (long)this.readByte() << 8 | (long)this.readByte() << 16 | (long)this.readByte() << 24 | (long)this.readByte() << 32 | (long)this.readByte() << 40 | (long)this.readByte() << 48 | (long)this.readByte() << 56;
        return u;
    }

    public BSTR readBSTR() {
        int length = this.readVInt();
        byte[] buffer = new byte[length];
        this.read(buffer, 0, length);
        return new BSTR(buffer);
    }
}

