/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.db.fs;

import com.dell.doradus.olap.io.BSTR;
import com.dell.doradus.service.db.fs.FInputStream;
import com.dell.doradus.service.db.fs.FOutputStream;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;

public class Database {
    private SeekableByteChannel m_channel;
    private FInputStream m_input;
    private FOutputStream m_output;

    public Database(String fileName) {
        try {
            HashSet<StandardOpenOption> options = new HashSet<StandardOpenOption>();
            options.add(StandardOpenOption.CREATE);
            options.add(StandardOpenOption.READ);
            options.add(StandardOpenOption.WRITE);
            this.m_channel = Files.newByteChannel(Paths.get(fileName, new String[0]), options, new FileAttribute[0]);
            this.m_input = new FInputStream(this.m_channel);
            this.m_output = new FOutputStream(this.m_channel);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.m_channel.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long position() {
        return this.m_input.position();
    }

    public long length() {
        return this.m_output.length();
    }

    public BSTR read(long position) {
        this.m_input.seek(position);
        BSTR value = this.m_input.readBSTR();
        return value;
    }

    public int readNextFlag() {
        return this.m_input.readVInt();
    }

    public BSTR readNext() {
        BSTR value = this.m_input.readBSTR();
        return value;
    }

    public void writeFlag(int flag) {
        this.m_output.writeVInt(flag);
    }

    public void write(BSTR value) {
        this.m_output.write(value);
    }

    public void flush() {
        this.m_output.flush();
        this.m_input.refresh();
    }

    public boolean isEnd() {
        return this.m_input.isEnd();
    }
}

