/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.db.cql;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.dell.doradus.common.Utils;
import com.dell.doradus.core.ServerConfig;
import com.dell.doradus.service.db.DBTransaction;
import com.dell.doradus.service.db.DColumn;
import com.dell.doradus.service.db.Tenant;
import com.dell.doradus.service.db.cql.CQLService;
import com.dell.doradus.service.db.cql.CQLStatementCache;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CQLTransaction
extends DBTransaction {
    private final Map<String, Map<String, List<DColumn>>> m_updateMap = new HashMap<String, Map<String, List<DColumn>>>();
    private final Map<String, Map<String, List<String>>> m_deleteMap = new HashMap<String, Map<String, List<String>>>();
    private final String m_keyspace;
    private final Session m_session;
    private int m_updates;
    private long m_timestamp;

    public CQLTransaction(Tenant tenant) {
        this.m_keyspace = CQLService.storeToCQLName(tenant.getKeyspace());
        this.m_session = CQLService.instance().getSession(this.m_keyspace);
    }

    @Override
    public void clear() {
        this.m_updateMap.clear();
        this.m_deleteMap.clear();
        this.m_updates = 0;
    }

    @Override
    public int getUpdateCount() {
        return this.m_updates;
    }

    @Override
    public void addColumn(String storeName, String rowKey, String colName) {
        this.addColumn(storeName, rowKey, colName, "");
    }

    @Override
    public void addColumn(String storeName, String rowKey, String colName, String colValue) {
        String tableName = CQLService.storeToCQLName(storeName);
        List<DColumn> colList = this.getUpdateColList(tableName, rowKey);
        colList.add(new DColumn(colName, colValue));
        ++this.m_updates;
    }

    @Override
    public void addColumn(String storeName, String rowKey, String colName, byte[] colValue) {
        String tableName = CQLService.storeToCQLName(storeName);
        List<DColumn> colList = this.getUpdateColList(tableName, rowKey);
        colList.add(new DColumn(colName, colValue));
        ++this.m_updates;
    }

    @Override
    public void addColumn(String storeName, String rowKey, String colName, long colValue) {
        this.addColumn(storeName, rowKey, colName, Long.toString(colValue));
    }

    @Override
    public void deleteRow(String storeName, String rowKey) {
        String tableName = CQLService.storeToCQLName(storeName);
        Map<String, List<String>> rowKeyMap = this.getDeleteColMap(tableName);
        rowKeyMap.put(rowKey, null);
        ++this.m_updates;
    }

    @Override
    public void deleteColumn(String storeName, String rowKey, String colName) {
        String tableName = CQLService.storeToCQLName(storeName);
        Map<String, List<String>> rowKeyMap = this.getDeleteColMap(tableName);
        List<String> colList = null;
        if (rowKeyMap.containsKey(rowKey) && (colList = rowKeyMap.get(rowKey)) == null) {
            this.m_logger.warn("deleteColumn() called for row being deleted; ignored. table={}, row={}, column={}", new Object[]{tableName, rowKey, colName});
            return;
        }
        if (colList == null) {
            colList = new ArrayList<String>();
            rowKeyMap.put(rowKey, colList);
        }
        colList.add(colName);
        ++this.m_updates;
    }

    @Override
    public void deleteColumns(String storeName, String rowKey, Collection<String> colNames) {
        String tableName = CQLService.storeToCQLName(storeName);
        Map<String, List<String>> rowKeyMap = this.getDeleteColMap(tableName);
        List<String> colList = null;
        if (rowKeyMap.containsKey(rowKey) && (colList = rowKeyMap.get(rowKey)) == null) {
            this.m_logger.warn("deleteColumns() called for row being deleted; ignored. table={}, row={}, # of columns={}", new Object[]{tableName, rowKey, colNames.size()});
            return;
        }
        if (colList == null) {
            colList = new ArrayList<String>();
            rowKeyMap.put(rowKey, colList);
        }
        colList.addAll(colNames);
        this.m_updates += colNames.size();
    }

    public void commit() {
        try {
            try {
                this.m_timestamp = Utils.getTimeMicros();
                this.applyUpdates();
            }
            catch (Exception e) {
                this.m_logger.error("Updates failed", (Throwable)e);
                throw e;
            }
        }
        finally {
            this.clear();
        }
    }

    private List<DColumn> getUpdateColList(String tableName, String rowKey) {
        List<DColumn> colList;
        Map<String, List<DColumn>> rowMap = this.m_updateMap.get(tableName);
        if (rowMap == null) {
            rowMap = new HashMap<String, List<DColumn>>();
            this.m_updateMap.put(tableName, rowMap);
        }
        if ((colList = rowMap.get(rowKey)) == null) {
            colList = new ArrayList<DColumn>(1000);
            rowMap.put(rowKey, colList);
        }
        return colList;
    }

    private Map<String, List<String>> getDeleteColMap(String tableName) {
        Map<String, List<String>> rowMap = this.m_deleteMap.get(tableName);
        if (rowMap == null) {
            rowMap = new HashMap<String, List<String>>(1000);
            this.m_deleteMap.put(tableName, rowMap);
        }
        return rowMap;
    }

    private void applyUpdates() {
        if (this.getUpdateCount() == 0) {
            this.m_logger.debug("Skipping commit with no updates");
        } else if (ServerConfig.getInstance().async_updates) {
            this.executeUpdatesAsynchronous();
        } else {
            this.executeUpdatesSynchronous();
        }
    }

    private void executeUpdatesAsynchronous() {
        ArrayList<ResultSetFuture> futureList = new ArrayList<ResultSetFuture>(1000);
        this.executeTableUpdatesAsynchronously(futureList);
        this.executeTableDeletesAsynchronously(futureList);
        this.m_logger.debug("Waiting for {} asynchronous futures", (Object)futureList.size());
        for (ResultSetFuture future : futureList) {
            future.getUninterruptibly();
        }
    }

    private void executeTableUpdatesAsynchronously(List<ResultSetFuture> futureList) {
        for (String tableName : this.m_updateMap.keySet()) {
            this.executeTableUpdatesAsynchronous(tableName, futureList);
        }
    }

    private void executeTableUpdatesAsynchronous(String tableName, List<ResultSetFuture> futureList) {
        boolean bBinary = CQLService.instance().columnValueIsBinary(this.m_keyspace, tableName);
        PreparedStatement prepState = CQLService.instance().getPreparedUpdate(this.m_keyspace, CQLStatementCache.Update.INSERT_ROW_TS, tableName);
        Map<String, List<DColumn>> rowMap = this.m_updateMap.get(tableName);
        for (String key : rowMap.keySet()) {
            BatchStatement batchState = new BatchStatement(BatchStatement.Type.UNLOGGED);
            for (DColumn column : rowMap.get(key)) {
                BoundStatement boundState = prepState.bind();
                boundState.setString(0, key);
                boundState.setString(1, column.getName());
                if (bBinary) {
                    boundState.setBytes(2, ByteBuffer.wrap(column.getRawValue()));
                } else {
                    boundState.setString(2, column.getValue());
                }
                boundState.setLong(3, this.m_timestamp);
                batchState.add((Statement)boundState);
            }
            futureList.add(this.m_session.executeAsync((Statement)batchState));
        }
    }

    private void executeTableDeletesAsynchronously(List<ResultSetFuture> futureList) {
        for (String tableName : this.m_deleteMap.keySet()) {
            this.executeTableDeleteAsynchronous(tableName, futureList);
        }
    }

    private void executeTableDeleteAsynchronous(String tableName, List<ResultSetFuture> futureList) {
        Map<String, List<String>> rowKeyMap = this.m_deleteMap.get(tableName);
        PreparedStatement deleteColPrepState = CQLService.instance().getPreparedUpdate(this.m_keyspace, CQLStatementCache.Update.DELETE_COLUMN_TS, tableName);
        PreparedStatement deleteRowPrepState = CQLService.instance().getPreparedUpdate(this.m_keyspace, CQLStatementCache.Update.DELETE_ROW_TS, tableName);
        for (String key : rowKeyMap.keySet()) {
            List<String> colList = rowKeyMap.get(key);
            if (colList != null && colList.size() > 0) {
                this.executeTableDeleteColumnsAsynchronous(key, colList, deleteColPrepState, futureList);
                continue;
            }
            this.executeTableRowDeleteAsynchronously(key, deleteRowPrepState, futureList);
        }
    }

    private void executeTableDeleteColumnsAsynchronous(String key, List<String> colList, PreparedStatement deleteColPrepState, List<ResultSetFuture> futureList) {
        BatchStatement batchState = new BatchStatement(BatchStatement.Type.UNLOGGED);
        for (String colName : colList) {
            BoundStatement boundState = deleteColPrepState.bind();
            boundState.setLong(0, this.m_timestamp);
            boundState.setString(1, key);
            boundState.setString(2, colName);
            batchState.add((Statement)boundState);
        }
        futureList.add(this.m_session.executeAsync((Statement)batchState));
    }

    private void executeTableRowDeleteAsynchronously(String key, PreparedStatement deleteRowPrepState, List<ResultSetFuture> futureList) {
        BoundStatement boundState = deleteRowPrepState.bind();
        boundState.setLong(0, this.m_timestamp);
        boundState.setString(1, key);
        futureList.add(this.m_session.executeAsync((Statement)boundState));
    }

    private void executeUpdatesSynchronous() {
        BatchStatement batchState = new BatchStatement(BatchStatement.Type.UNLOGGED);
        this.addUpdates(batchState);
        this.addDeletes(batchState);
        this.executeBatch(batchState);
    }

    private void addUpdates(BatchStatement batchState) {
        for (String tableName : this.m_updateMap.keySet()) {
            this.addTableUpdates(tableName, batchState);
        }
    }

    private void addTableUpdates(String tableName, BatchStatement batchState) {
        boolean valueIsBinary = CQLService.instance().columnValueIsBinary(this.m_keyspace, tableName);
        PreparedStatement prepState = CQLService.instance().getPreparedUpdate(this.m_keyspace, CQLStatementCache.Update.INSERT_ROW, tableName);
        Map<String, List<DColumn>> rowMap = this.m_updateMap.get(tableName);
        for (String key : rowMap.keySet()) {
            List<DColumn> colList = rowMap.get(key);
            for (DColumn column : colList) {
                batchState.add((Statement)this.addColumnUpdate(prepState, valueIsBinary, key, column));
            }
        }
    }

    private BoundStatement addColumnUpdate(PreparedStatement prepState, boolean valueIsBinary, String key, DColumn column) {
        BoundStatement boundState = prepState.bind();
        boundState.setString(0, key);
        boundState.setString(1, column.getName());
        if (valueIsBinary) {
            boundState.setBytes(2, ByteBuffer.wrap(column.getRawValue()));
        } else {
            boundState.setString(2, column.getValue());
        }
        return boundState;
    }

    private void addDeletes(BatchStatement batchState) {
        for (String tableName : this.m_deleteMap.keySet()) {
            this.addTableDelete(batchState, tableName);
        }
    }

    private void addTableDelete(BatchStatement batchState, String tableName) {
        Map<String, List<String>> rowKeyMap = this.m_deleteMap.get(tableName);
        for (String key : rowKeyMap.keySet()) {
            PreparedStatement prepState;
            List<String> colList = rowKeyMap.get(key);
            if (colList != null && colList.size() > 0) {
                prepState = CQLService.instance().getPreparedUpdate(this.m_keyspace, CQLStatementCache.Update.DELETE_COLUMN, tableName);
                for (String colName : colList) {
                    batchState.add((Statement)this.addColumnDelete(prepState, key, colName));
                }
                continue;
            }
            prepState = CQLService.instance().getPreparedUpdate(this.m_keyspace, CQLStatementCache.Update.DELETE_ROW, tableName);
            batchState.add((Statement)this.addRowDelete(prepState, key));
        }
    }

    private BoundStatement addColumnDelete(PreparedStatement prepState, String key, String colName) {
        BoundStatement boundState = prepState.bind();
        boundState.setString(0, key);
        boundState.setString(1, colName);
        return boundState;
    }

    private BoundStatement addRowDelete(PreparedStatement prepState, String key) {
        BoundStatement boundState = prepState.bind();
        boundState.setString(0, key);
        return boundState;
    }

    private void executeBatch(BatchStatement batchState) {
        if (batchState.size() > 0) {
            this.m_logger.debug("Executing synchronous batch with {} statements", (Object)batchState.size());
            this.m_session.execute((Statement)batchState);
        }
    }
}

