/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.db.cql;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CQLStatementCache {
    private final Logger m_logger = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
    private final Map<String, Map<Query, PreparedStatement>> m_prepQueryMap = new HashMap<String, Map<Query, PreparedStatement>>();
    private final Map<String, Map<Update, PreparedStatement>> m_prepUpdateMap = new HashMap<String, Map<Update, PreparedStatement>>();
    private final Session m_session;

    public CQLStatementCache(Session session) {
        this.m_session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement getPreparedQuery(Query query, String tableName) {
        Map<String, Map<Query, PreparedStatement>> map = this.m_prepQueryMap;
        synchronized (map) {
            PreparedStatement prepState;
            Map<Query, PreparedStatement> tableMap = this.m_prepQueryMap.get(tableName);
            if (tableMap == null) {
                tableMap = new HashMap<Query, PreparedStatement>();
                this.m_prepQueryMap.put(tableName, tableMap);
            }
            if ((prepState = tableMap.get((Object)query)) == null) {
                prepState = this.prepareQuery(query, tableName);
                tableMap.put(query, prepState);
            }
            return prepState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement getPreparedUpdate(Update update, String tableName) {
        Map<String, Map<Update, PreparedStatement>> map = this.m_prepUpdateMap;
        synchronized (map) {
            PreparedStatement prepState;
            Map<Update, PreparedStatement> tableMap = this.m_prepUpdateMap.get(tableName);
            if (tableMap == null) {
                tableMap = new HashMap<Update, PreparedStatement>();
                this.m_prepUpdateMap.put(tableName, tableMap);
            }
            if ((prepState = tableMap.get((Object)update)) == null) {
                prepState = this.prepareUpdate(update, tableName);
                tableMap.put(update, prepState);
            }
            return prepState;
        }
    }

    private PreparedStatement prepareQuery(Query query, String tableName) {
        StringBuilder cql = new StringBuilder("SELECT * FROM ");
        cql.append(tableName);
        switch (query) {
            case SELECT_1_ROW_1_COLUMN: {
                cql.append(" WHERE key= ? AND column1 = ?;");
                break;
            }
            case SELECT_1_ROW_COLUMN_RANGE: {
                cql.append(" WHERE key= ? AND column1 >= ? AND column1 <= ?;");
                break;
            }
            case SELECT_1_ROW_COLUMN_RANGE_DESC: {
                cql.append(" WHERE key= ? AND column1 >= ? AND column1 <= ? ORDER BY column1 DESC;");
                break;
            }
            case SELECT_1_ROW_ALL_COLUMNS: {
                cql.append(" WHERE key= ?;");
                break;
            }
            case SELECT_ROW_SET_COLUMN_SET: {
                cql.append(" WHERE key IN ? AND column1 IN ?;");
                break;
            }
            case SELECT_ROW_SET_COLUMN_RANGE: {
                cql.append(" WHERE key IN ? AND column1 >= ? AND column1 <= ?");
                break;
            }
            case SELECT_ROW_SET_COLUMN_RANGE_DESC: {
                cql.append(" WHERE key IN ? AND column1 >= ? AND column1 <= ? ORDER BY column1 DESC");
                break;
            }
            case SELECT_ROW_SET_ALL_COLUMNS: {
                cql.append(" WHERE key IN ?;");
                break;
            }
            case SELECT_ALL_ROWS_ALL_COLUMNS: {
                cql.append(" LIMIT ");
                cql.append(Integer.MAX_VALUE);
                cql.append(" ALLOW FILTERING;");
            }
        }
        this.m_logger.debug("Preparing query statement: {}", (Object)cql);
        return this.m_session.prepare(cql.toString());
    }

    private PreparedStatement prepareUpdate(Update update, String tableName) {
        StringBuilder cql = new StringBuilder();
        switch (update) {
            case INSERT_ROW: {
                cql.append("INSERT INTO ");
                cql.append(tableName);
                cql.append(" (key,column1,value) VALUES (?, ?, ?);");
                break;
            }
            case INSERT_ROW_TS: {
                cql.append("INSERT INTO ");
                cql.append(tableName);
                cql.append(" (key,column1,value) VALUES (?, ?, ?) USING TIMESTAMP ?;");
                break;
            }
            case DELETE_COLUMN: {
                cql.append("DELETE FROM ");
                cql.append(tableName);
                cql.append(" WHERE key=? AND column1=?;");
                break;
            }
            case DELETE_COLUMN_TS: {
                cql.append("DELETE FROM ");
                cql.append(tableName);
                cql.append(" USING TIMESTAMP ? WHERE key=? AND column1=?;");
                break;
            }
            case DELETE_ROW: {
                cql.append("DELETE FROM ");
                cql.append(tableName);
                cql.append(" WHERE key=?;");
                break;
            }
            case DELETE_ROW_TS: {
                cql.append("DELETE FROM ");
                cql.append(tableName);
                cql.append(" USING TIMESTAMP ? WHERE key=?;");
            }
        }
        this.m_logger.debug("Preparing update statement: {}", (Object)cql);
        return this.m_session.prepare(cql.toString());
    }

    public static enum Query {
        SELECT_1_ROW_1_COLUMN,
        SELECT_1_ROW_COLUMN_RANGE,
        SELECT_1_ROW_COLUMN_RANGE_DESC,
        SELECT_1_ROW_ALL_COLUMNS,
        SELECT_ROW_SET_COLUMN_SET,
        SELECT_ROW_SET_COLUMN_RANGE,
        SELECT_ROW_SET_COLUMN_RANGE_DESC,
        SELECT_ROW_SET_ALL_COLUMNS,
        SELECT_ALL_ROWS_ALL_COLUMNS;

    }

    public static enum Update {
        INSERT_ROW,
        INSERT_ROW_TS,
        DELETE_COLUMN,
        DELETE_COLUMN_TS,
        DELETE_ROW,
        DELETE_ROW_TS;

    }
}

