/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.db.cql;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import com.dell.doradus.common.Utils;
import com.dell.doradus.core.ServerConfig;
import com.dell.doradus.service.db.DBService;
import com.dell.doradus.service.db.DBTransaction;
import com.dell.doradus.service.db.DColumn;
import com.dell.doradus.service.db.DRow;
import com.dell.doradus.service.db.Tenant;
import com.dell.doradus.service.db.cql.CQLColumnIterator;
import com.dell.doradus.service.db.cql.CQLRowIterator;
import com.dell.doradus.service.db.cql.CQLSchemaManager;
import com.dell.doradus.service.db.cql.CQLStatementCache;
import com.dell.doradus.service.db.cql.CQLTransaction;
import com.dell.doradus.service.tenant.UserDefinition;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class CQLService
extends DBService {
    private static final String APPS_CQL_NAME = "\"Applications\"";
    private static final CQLService INSTANCE = new CQLService();
    private Cluster m_cluster;
    private static final String NO_KS_SESSION = "_";
    private final Map<String, Session> m_ksSessionMap = new HashMap<String, Session>();
    private final Map<String, CQLStatementCache> m_ksStatementCacheMap = new HashMap<String, CQLStatementCache>();

    private CQLService() {
    }

    public static CQLService instance() {
        return INSTANCE;
    }

    @Override
    protected void initService() {
        ServerConfig config = ServerConfig.getInstance();
        this.m_logger.info("Using CQL API");
        this.m_logger.debug("Cassandra host list: {}", (Object)Arrays.toString(config.dbhost.split(",")));
        this.m_logger.debug("Cassandra port: {}", (Object)config.dbport);
        this.m_logger.debug("Default application keyspace: {}", (Object)config.keyspace);
    }

    @Override
    protected void startService() {
        this.initializeCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stopService() {
        Map<String, Session> map = this.m_ksSessionMap;
        synchronized (map) {
            for (Session session : this.m_ksSessionMap.values()) {
                session.close();
            }
            this.m_ksSessionMap.clear();
            this.m_ksStatementCacheMap.clear();
        }
    }

    @Override
    public void createTenant(Tenant tenant, Map<String, String> options) {
        this.checkState();
        String cqlKeyspace = CQLService.storeToCQLName(tenant.getKeyspace());
        KeyspaceMetadata ksMetadata = this.m_cluster.getMetadata().getKeyspace(cqlKeyspace);
        if (ksMetadata == null) {
            Session session = this.getOrCreateKeyspaceSession(NO_KS_SESSION);
            CQLSchemaManager schemaMgr = new CQLSchemaManager(session, null);
            schemaMgr.createKeyspace(cqlKeyspace, options);
        }
    }

    @Override
    public void modifyTenant(Tenant tenant, Map<String, String> options) {
        String cqlKeyspace = CQLService.storeToCQLName(tenant.getKeyspace());
        KeyspaceMetadata ksMetadata = this.m_cluster.getMetadata().getKeyspace(cqlKeyspace);
        Utils.require((ksMetadata != null ? 1 : 0) != 0, (String)("Tenant not found: " + tenant.toString()));
        Session session = this.getOrCreateKeyspaceSession(NO_KS_SESSION);
        CQLSchemaManager schemaMgr = new CQLSchemaManager(session, null);
        schemaMgr.modifyKeyspace(cqlKeyspace, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropTenant(Tenant tenant) {
        this.checkState();
        String cqlKeyspace = CQLService.storeToCQLName(tenant.getKeyspace());
        Map<String, Session> map = this.m_ksSessionMap;
        synchronized (map) {
            Session session = this.m_ksSessionMap.get(cqlKeyspace);
            if (session != null) {
                session.close();
                this.m_ksSessionMap.remove(cqlKeyspace);
                this.m_ksStatementCacheMap.remove(cqlKeyspace);
            }
            Session noKSSession = this.getOrCreateKeyspaceSession(NO_KS_SESSION);
            CQLSchemaManager schemaMgr = new CQLSchemaManager(noKSSession, null);
            schemaMgr.dropKeyspace(cqlKeyspace);
        }
    }

    @Override
    public void addUsers(Tenant tenant, Iterable<UserDefinition> users) {
        this.checkState();
        String cqlKeyspace = CQLService.storeToCQLName(tenant.getKeyspace());
        Session session = this.getOrCreateKeyspaceSession(cqlKeyspace);
        StringBuilder cql = new StringBuilder();
        for (UserDefinition userDef : users) {
            String userID = userDef.getID();
            String password = userDef.getPassword();
            this.m_logger.debug("Adding new user '{}' for keyspace {}", (Object)userID, (Object)cqlKeyspace);
            cql.setLength(0);
            cql.append("CREATE USER ");
            cql.append(userID);
            cql.append(" WITH PASSWORD '");
            cql.append(password);
            cql.append("' NOSUPERUSER;");
            try {
                session.execute(cql.toString());
            }
            catch (InvalidQueryException e) {
                String errMsg = e.getLocalizedMessage();
                if (errMsg.contains("already exists")) {
                    this.m_logger.warn("User {} already exists; skipping permission assignment", (Object)userID);
                    continue;
                }
                throw new RuntimeException("Error creating user: " + userID, e);
            }
            cql.setLength(0);
            cql.append("GRANT ALL PERMISSIONS ON KEYSPACE ");
            cql.append(cqlKeyspace);
            cql.append(" TO ");
            cql.append(userID);
            cql.append(";");
            session.execute(cql.toString());
        }
    }

    @Override
    public void modifyUsers(Tenant tenant, Iterable<UserDefinition> users) {
        this.checkState();
        String cqlKeyspace = CQLService.storeToCQLName(tenant.getKeyspace());
        Session session = this.getOrCreateKeyspaceSession(cqlKeyspace);
        StringBuilder cql = new StringBuilder();
        for (UserDefinition userDef : users) {
            String userID = userDef.getID();
            String password = userDef.getPassword();
            this.m_logger.debug("Modifying password for user '{}' for keyspace {}", (Object)userID, (Object)cqlKeyspace);
            cql.setLength(0);
            cql.append("ALTER USER ");
            cql.append(userID);
            cql.append(" WITH PASSWORD '");
            cql.append(password);
            cql.append("';");
            try {
                session.execute(cql.toString());
            }
            catch (InvalidQueryException e) {
                this.m_logger.warn("Error modifying user '" + userID + "'; skipping this user", (Object)userID);
            }
        }
    }

    @Override
    public void deleteUsers(Tenant tenant, Iterable<UserDefinition> users) {
        this.checkState();
        Session session = this.getOrCreateKeyspaceSession(NO_KS_SESSION);
        StringBuilder cql = new StringBuilder();
        for (UserDefinition userDef : users) {
            String userID = userDef.getID();
            this.m_logger.debug("Dropping user '{}'", (Object)userID);
            cql.setLength(0);
            cql.append("DROP USER ");
            cql.append(userID);
            cql.append(";");
            try {
                session.execute(cql.toString());
            }
            catch (InvalidQueryException e) {
                this.m_logger.warn("Cannot drop user '" + userID + "'; ignoring", (Throwable)e);
            }
        }
    }

    @Override
    public Collection<Tenant> getTenants() {
        this.checkState();
        ArrayList<Tenant> tenants = new ArrayList<Tenant>();
        List keyspaceList = this.m_cluster.getMetadata().getKeyspaces();
        for (KeyspaceMetadata ksMetadata : keyspaceList) {
            if (ksMetadata.getTable(APPS_CQL_NAME) == null) continue;
            tenants.add(new Tenant(ksMetadata.getName()));
        }
        return tenants;
    }

    @Override
    public void createStoreIfAbsent(Tenant tenant, String storeName, boolean bBinaryValues) {
        this.checkState();
        String cqlKeyspace = CQLService.storeToCQLName(tenant.getKeyspace());
        String tableName = CQLService.storeToCQLName(storeName);
        if (!this.storeExists(cqlKeyspace, tableName)) {
            Session session = this.getOrCreateKeyspaceSession(cqlKeyspace);
            CQLSchemaManager schemaMgr = new CQLSchemaManager(session, cqlKeyspace);
            schemaMgr.createCQLTable(storeName, bBinaryValues);
        }
    }

    @Override
    public void deleteStoreIfPresent(Tenant tenant, String storeName) {
        this.checkState();
        String cqlKeyspace = CQLService.storeToCQLName(tenant.getKeyspace());
        String tableName = CQLService.storeToCQLName(storeName);
        if (this.storeExists(cqlKeyspace, tableName)) {
            Session session = this.getOrCreateKeyspaceSession(cqlKeyspace);
            CQLSchemaManager schemaMgr = new CQLSchemaManager(session, cqlKeyspace);
            schemaMgr.dropCQLTable(tableName);
        }
    }

    public boolean columnValueIsBinary(String keyspace, String storeName) {
        String cqlKeyspace = CQLService.storeToCQLName(keyspace);
        String tableName = CQLService.storeToCQLName(storeName);
        KeyspaceMetadata ksMetadata = this.m_cluster.getMetadata().getKeyspace(cqlKeyspace);
        TableMetadata tableMetadata = ksMetadata.getTable(tableName);
        ColumnMetadata colMetadata = tableMetadata.getColumn("value");
        return colMetadata.getType().equals(DataType.blob());
    }

    @Override
    public DBTransaction startTransaction(Tenant tenant) {
        this.checkState();
        return new CQLTransaction(tenant);
    }

    @Override
    public void commit(DBTransaction dbTran) {
        this.checkState();
        ((CQLTransaction)dbTran).commit();
    }

    @Override
    public Iterator<DColumn> getAllColumns(Tenant tenant, String storeName, String rowKey) {
        this.checkState();
        String keyspace = CQLService.storeToCQLName(tenant.getKeyspace());
        String tableName = CQLService.storeToCQLName(storeName);
        return new CQLColumnIterator(this.executeQuery(CQLStatementCache.Query.SELECT_1_ROW_ALL_COLUMNS, keyspace, tableName, rowKey));
    }

    @Override
    public Iterator<DColumn> getColumnSlice(Tenant tenant, String storeName, String rowKey, String startCol, String endCol, boolean reversed) {
        this.checkState();
        String keyspace = CQLService.storeToCQLName(tenant.getKeyspace());
        String tableName = CQLService.storeToCQLName(storeName);
        ResultSet rs = null;
        rs = reversed ? this.executeQuery(CQLStatementCache.Query.SELECT_1_ROW_COLUMN_RANGE_DESC, keyspace, tableName, rowKey, endCol, startCol) : this.executeQuery(CQLStatementCache.Query.SELECT_1_ROW_COLUMN_RANGE, keyspace, tableName, rowKey, startCol, endCol);
        return new CQLColumnIterator(rs);
    }

    @Override
    public Iterator<DColumn> getColumnSlice(Tenant tenant, String storeName, String rowKey, String startCol, String endCol) {
        this.checkState();
        String keyspace = CQLService.storeToCQLName(tenant.getKeyspace());
        String tableName = CQLService.storeToCQLName(storeName);
        return new CQLColumnIterator(this.executeQuery(CQLStatementCache.Query.SELECT_1_ROW_COLUMN_RANGE, keyspace, tableName, rowKey, startCol, endCol));
    }

    @Override
    public Iterator<DRow> getAllRowsAllColumns(Tenant tenant, String storeName) {
        this.checkState();
        String keyspace = CQLService.storeToCQLName(tenant.getKeyspace());
        String tableName = CQLService.storeToCQLName(storeName);
        return new CQLRowIterator(this.executeQuery(CQLStatementCache.Query.SELECT_ALL_ROWS_ALL_COLUMNS, keyspace, tableName, new Object[0]));
    }

    @Override
    public DColumn getColumn(Tenant tenant, String storeName, String rowKey, String colName) {
        this.checkState();
        String keyspace = CQLService.storeToCQLName(tenant.getKeyspace());
        String tableName = CQLService.storeToCQLName(storeName);
        CQLColumnIterator colIter = new CQLColumnIterator(this.executeQuery(CQLStatementCache.Query.SELECT_1_ROW_1_COLUMN, keyspace, tableName, rowKey, colName));
        if (!colIter.hasNext()) {
            return null;
        }
        return colIter.next();
    }

    @Override
    public Iterator<DRow> getRowsAllColumns(Tenant tenant, String storeName, Collection<String> rowKeys) {
        this.checkState();
        String keyspace = CQLService.storeToCQLName(tenant.getKeyspace());
        String tableName = CQLService.storeToCQLName(storeName);
        return new CQLRowIterator(this.executeQuery(CQLStatementCache.Query.SELECT_ROW_SET_ALL_COLUMNS, keyspace, tableName, new ArrayList<String>(rowKeys)));
    }

    @Override
    public Iterator<DRow> getRowsColumns(Tenant tenant, String storeName, Collection<String> rowKeys, Collection<String> colNames) {
        this.checkState();
        String keyspace = CQLService.storeToCQLName(tenant.getKeyspace());
        String tableName = CQLService.storeToCQLName(storeName);
        return new CQLRowIterator(this.executeQuery(CQLStatementCache.Query.SELECT_ROW_SET_COLUMN_SET, keyspace, tableName, new ArrayList<String>(rowKeys), new ArrayList<String>(colNames)));
    }

    @Override
    public Iterator<DRow> getRowsColumnSlice(Tenant tenant, String storeName, Collection<String> rowKeys, String startCol, String endCol) {
        this.checkState();
        String keyspace = CQLService.storeToCQLName(tenant.getKeyspace());
        String tableName = CQLService.storeToCQLName(storeName);
        return new CQLRowIterator(this.executeQuery(CQLStatementCache.Query.SELECT_ROW_SET_COLUMN_RANGE, keyspace, tableName, new ArrayList<String>(rowKeys), startCol, endCol));
    }

    public PreparedStatement getPreparedQuery(String keyspace, CQLStatementCache.Query query, String storeName) {
        String cqlKeysapce = CQLService.storeToCQLName(keyspace);
        String tableName = CQLService.storeToCQLName(storeName);
        CQLStatementCache statementCache = this.m_ksStatementCacheMap.get(cqlKeysapce);
        assert (statementCache != null);
        return statementCache.getPreparedQuery(query, tableName);
    }

    public PreparedStatement getPreparedUpdate(String keyspace, CQLStatementCache.Update update, String storeName) {
        String cqlKeyspace = CQLService.storeToCQLName(keyspace);
        String tableName = CQLService.storeToCQLName(storeName);
        CQLStatementCache statementCache = this.m_ksStatementCacheMap.get(cqlKeyspace);
        assert (statementCache != null);
        return statementCache.getPreparedUpdate(update, tableName);
    }

    public Session getSession(String keyspace) {
        String cqlKeyspace = CQLService.storeToCQLName(keyspace);
        return this.getOrCreateKeyspaceSession(cqlKeyspace);
    }

    public static String storeToCQLName(String storeName) {
        if (storeName.charAt(0) == '\"') {
            return storeName;
        }
        return "\"" + storeName + "\"";
    }

    private boolean storeExists(String cqlKeyspace, String tableName) {
        assert (cqlKeyspace.charAt(0) == '\"');
        KeyspaceMetadata ksMetadata = this.m_cluster.getMetadata().getKeyspace(cqlKeyspace);
        return ksMetadata != null && ksMetadata.getTable(tableName) != null;
    }

    private ResultSet executeQuery(CQLStatementCache.Query query, String cqlKeyspace, String tableName, Object ... values) {
        assert (cqlKeyspace.charAt(0) == '\"');
        this.m_logger.debug("Executing statement {} on table {}/{}; total params={}", new Object[]{query, cqlKeyspace, tableName, values.length});
        Session session = this.getOrCreateKeyspaceSession(cqlKeyspace);
        PreparedStatement prepState = this.getPreparedQuery(cqlKeyspace, query, tableName);
        BoundStatement boundState = prepState.bind(values);
        return session.execute((Statement)boundState);
    }

    private void initializeCluster() {
        while (true) {
            try {
                this.m_cluster = this.buildClusterSpecs();
                this.connectToCluster();
            }
            catch (Exception e) {
                this.m_cluster = null;
                this.m_logger.info("Database is not reachable: {}. Waiting to retry", (Throwable)e);
                try {
                    Thread.sleep(ServerConfig.getInstance().db_connect_retry_wait_millis);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
    }

    private Cluster buildClusterSpecs() {
        String[] nodeAddresses;
        ServerConfig config = ServerConfig.getInstance();
        Cluster.Builder builder = Cluster.builder();
        for (String address : nodeAddresses = config.dbhost.split(",")) {
            builder.addContactPoint(address);
        }
        builder.withPort(ServerConfig.getInstance().dbport);
        SocketOptions socketOpts = new SocketOptions();
        socketOpts.setReadTimeoutMillis(config.db_timeout_millis);
        socketOpts.setConnectTimeoutMillis(config.db_connect_retry_wait_millis);
        builder.withSocketOptions(socketOpts);
        if (!Utils.isEmpty((String)config.dbuser)) {
            builder.withCredentials(config.dbuser, config.dbpassword);
        }
        builder.withCompression(ProtocolOptions.Compression.SNAPPY);
        if (config.dbtls) {
            builder.withSSL(this.getSSLOptions());
        }
        return builder.build();
    }

    private SSLOptions getSSLOptions() {
        ServerConfig config = ServerConfig.getInstance();
        SSLContext sslContext = null;
        try {
            sslContext = this.getSSLContext(config.truststore, config.truststorepassword, config.keystore, config.keystorepassword);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to build SSLContext", e);
        }
        List<String> cipherSuites = config.dbtls_cipher_suites;
        if (cipherSuites == null) {
            cipherSuites = new ArrayList<String>();
        }
        return new SSLOptions(sslContext, cipherSuites.toArray(new String[0]));
    }

    private SSLContext getSSLContext(String truststorePath, String truststorePassword, String keystorePath, String keystorePassword) throws Exception {
        FileInputStream tsf = new FileInputStream(truststorePath);
        KeyStore ts = KeyStore.getInstance("JKS");
        ts.load(tsf, truststorePassword.toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ts);
        FileInputStream ksf = new FileInputStream(keystorePath);
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(ksf, keystorePassword.toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, keystorePassword.toCharArray());
        SSLContext ctx = SSLContext.getInstance("SSL");
        ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
        return ctx;
    }

    private void connectToCluster() {
        assert (this.m_cluster != null);
        this.m_cluster.init();
        this.displayClusterInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session getOrCreateKeyspaceSession(String cqlKeyspace) {
        assert (cqlKeyspace.charAt(0) == '\"' || cqlKeyspace.equals(NO_KS_SESSION));
        Session session = this.m_ksSessionMap.get(cqlKeyspace);
        if (session == null) {
            Map<String, Session> map = this.m_ksSessionMap;
            synchronized (map) {
                session = this.m_ksSessionMap.get(cqlKeyspace);
                if (session == null) {
                    session = cqlKeyspace.equals(NO_KS_SESSION) ? this.m_cluster.connect() : this.m_cluster.connect(cqlKeyspace);
                    this.m_ksSessionMap.put(cqlKeyspace, session);
                    this.m_ksStatementCacheMap.put(cqlKeyspace, new CQLStatementCache(session));
                }
            }
        }
        return session;
    }

    private void displayClusterInfo() {
        Metadata metadata = this.m_cluster.getMetadata();
        this.m_logger.info("Connected to cluster with topography:");
        RoundRobinPolicy policy = new RoundRobinPolicy();
        for (Host host : metadata.getAllHosts()) {
            this.m_logger.info("   Host {}: datacenter: {}, rack: {}, distance: {}", new Object[]{host.getAddress(), host.getDatacenter(), host.getRack(), policy.distance(host)});
        }
        this.m_logger.info("Database contains {} keyspaces", (Object)metadata.getKeyspaces().size());
    }
}

