/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.db.cql;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.dell.doradus.core.ServerConfig;
import com.dell.doradus.service.db.cql.CQLService;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CQLSchemaManager {
    private final Logger m_logger = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
    private final Session m_session;
    private final String m_keyspace;

    public CQLSchemaManager(Session session, String keyspace) {
        this.m_session = session;
        this.m_keyspace = keyspace;
    }

    public void createKeyspace(String keyspace, Map<String, String> options) {
        String cqlKeyspace = CQLService.storeToCQLName(keyspace);
        this.m_logger.info("Creating new keyspace: {}", (Object)cqlKeyspace);
        StringBuilder cql = new StringBuilder();
        cql.append("CREATE KEYSPACE ");
        cql.append(cqlKeyspace);
        cql.append(CQLSchemaManager.keyspaceDefaultsToCQLString(options));
        cql.append(";");
        this.m_session.execute(cql.toString());
    }

    public void modifyKeyspace(String keyspace, Map<String, String> options) {
        if (!options.containsKey("ReplicationFactor")) {
            return;
        }
        String cqlKeyspace = CQLService.storeToCQLName(keyspace);
        this.m_logger.info("Modifying keyspace: {}", (Object)cqlKeyspace);
        StringBuilder cql = new StringBuilder();
        cql.append("ALTER KEYSPACE ");
        cql.append(cqlKeyspace);
        cql.append(" WITH REPLICATION = {'class':'");
        String strategyClass = "SimpleStrategy";
        Map<String, Object> ksDefs = ServerConfig.getInstance().ks_defaults;
        if (ksDefs != null && ksDefs.containsKey("strategy_class")) {
            strategyClass = ksDefs.get("strategy_class").toString();
        }
        cql.append(strategyClass);
        cql.append("','replication_factor':");
        cql.append(options.get("ReplicationFactor"));
        cql.append("};");
        this.m_session.execute(cql.toString());
    }

    public void dropKeyspace(String keyspace) {
        String cqlKeyspace = CQLService.storeToCQLName(keyspace);
        this.m_logger.info("Dropping keyspace: {}", (Object)cqlKeyspace);
        StringBuilder cql = new StringBuilder();
        cql.append("DROP KEYSPACE ");
        cql.append(cqlKeyspace);
        cql.append(";");
        this.m_session.execute(cql.toString());
    }

    public void createCQLTable(String storeName, boolean bBinaryValues) {
        String tableName = CQLService.storeToCQLName(storeName);
        this.m_logger.info("Creating CQL table {}", (Object)tableName);
        StringBuffer cql = new StringBuffer();
        cql.append("CREATE TABLE ");
        cql.append(tableName);
        cql.append("(key text,column1 text,value ");
        if (bBinaryValues) {
            cql.append("blob,");
        } else {
            cql.append("text,");
        }
        cql.append("PRIMARY KEY(key,column1)) WITH COMPACT STORAGE ");
        cql.append(this.tablePropertiesToCQLString(storeName));
        cql.append(";");
        this.executeCQL(cql.toString());
    }

    public void dropCQLTable(String templateName) {
        String tableName = CQLService.storeToCQLName(templateName);
        this.m_logger.info("Dropping table: {}", (Object)tableName);
        String cql = "DROP TABLE " + tableName + ";";
        this.executeCQL(cql);
    }

    public boolean tableExists(String tableName) {
        return this.m_session.getCluster().getMetadata().getKeyspace(this.m_keyspace).getTable(tableName) != null;
    }

    private String tablePropertiesToCQLString(String storeName) {
        Map<String, Object> cfOptions;
        StringBuilder buffer = new StringBuilder();
        Map<String, Object> map = cfOptions = storeName.startsWith("OLAP") ? ServerConfig.getInstance().olap_cf_defaults : ServerConfig.getInstance().cf_defaults;
        if (cfOptions != null) {
            for (String optName : cfOptions.keySet()) {
                buffer.append(" AND ");
                if (optName.equals("compression_options")) {
                    buffer.append("compression");
                } else {
                    buffer.append(optName);
                }
                buffer.append("=");
                Object optValue = cfOptions.get(optName);
                if (optValue instanceof Map) {
                    buffer.append(CQLSchemaManager.mapToCQLString((Map)optValue));
                    continue;
                }
                buffer.append(optValue.toString());
            }
        }
        return buffer.toString();
    }

    private static String keyspaceDefaultsToCQLString(Map<String, String> options) {
        boolean durable_writes = true;
        HashMap<String, Object> replication = new HashMap<String, Object>();
        replication.put("class", "SimpleStrategy");
        replication.put("replication_factor", "1");
        Map<String, Object> ksDefs = ServerConfig.getInstance().ks_defaults;
        if (ksDefs != null) {
            Map replOpts;
            Object value;
            if (ksDefs.containsKey("durable_writes")) {
                durable_writes = Boolean.parseBoolean(ksDefs.get("durable_writes").toString());
            }
            if (ksDefs.containsKey("strategy_class")) {
                replication.put("class", ksDefs.get("strategy_class").toString());
            }
            if (ksDefs.containsKey("strategy_options") && (value = ksDefs.get("strategy_options")) instanceof Map && (replOpts = (Map)value).containsKey("replication_factor")) {
                replication.put("replication_factor", replOpts.get("replication_factor").toString());
            }
        }
        if (options != null && options.containsKey("ReplicationFactor")) {
            replication.put("replication_factor", options.get("ReplicationFactor"));
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(" WITH DURABLE_WRITES=");
        buffer.append(durable_writes);
        buffer.append(" AND REPLICATION=");
        buffer.append(CQLSchemaManager.mapToCQLString(replication));
        return buffer.toString();
    }

    private static String mapToCQLString(Map<String, Object> valueMap) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        boolean bFirst = true;
        for (String name : valueMap.keySet()) {
            if (bFirst) {
                bFirst = false;
            } else {
                buffer.append(",");
            }
            buffer.append("'");
            buffer.append(name);
            buffer.append("':");
            Object value = valueMap.get(name);
            if (value instanceof String) {
                buffer.append("'");
                buffer.append(value.toString());
                buffer.append("'");
                continue;
            }
            buffer.append(value.toString());
        }
        buffer.append("}");
        return buffer.toString();
    }

    private ResultSet executeCQL(String cql) {
        this.m_logger.trace("Executing CQL: {}", (Object)cql);
        try {
            return this.m_session.execute(cql);
        }
        catch (Exception e) {
            this.m_logger.error("CQL query failed", (Throwable)e);
            this.m_logger.info("   Query={}", (Object)cql);
            throw e;
        }
    }
}

