/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.db.cql;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.dell.doradus.common.Utils;
import com.dell.doradus.service.db.DColumn;
import com.dell.doradus.service.db.DRow;
import com.dell.doradus.service.db.cql.CQLRow;
import java.util.ArrayList;
import java.util.Iterator;

public class CQLRowIterator
implements Iterator<DRow> {
    private final ResultSet m_rs;
    private Row m_nextRow;
    private boolean m_bValueIsBinary;

    public CQLRowIterator(ResultSet rs) {
        this.m_rs = rs;
        this.m_nextRow = rs.one();
        this.setColumnValueType();
    }

    @Override
    public boolean hasNext() {
        return this.m_nextRow != null;
    }

    @Override
    public DRow next() {
        Utils.require((this.m_nextRow != null ? 1 : 0) != 0, (String)"No more rows");
        ArrayList<DColumn> columnList = new ArrayList<DColumn>();
        String key = this.m_nextRow.getString("key");
        do {
            if (this.m_bValueIsBinary) {
                columnList.add(new DColumn(this.m_nextRow.getString("column1"), this.m_nextRow.getBytes("value")));
            } else {
                columnList.add(new DColumn(this.m_nextRow.getString("column1"), this.m_nextRow.getString("value")));
            }
            this.m_nextRow = this.m_rs.one();
        } while (this.m_nextRow != null && this.m_nextRow.getString("key").equals(key));
        return new CQLRow(key, columnList.iterator());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void setColumnValueType() {
        if (this.m_nextRow != null) {
            ColumnDefinitions colDefs = this.m_nextRow.getColumnDefinitions();
            DataType dataType = colDefs.getType("value");
            this.m_bValueIsBinary = dataType.equals(DataType.blob());
        }
    }
}

