/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.db.cql;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.dell.doradus.common.Utils;
import com.dell.doradus.service.db.DColumn;
import java.util.Iterator;

public class CQLColumnIterator
implements Iterator<DColumn> {
    private final ResultSet m_rs;
    private Row m_nextRow;
    private final String m_key;
    private boolean m_bValueIsBinary;

    public CQLColumnIterator(ResultSet rs) {
        this.m_rs = rs;
        this.m_nextRow = rs.one();
        this.m_key = this.m_nextRow == null ? "" : this.m_nextRow.getString("key");
        this.setColumnValueType();
    }

    @Override
    public boolean hasNext() {
        return this.m_nextRow != null;
    }

    @Override
    public DColumn next() {
        Utils.require((this.m_nextRow != null ? 1 : 0) != 0, (String)"No more columns to return");
        DColumn cqlCol = null;
        cqlCol = this.m_bValueIsBinary ? new DColumn(this.m_nextRow.getString("column1"), this.m_nextRow.getBytes("value")) : new DColumn(this.m_nextRow.getString("column1"), this.m_nextRow.getString("value"));
        this.m_nextRow = this.m_rs.one();
        if (this.m_nextRow != null && !this.m_key.equals(this.m_nextRow.getString("key"))) {
            this.m_nextRow = null;
        }
        return cqlCol;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void setColumnValueType() {
        if (this.m_nextRow != null) {
            ColumnDefinitions colDefs = this.m_nextRow.getColumnDefinitions();
            DataType dataType = colDefs.getType("value");
            this.m_bValueIsBinary = dataType.equals(DataType.blob());
        }
    }
}

