/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.db;

import com.dell.doradus.common.ApplicationDefinition;
import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.common.Utils;

public class Tenant
implements Comparable<Tenant> {
    private final String m_keyspace;

    public static Tenant getTenant(ApplicationDefinition appDef) {
        String tenantName = appDef.getOption("Tenant");
        Utils.require((!Utils.isEmpty((String)tenantName) ? 1 : 0) != 0, (String)("Application definition is missing 'Tenant' option: " + appDef));
        return new Tenant(tenantName);
    }

    public static Tenant getTenant(TableDefinition tableDef) {
        return Tenant.getTenant(tableDef.getAppDef());
    }

    public Tenant(String keyspace) {
        this.m_keyspace = keyspace;
    }

    public String getKeyspace() {
        return this.m_keyspace;
    }

    @Override
    public int compareTo(Tenant o) {
        return this.m_keyspace.compareTo(o.m_keyspace);
    }

    public int hashCode() {
        return this.m_keyspace.hashCode();
    }

    public String toString() {
        return this.m_keyspace;
    }
}

