/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service.db;

import com.dell.doradus.core.ServerConfig;
import com.dell.doradus.service.Service;
import com.dell.doradus.service.db.DBNotAvailableException;
import com.dell.doradus.service.db.DBTransaction;
import com.dell.doradus.service.db.DColumn;
import com.dell.doradus.service.db.DRow;
import com.dell.doradus.service.db.Tenant;
import com.dell.doradus.service.db.cql.CQLService;
import com.dell.doradus.service.db.thrift.ThriftService;
import com.dell.doradus.service.tenant.UserDefinition;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public abstract class DBService
extends Service {
    private static final DBService INSTANCE = ServerConfig.getInstance().use_cql ? CQLService.instance() : ThriftService.instance();

    protected DBService() {
        this.m_startDelayMillis = 1000;
    }

    public static DBService instance() {
        return INSTANCE;
    }

    public abstract void createTenant(Tenant var1, Map<String, String> var2);

    public abstract void modifyTenant(Tenant var1, Map<String, String> var2);

    public abstract void dropTenant(Tenant var1);

    public abstract void addUsers(Tenant var1, Iterable<UserDefinition> var2);

    public abstract void modifyUsers(Tenant var1, Iterable<UserDefinition> var2);

    public abstract void deleteUsers(Tenant var1, Iterable<UserDefinition> var2);

    public abstract Collection<Tenant> getTenants();

    public abstract void createStoreIfAbsent(Tenant var1, String var2, boolean var3);

    public abstract void deleteStoreIfPresent(Tenant var1, String var2);

    public abstract DBTransaction startTransaction(Tenant var1);

    public abstract void commit(DBTransaction var1);

    public abstract Iterator<DColumn> getAllColumns(Tenant var1, String var2, String var3);

    public abstract Iterator<DColumn> getColumnSlice(Tenant var1, String var2, String var3, String var4, String var5, boolean var6);

    public abstract Iterator<DColumn> getColumnSlice(Tenant var1, String var2, String var3, String var4, String var5);

    public abstract Iterator<DRow> getAllRowsAllColumns(Tenant var1, String var2);

    public abstract DColumn getColumn(Tenant var1, String var2, String var3, String var4);

    public abstract Iterator<DRow> getRowsAllColumns(Tenant var1, String var2, Collection<String> var3);

    public abstract Iterator<DRow> getRowsColumns(Tenant var1, String var2, Collection<String> var3, Collection<String> var4);

    public abstract Iterator<DRow> getRowsColumnSlice(Tenant var1, String var2, Collection<String> var3, String var4, String var5);

    protected void checkState() {
        if (!this.getState().isRunning()) {
            throw new DBNotAvailableException("Cassandra connection has not been established");
        }
    }
}

