/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.service;

import com.dell.doradus.service.db.DBNotAvailableException;
import com.dell.doradus.service.db.DBService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Service {
    private State m_state = State.INACTIVE;
    private final Object m_runningLock = new Object();
    protected int m_startDelayMillis = 0;
    protected final Logger m_logger = LoggerFactory.getLogger((String)this.getClass().getSimpleName());

    public final State getState() {
        return this.m_state;
    }

    public final void initialize() {
        if (this.m_state.isInitialized()) {
            this.m_logger.warn("initialize(): Service is already initialized -- ignoring");
        } else {
            this.initService();
            this.setState(State.INITIALIZED);
        }
    }

    public final void start() {
        if (!this.m_state.isInitialized()) {
            this.m_logger.warn("start(): Service has not been initialized -- ignoring");
        } else if (!this.m_state.isStarted()) {
            AsyncServiceStarter startThread = new AsyncServiceStarter();
            startThread.start();
            if (this.m_startDelayMillis > 0) {
                try {
                    startThread.join(this.m_startDelayMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public final void stop() {
        if (!this.m_state.isStarted()) {
            this.m_logger.warn("stop(): Service has not been started -- ignoring");
        } else {
            this.setState(State.STOPPING);
            this.stopService();
            this.setState(State.INACTIVE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void waitForFullService() {
        if (!this.m_state.isInitialized()) {
            throw new RuntimeException("Service has not been initialized");
        }
        Object object = this.m_runningLock;
        synchronized (object) {
            while (true) {
                if (this.m_state.isRunning()) {
                    return;
                }
                try {
                    this.m_runningLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    protected abstract void initService();

    protected abstract void startService();

    protected abstract void stopService();

    protected void checkServiceState() {
        State dbServiceState = DBService.instance().getState();
        if (!dbServiceState.isInitialized()) {
            throw new RuntimeException("DBService has not been initialized");
        }
        if (!dbServiceState.isRunning()) {
            throw new DBNotAvailableException("Initial Cassandra connection hasn't been established");
        }
        this.waitForFullService();
    }

    private void setState(State newState) {
        this.m_logger.debug("Entering state: {}", (Object)newState.toString());
        this.m_state = newState;
    }

    private class AsyncServiceStarter
    extends Thread {
        private AsyncServiceStarter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Service.this.setState(State.STARTING);
                Service.this.startService();
                Object object = Service.this.m_runningLock;
                synchronized (object) {
                    Service.this.setState(State.RUNNING);
                    Service.this.m_logger.debug("Notifying waiters");
                    Service.this.m_runningLock.notifyAll();
                }
            }
            catch (Throwable e) {
                Service.this.m_logger.error("Fatal: Failed to enter running state", e);
                Service.this.m_logger.error("Stopping process");
                System.exit(1);
            }
        }
    }

    public static enum State {
        INACTIVE,
        INITIALIZED,
        STARTING,
        RUNNING,
        STOPPING;


        public boolean isInitialized() {
            return this.ordinal() >= INITIALIZED.ordinal();
        }

        public boolean isStarted() {
            return this.ordinal() >= STARTING.ordinal();
        }

        public boolean isRunning() {
            return this.ordinal() >= RUNNING.ordinal();
        }

        public boolean isStopping() {
            return this == RUNNING;
        }
    }
}

