/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LRUSizeCache<K, T> {
    private static Logger log = LoggerFactory.getLogger((String)"Cache");
    private LinkedHashMap<K, ValueAndSize<T>> m_map;
    private final int m_capacity;
    private final long m_totalSize;
    private long m_currentSize;

    public LRUSizeCache(int capacity, long totalSize) {
        this.m_map = new LinkedHashMap(capacity, 0.75f, true);
        this.m_capacity = capacity;
        this.m_totalSize = totalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(K key) {
        LRUSizeCache lRUSizeCache = this;
        synchronized (lRUSizeCache) {
            ValueAndSize<T> value;
            block4: {
                value = this.m_map.get(key);
                if (value != null) break block4;
                return null;
            }
            return value.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, T value, long size) {
        LRUSizeCache lRUSizeCache = this;
        synchronized (lRUSizeCache) {
            ValueAndSize<T> oldValue = this.m_map.get(key);
            if (oldValue != null) {
                oldValue.value = value;
                this.m_currentSize -= oldValue.size;
                this.m_currentSize += size;
                log.debug("Updating existing data in the cache: might be an error: {}, {}->{}", new Object[]{key, oldValue.size, size});
            } else {
                this.m_currentSize += size;
                this.m_map.put(key, new ValueAndSize<T>(value, size));
            }
            if (this.m_currentSize > this.m_totalSize) {
                if (this.m_map.size() <= this.m_capacity) {
                    log.debug("Cannot store capacity={} because the size limit is exceeded; currently: {}", (Object)this.m_capacity, (Object)this.m_map.size());
                }
                Iterator<Map.Entry<K, ValueAndSize<T>>> iterator = this.m_map.entrySet().iterator();
                while (iterator.hasNext()) {
                    if (this.m_currentSize < this.m_totalSize) break;
                    Map.Entry<K, ValueAndSize<T>> entry = iterator.next();
                    iterator.remove();
                    this.m_currentSize -= entry.getValue().size;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        LRUSizeCache lRUSizeCache = this;
        synchronized (lRUSizeCache) {
            return this.m_map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long storageSize() {
        LRUSizeCache lRUSizeCache = this;
        synchronized (lRUSizeCache) {
            return this.m_currentSize;
        }
    }

    public static class ValueAndSize<T> {
        public T value;
        public long size;

        public ValueAndSize(T value, long size) {
            this.value = value;
            this.size = size;
        }
    }
}

