/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.util;

import com.dell.doradus.search.util.HeapList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HeapSort<T>
implements Iterable<T> {
    private List<Iterable<T>> m_iterables = new ArrayList<Iterable<T>>();

    protected int compare(T x, T y) {
        return ((Comparable)x).compareTo(y);
    }

    public void add(Iterable<T> iterator) {
        this.m_iterables.add(iterator);
    }

    @Override
    public Iterator<T> iterator() {
        if (this.m_iterables.size() == 0) {
            return new ArrayList(0).iterator();
        }
        return new Iter();
    }

    public class Entry
    implements Comparable<Entry> {
        public T key;
        public int position;

        public Entry(int position) {
            this.position = position;
        }

        @Override
        public int compareTo(Entry other) {
            if (this.key == other.key) {
                return 0;
            }
            if (this.key == null) {
                return -1;
            }
            if (other.key == null) {
                return 1;
            }
            return HeapSort.this.compare(other.key, this.key);
        }
    }

    class Iter
    implements Iterator<T> {
        private List<Iterator<T>> m_iterators;
        private HeapList<Entry> m_heap;
        private Entry m_current;

        Iter() {
            this.m_iterators = new ArrayList(HeapSort.this.m_iterables.size());
            this.m_heap = new HeapList(HeapSort.this.m_iterables.size() - 1);
            int i = 0;
            while (i < HeapSort.this.m_iterables.size()) {
                Iterator iterator = ((Iterable)HeapSort.this.m_iterables.get(i)).iterator();
                this.m_iterators.add(iterator);
                this.m_current = new Entry(i);
                this.moveNext();
                ++i;
            }
        }

        private void moveNext() {
            Iterator iterator = this.m_iterators.get(this.m_current.position);
            this.m_current.key = iterator.hasNext() ? iterator.next() : null;
            this.m_current = this.m_heap.AddEx(this.m_current);
        }

        @Override
        public boolean hasNext() {
            return this.m_current.key != null;
        }

        @Override
        public T next() {
            Object key = this.m_current.key;
            this.moveNext();
            return key;
        }

        @Override
        public void remove() {
            throw new RuntimeException("remove not implemented");
        }
    }
}

