/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.util;

import com.dell.doradus.search.util.HeapList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HeapSet<T extends Comparable<T>> {
    private HeapList<T> m_heap;
    private Set<T> m_set;

    public HeapSet(int capacity) {
        this.m_heap = new HeapList(capacity);
        this.m_set = new HashSet<T>(capacity);
    }

    public int getCapacity() {
        return this.m_heap.getCapacity();
    }

    public void Put(T value) {
        if (!this.m_set.contains(value)) {
            Comparable old = (Comparable)this.m_heap.AddEx(value);
            if (old != null) {
                this.m_set.remove(old);
            }
            if (old != value) {
                this.m_set.add(value);
            }
        }
    }

    public List<T> GetValues() {
        ArrayList<T> list = new ArrayList<T>(this.m_set.size());
        list.addAll(this.m_set);
        Collections.sort(list);
        return list;
    }
}

