/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class HeapList<T> {
    private T[] m_Array;
    private int m_Count;
    private int m_Capacity;
    private Comparator<T> m_Comparator;
    private boolean m_bInverse;

    public HeapList(int capacity) {
        this(capacity, null);
    }

    public void setInverse(boolean inverse) {
        this.m_bInverse = inverse;
    }

    public HeapList(int capacity, Comparator<T> comparator) {
        this.m_Capacity = capacity;
        this.m_Array = new Object[this.m_Capacity + 1];
        this.m_Comparator = comparator;
    }

    protected boolean greaterThan(T v1, T v2) {
        boolean c;
        if (this.m_Comparator != null) {
            c = this.m_Comparator.compare(v1, v2) > 0;
        } else {
            boolean bl = c = ((Comparable)v1).compareTo(v2) > 0;
        }
        return this.m_bInverse ? !c : c;
    }

    public int getCount() {
        return this.m_Count;
    }

    public int getCapacity() {
        return this.m_Capacity;
    }

    public boolean Add(T value) {
        if (this.m_Count < this.m_Capacity) {
            this.m_Array[++this.m_Count] = value;
            this.UpHeap();
        } else if (this.greaterThan(this.m_Array[1], value)) {
            this.m_Array[1] = value;
            this.DownHeap();
        } else {
            return false;
        }
        return true;
    }

    public T AddEx(T value) {
        if (this.m_Count < this.m_Capacity) {
            this.m_Array[++this.m_Count] = value;
            this.UpHeap();
            return null;
        }
        if (this.m_Capacity == 0) {
            return value;
        }
        if (this.greaterThan(this.m_Array[1], value)) {
            T retVal = this.m_Array[1];
            this.m_Array[1] = value;
            this.DownHeap();
            return retVal;
        }
        return value;
    }

    public List<T> values() {
        ArrayList<T> array = new ArrayList<T>(this.m_Count);
        int i = 0;
        while (i < this.m_Count) {
            array.add(this.m_Array[i + 1]);
            ++i;
        }
        if (this.m_Comparator != null) {
            Collections.sort(array, this.m_Comparator);
        } else {
            Collections.sort(array, new Comparator<T>(){

                @Override
                public int compare(T x, T y) {
                    return ((Comparable)x).compareTo(y);
                }
            });
        }
        return array;
    }

    public T[] GetValues(Class<T> c) {
        Object[] array = (Object[])Array.newInstance(c, this.m_Count);
        int i = 0;
        while (i < this.m_Count) {
            array[i] = this.m_Array[i + 1];
            ++i;
        }
        if (this.m_Comparator != null) {
            Arrays.sort(array, this.m_Comparator);
        } else {
            Arrays.sort(array);
        }
        return array;
    }

    private void UpHeap() {
        int i = this.m_Count;
        T node = this.m_Array[i];
        int j = i >> 1;
        while (j > 0 && this.greaterThan(node, this.m_Array[j])) {
            this.m_Array[i] = this.m_Array[j];
            i = j;
            j = i >> 1;
        }
        this.m_Array[i] = node;
    }

    private void DownHeap() {
        int i = 1;
        T node = this.m_Array[i];
        int j = i << 1;
        int k = j + 1;
        if (k <= this.m_Count && this.greaterThan(this.m_Array[k], this.m_Array[j])) {
            j = k;
        }
        while (j <= this.m_Count && this.greaterThan(this.m_Array[j], node)) {
            this.m_Array[i] = this.m_Array[j];
            i = j;
            k = (j = i << 1) + 1;
            if (k > this.m_Count || !this.greaterThan(this.m_Array[k], this.m_Array[j])) continue;
            j = k;
        }
        this.m_Array[i] = node;
    }
}

