/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.rawquery;

import com.dell.doradus.search.rawquery.Encoder;
import com.dell.doradus.search.rawquery.RawPredicate;

public class RangePredicate
implements RawPredicate {
    public String min;
    public boolean minInclusive;
    public String max;
    public boolean maxInclusive;

    public RangePredicate() {
    }

    public RangePredicate(String min, boolean minInclusive, String max, boolean maxInclusive) {
        this.min = min;
        this.minInclusive = minInclusive;
        this.max = max;
        this.maxInclusive = maxInclusive;
    }

    public String toString() {
        if (this.min == null) {
            return String.valueOf(this.maxInclusive ? "<=" : "<") + Encoder.encode(this.max);
        }
        if (this.max == null) {
            return String.valueOf(this.minInclusive ? ">=" : ">") + Encoder.encode(this.min);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(":");
        sb.append(this.minInclusive ? (char)'[' : '{');
        sb.append(Encoder.encode(this.min));
        sb.append(" TO ");
        sb.append(Encoder.encode(this.max));
        sb.append(this.maxInclusive ? (char)']' : '}');
        return sb.toString();
    }
}

