/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.parser.grammar;

import com.dell.doradus.search.parser.grammar.Context;
import com.dell.doradus.search.parser.grammar.GrammarRule;
import com.dell.doradus.search.parser.grammar.Literal;

public class StringToken
implements GrammarRule {
    char delimeter;
    String name;

    @Override
    public String Name() {
        return this.name;
    }

    public StringToken(String name, char delimeter) {
        this.delimeter = delimeter;
        this.name = name;
    }

    @Override
    public Context Match(Context context) {
        int ptr = context.ptr;
        if (ptr >= context.inputString.length()) {
            return null;
        }
        if (context.inputString.charAt(ptr) != this.delimeter) {
            return null;
        }
        String value = StringToken.LiteralFromString(context, ptr + 1, this.delimeter);
        context.items.add(new Literal(value, "string", ptr));
        return context;
    }

    public static String IdentifierFromString(Context cntx, int pos, String starts, String middle) {
        String source = cntx.inputString;
        char c = source.charAt(pos);
        if (Character.isLetterOrDigit(c) || starts.indexOf(c) != -1) {
            int startPos = pos;
            int len = source.length();
            while (pos < len) {
                if (!Character.isLetterOrDigit(c = source.charAt(++pos)) && middle.indexOf(c) == -1) break;
            }
            cntx.ptr = pos;
            return source.substring(startPos, pos - 1);
        }
        return null;
    }

    public static String LiteralFromString(Context cntx, int pos, char delimeter) {
        String source = cntx.inputString;
        int len = source.length();
        StringBuilder builder = new StringBuilder();
        while (pos < len) {
            char c = source.charAt(pos);
            if (c == delimeter) {
                cntx.ptr = pos + 1;
                return builder.toString();
            }
            if (c == '\\') {
                if (++pos >= len) {
                    throw new IllegalArgumentException("Missing escape sequence");
                }
                switch (source.charAt(pos)) {
                    case '\'': {
                        c = '\'';
                        break;
                    }
                    case '\"': {
                        c = '\"';
                        break;
                    }
                    case '\\': {
                        c = '\\';
                        break;
                    }
                    case 'b': {
                        c = '\b';
                        break;
                    }
                    case 'f': {
                        c = '\f';
                        break;
                    }
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 'r': {
                        c = '\r';
                        break;
                    }
                    case 't': {
                        c = '\t';
                        break;
                    }
                    case 'u': {
                        if (++pos + 3 >= len) {
                            throw new IllegalArgumentException("Unrecognized escape sequence");
                        }
                        c = (char)Integer.parseInt(source.substring(pos, pos + 4), 16);
                        pos += 3;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unrecognized escape sequence");
                    }
                }
            }
            builder.append(c);
            ++pos;
        }
        throw new IllegalArgumentException("There is no closing character " + delimeter);
    }
}

