/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.parser.grammar;

import com.dell.doradus.search.parser.grammar.CharacterRule;
import com.dell.doradus.search.parser.grammar.Context;
import com.dell.doradus.search.parser.grammar.Error;
import com.dell.doradus.search.parser.grammar.GrammarItem;
import com.dell.doradus.search.parser.grammar.GrammarRule;
import com.dell.doradus.search.parser.grammar.Literal;
import com.dell.doradus.search.parser.grammar.Semantic;
import com.dell.doradus.search.parser.grammar.SequenceRule;
import java.util.Arrays;
import java.util.List;

public class Grammar {
    static int fictiveRuleNumber = 0;
    public static CharacterRule Char = new CharacterRule(){

        @Override
        public String Name() {
            return "Char";
        }

        @Override
        public boolean Accept(char c) {
            return true;
        }
    };
    public static CharacterRule Digit = new CharacterRule(){

        @Override
        public String Name() {
            return "Digit";
        }

        @Override
        public boolean Accept(char c) {
            return Character.isDigit(c);
        }
    };
    public static CharacterRule HexDigit = new CharacterRule(){

        @Override
        public String Name() {
            return "HexDigit";
        }

        @Override
        public boolean Accept(char c) {
            return Character.digit(c, 16) != -1;
        }
    };
    public static CharacterRule Letter = new CharacterRule(){

        @Override
        public String Name() {
            return "Letter";
        }

        @Override
        public boolean Accept(char c) {
            return Character.isLetter(c);
        }
    };
    public static Error unexpectedToken = new Error("Unexpected token"){

        @Override
        public Context Match(Context context) {
            this.message = "Unexpected token: " + context.items.get(context.items.size() - 1).getValue();
            return super.Match(context);
        }
    };
    public static GrammarRule MustMatchAction = new GrammarRule(){

        @Override
        public String Name() {
            return "MustMatchAction";
        }

        @Override
        public Context Match(Context context) {
            context.error = true;
            return context;
        }
    };
    public static GrammarRule debugGrammarRule = new GrammarRule(){

        @Override
        public Context Match(Context context) {
            return context;
        }

        @Override
        public String Name() {
            return "debugGrammarRule";
        }
    };
    public static GrammarRule emptyRule = new GrammarRule(){

        @Override
        public Context Match(Context context) {
            return context;
        }

        @Override
        public String Name() {
            return "NULL";
        }
    };
    public static GrammarRule WhiteSpaces = new GrammarRule(){

        @Override
        public String Name() {
            return "WhiteSpaces";
        }

        @Override
        public Context Match(Context context) {
            int ptr = context.ptr;
            int len = context.inputString.length();
            String source = context.inputString;
            while (ptr < len && Character.isWhitespace(source.charAt(ptr))) {
                ++ptr;
            }
            if (ptr > context.ptr) {
                String lexem = context.inputString.substring(context.ptr, ptr);
                context.items.add(new Literal(lexem, "WhiteSpaces", context.ptr));
                context.ptr += lexem.length();
                return context;
            }
            return null;
        }
    };
    public static GrammarRule InputPointer = new GrammarRule(){

        @Override
        public String Name() {
            return "InputPointer";
        }

        @Override
        public Context Match(Context context) {
            context.items.add(new Literal(this.Name(), this.Name(), context.ptr));
            return context;
        }
    };
    public static GrammarRule WordLiteral = new GrammarRule(){
        String startPattern = "*?-_@#";

        @Override
        public String Name() {
            return "WordLiteral";
        }

        @Override
        public Context Match(Context context) {
            int ptr = context.ptr;
            if (ptr >= context.inputString.length()) {
                return null;
            }
            String value = this.IdentifierFromString(context, ptr, this.startPattern, this.startPattern);
            if (value == null) {
                return null;
            }
            context.items.add(new Literal(value, "lexem", ptr));
            return context;
        }

        public String IdentifierFromString(Context cntx, int pos, String starts, String middle) {
            String source = cntx.inputString;
            char c = source.charAt(pos);
            if (Character.isLetterOrDigit(c) || starts.indexOf(c) != -1) {
                int startPos = pos++;
                int len = source.length();
                while (pos < len) {
                    c = source.charAt(pos);
                    if (!Character.isLetterOrDigit(c) && middle.indexOf(c) == -1) {
                        cntx.ptr = pos;
                        return source.substring(startPos, pos);
                    }
                    ++pos;
                }
                cntx.ptr = pos;
                return source.substring(startPos);
            }
            return null;
        }
    };
    public static GrammarRule DropLexem = new GrammarRule(){

        @Override
        public String Name() {
            return "DropLexem";
        }

        @Override
        public Context Match(Context context) {
            context.items.remove(context.items.size() - 1);
            return context;
        }
    };

    public static List<GrammarRule> asRule(GrammarRule ... a) {
        return Arrays.asList(a);
    }

    public static GrammarRule Semantic(String name) {
        return new Semantic(name);
    }

    public static GrammarRule SetType(String name) {
        return new Semantic(name){

            @Override
            public Context Match(Context context) {
                GrammarItem item = context.items.get(context.items.size() - 1);
                item.setType(this.name);
                return context;
            }
        };
    }

    public static GrammarRule NotLexem(String name) {
        return new Semantic(name){

            @Override
            public Context Match(Context context) {
                GrammarItem item = context.items.get(context.items.size() - 1);
                if (item.getValue().equals(this.name)) {
                    return null;
                }
                return context;
            }
        };
    }

    public static GrammarRule SetTextValue(String name) {
        return new Semantic(name){

            @Override
            public Context Match(Context context) {
                GrammarItem item = context.items.get(context.items.size() - 1);
                item.setValue(this.name);
                return context;
            }
        };
    }

    public static GrammarRule Error(String name) {
        return new Error(name);
    }

    public static GrammarRule Error(String name, String message) {
        return new Error(name, message);
    }

    public static SequenceRule Rule(GrammarRule ... rules) {
        return new SequenceRule("Fictive " + fictiveRuleNumber++, rules);
    }

    public static SequenceRule Rule(String name, GrammarRule ... rules) {
        return new SequenceRule(name, rules);
    }

    public static CharacterRule ExceptChar(char ch) {
        return new CharacterRule(ch){

            @Override
            public String Name() {
                return "ExceptChar " + this.pattern;
            }

            @Override
            public boolean Accept(char ch) {
                return !this.pattern.equals(Character.valueOf(ch));
            }
        };
    }

    public static enum CharacterType {
        Letter,
        Digit,
        LetterOrDigit;

    }
}

