/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.parser;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.TimeZone;

public class TimeUtils {
    static final long ONE_SECOND = 1000L;
    static final long ONE_MINUTE = 60000L;
    static final long ONE_HOUR = 3600000L;
    static final long ONE_DAY = 86400000L;
    static final long ONE_WEEK = 604800000L;
    static final long ONE_MONTH = 2592000000L;
    static final long ONE_YEAR = 31536000000L;
    static final long ONE_QUARTER = 7776000000L;
    static Hashtable<String, Integer> functions = new Hashtable();
    static Hashtable<String, String> timeZoneShortNames = new Hashtable();
    static SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    static TimeZone utc = TimeZone.getTimeZone("UTC");
    static Calendar utcCalendar = Calendar.getInstance(utc);

    static {
        format.setTimeZone(utc);
        functions.put("THISMINUTE", 1);
        functions.put("THISHOUR", 2);
        functions.put("TODAY", 3);
        functions.put("THISWEEK", 4);
        functions.put("THISMONTH", 5);
        functions.put("THISYEAR", 6);
        functions.put("LASTMINUTE", 10);
        functions.put("LASTHOUR", 11);
        functions.put("LASTDAY", 12);
        functions.put("LASTWEEK", 13);
        functions.put("LASTMONTH", 14);
        functions.put("LASTYEAR", 15);
        functions.put("MINUTE", 20);
        functions.put("HOUR", 21);
        functions.put("DAY", 22);
        functions.put("WEEK", 23);
        functions.put("MONTH", 24);
        functions.put("YEAR", 25);
        functions.put("MINUTES", 20);
        functions.put("HOURS", 21);
        functions.put("DAYS", 22);
        functions.put("WEEKS", 23);
        functions.put("MONTHS", 24);
        functions.put("YEARS", 25);
        functions.put("QUARTER", 26);
        functions.put("SECOND", 27);
    }

    public static Calendar getCalendarByName(String timeZone) {
        TimeZone zone = TimeZone.getTimeZone(timeZone = timeZone.trim());
        String id = zone.getID();
        if (id.compareTo(timeZone) != 0) {
            throw new IllegalArgumentException("Bad timezone name: '" + timeZone + "'");
        }
        return Calendar.getInstance(zone);
    }

    public static TimeZone getTimeZone(String timeZone) {
        TimeZone zone = TimeZone.getTimeZone(timeZone = timeZone.trim());
        String id = zone.getID();
        if (id.compareTo(timeZone) != 0) {
            throw new IllegalArgumentException("Bad timezone name: '" + timeZone + "'");
        }
        return zone;
    }

    public static Calendar getCalendarByValue(String timeZone) {
        char ch = (timeZone = timeZone.trim()).charAt(0);
        if (ch == '+' || ch == '-') {
            timeZone = "GMT" + timeZone;
        } else if (Character.getType(ch) == 9) {
            timeZone = "GMT+" + timeZone;
        }
        String prefix = timeZone.substring(0, 4);
        String val = timeZone.substring(4);
        switch (val.length()) {
            case 1: {
                timeZone = String.valueOf(prefix) + "0" + val + ":00";
                break;
            }
            case 2: {
                timeZone = String.valueOf(prefix) + val + ":00";
                break;
            }
            case 3: {
                timeZone = String.valueOf(prefix) + "0" + val.substring(0, 1) + ":" + val.substring(1);
                break;
            }
            case 4: {
                if (val.charAt(1) == ':') {
                    timeZone = String.valueOf(prefix) + "0" + val;
                    break;
                }
                timeZone = String.valueOf(prefix) + val.substring(0, 2) + ":" + val.substring(2);
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Internal error: bad timezone(1)");
            }
        }
        return TimeUtils.getCalendarByName(timeZone);
    }

    public static Calendar getNowValue(Calendar calendar, String units, Integer number) {
        Calendar c1 = (Calendar)calendar.clone();
        if (units != null) {
            switch (functions.get(units)) {
                case 20: {
                    c1.add(12, number);
                    break;
                }
                case 21: {
                    c1.add(11, number);
                    break;
                }
                case 22: {
                    c1.add(6, number);
                    break;
                }
                case 23: {
                    c1.add(3, number);
                    break;
                }
                case 24: {
                    c1.add(2, number);
                    break;
                }
                case 25: {
                    c1.add(1, number);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Internal error: Unknown units for period definition:" + units);
                }
            }
        }
        return c1;
    }

    public static Calendar getPeriodStart(Calendar calendar, String units, String value) {
        int number = 1;
        if (value != null) {
            try {
                number = Integer.parseInt(value);
                if (number < 1) {
                    throw new IllegalArgumentException("Period.Last* value must be greater than 0: " + value);
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Bad format for Period.Last* value: " + value);
            }
        }
        Calendar c1 = (Calendar)calendar.clone();
        switch (functions.get(units)) {
            case 1: {
                c1.set(13, 0);
                c1.set(14, 0);
                break;
            }
            case 2: {
                c1.set(12, 0);
                c1.set(13, 0);
                c1.set(14, 0);
                break;
            }
            case 3: {
                c1.clear(9);
                c1.set(11, 0);
                c1.set(12, 0);
                c1.set(13, 0);
                c1.set(14, 0);
                break;
            }
            case 4: {
                c1.set(7, c1.getFirstDayOfWeek());
                c1.clear(9);
                c1.set(11, 0);
                c1.set(12, 0);
                c1.set(13, 0);
                c1.set(14, 0);
                break;
            }
            case 5: {
                c1.set(5, 1);
                c1.clear(9);
                c1.set(11, 0);
                c1.set(12, 0);
                c1.set(13, 0);
                c1.set(14, 0);
                break;
            }
            case 6: {
                c1.clear(9);
                c1.set(11, 0);
                c1.set(12, 0);
                c1.set(13, 0);
                c1.set(14, 0);
                c1.set(6, 1);
                break;
            }
            case 10: {
                c1.add(12, -1 * number);
                break;
            }
            case 11: {
                c1.add(11, -1 * number);
                break;
            }
            case 12: {
                c1.add(10, -24 * number);
                break;
            }
            case 13: {
                c1.add(6, -7 * number);
                break;
            }
            case 14: {
                c1.add(2, -1 * number);
                break;
            }
            case 15: {
                c1.add(1, -1 * number);
                break;
            }
            default: {
                throw new IllegalArgumentException("Internal error: Unknown units for period definition:" + units);
            }
        }
        return c1;
    }

    public static Calendar getPeriodEnd(Calendar calendar, String units) {
        Calendar c1 = (Calendar)calendar.clone();
        switch (functions.get(units)) {
            case 1: {
                c1.set(13, 0);
                c1.set(14, 0);
                c1.add(12, 1);
                break;
            }
            case 2: {
                c1.set(12, 0);
                c1.set(13, 0);
                c1.set(14, 0);
                c1.add(11, 1);
                break;
            }
            case 3: {
                c1.clear(9);
                c1.set(11, 0);
                c1.set(12, 0);
                c1.set(13, 0);
                c1.set(14, 0);
                c1.add(6, 1);
                break;
            }
            case 4: {
                c1.set(7, c1.getFirstDayOfWeek());
                c1.clear(9);
                c1.set(11, 0);
                c1.set(12, 0);
                c1.set(13, 0);
                c1.set(14, 0);
                c1.add(3, 1);
                break;
            }
            case 5: {
                c1.set(5, 1);
                c1.clear(9);
                c1.set(11, 0);
                c1.set(12, 0);
                c1.set(13, 0);
                c1.set(14, 0);
                c1.add(2, 1);
                break;
            }
            case 6: {
                c1.clear(9);
                c1.set(11, 0);
                c1.set(12, 0);
                c1.set(13, 0);
                c1.set(14, 0);
                c1.set(6, 1);
                c1.add(1, 1);
                break;
            }
        }
        return c1;
    }

    public static boolean isThisUnit(String units) {
        switch (functions.get(units)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public static String toUtcTime(Calendar calendar) {
        utcCalendar.setTimeInMillis(calendar.getTimeInMillis());
        return format.format(utcCalendar.getTime());
    }

    public static long getTimeDifference(String unit, Calendar start, Calendar end) {
        long diff = end.getTimeInMillis() - start.getTimeInMillis();
        switch (functions.get(unit)) {
            case 20: {
                diff /= 60000L;
                break;
            }
            case 21: {
                diff /= 3600000L;
                break;
            }
            case 22: {
                diff /= 86400000L;
                break;
            }
            case 23: {
                diff /= 604800000L;
                break;
            }
            case 24: {
                diff = end.get(1) - start.get(1);
                diff = diff * 12L + (long)end.get(2) - (long)start.get(2);
                break;
            }
            case 25: {
                diff = end.get(1) - start.get(1);
                break;
            }
            case 26: {
                diff = end.get(1) - start.get(1);
                diff = diff * 12L + (long)end.get(2) - (long)start.get(2);
                diff /= 3L;
                break;
            }
            case 27: {
                diff /= 1000L;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported date time unit:" + unit);
            }
        }
        return diff;
    }
}

