/*
 * Decompiled with CFR 0.152.
 */
package com.dell.doradus.search.parser;

import com.dell.doradus.common.TableDefinition;
import com.dell.doradus.search.parser.BuilderContext;
import com.dell.doradus.search.parser.DatePartQueryVisitor;
import com.dell.doradus.search.parser.DoradusQueryBuilder;
import com.dell.doradus.search.parser.FieldNameVisitor;
import com.dell.doradus.search.parser.FieldVisitor;
import com.dell.doradus.search.parser.LinkCheckVisitor;
import com.dell.doradus.search.parser.LinkIdReplaceVisitor;
import com.dell.doradus.search.parser.LinkIdVisitor;
import com.dell.doradus.search.parser.LinkItem;
import com.dell.doradus.search.parser.MultiValueVisitor;
import com.dell.doradus.search.parser.QueryFieldType;
import com.dell.doradus.search.parser.QueryUtils;
import com.dell.doradus.search.parser.grammar.GrammarItem;
import com.dell.doradus.search.query.AndQuery;
import com.dell.doradus.search.query.BinaryQuery;
import com.dell.doradus.search.query.FieldCountQuery;
import com.dell.doradus.search.query.FieldCountRangeQuery;
import com.dell.doradus.search.query.LinkCountQuery;
import com.dell.doradus.search.query.LinkCountRangeQuery;
import com.dell.doradus.search.query.LinkIdQuery;
import com.dell.doradus.search.query.LinkQuery;
import com.dell.doradus.search.query.MVSBinaryQuery;
import com.dell.doradus.search.query.NotQuery;
import com.dell.doradus.search.query.OrQuery;
import com.dell.doradus.search.query.Query;
import com.dell.doradus.search.query.RangeQuery;
import com.dell.doradus.search.query.TransitiveLinkQuery;
import java.util.ArrayList;
import java.util.Stack;

public class SearchQueryBuilder {
    private static boolean isImmediate(String operation) {
        return operation.equals("}") || operation.equals("]") || operation.equals(")") || operation.equals("AND") || operation.equals("OR") || operation.equals("EOF") || operation.equals("Criteria");
    }

    public static void pushQuery(BuilderContext builderContext, Query query) {
        builderContext.queries.push(query);
        if (!builderContext.operationEmpty()) {
            String operation = builderContext.operationPop();
            if (operation.equals("NOT") || operation.equals(":") || operation.equals(">") || operation.equals(">=") || operation.equals("<") || operation.equals("<=")) {
                SearchQueryBuilder.DoOperation(operation, builderContext);
            } else {
                builderContext.operationPush(operation);
            }
        }
    }

    static void pushOperation(BuilderContext builderContext, String operation) {
        if (!SearchQueryBuilder.isImmediate(operation)) {
            if (operation.equals("WHERE")) {
                Query q = builderContext.queries.peek();
                TableDefinition newDef = QueryUtils.GetTableContext(q, builderContext.definition);
                builderContext.tables.push(builderContext.definition);
                builderContext.definition = newDef;
            }
            builderContext.operationPush(operation);
            return;
        }
        if (operation.equals("}") || operation.equals("]")) {
            String op;
            boolean maxI = false;
            if (operation.equals("]")) {
                maxI = true;
            }
            if ((op = builderContext.operationPop()).equals("TO")) {
                SearchQueryBuilder.DoOperation(op, builderContext);
                op = builderContext.operationPop();
                if (op.equals("{") || op.equals("[")) {
                    boolean minI = false;
                    if (op.equals("[")) {
                        minI = true;
                    }
                    RangeQuery rq = (RangeQuery)builderContext.queries.pop();
                    rq.minInclusive = minI;
                    rq.maxInclusive = maxI;
                    builderContext.queries.push(rq);
                    String op1 = builderContext.operationPeek();
                    if (op1.equals("=")) {
                        op1 = builderContext.operationPop();
                        SearchQueryBuilder.DoOperation(op1, builderContext);
                    }
                    return;
                }
            }
        }
        if (operation.equals(")")) {
            while (!builderContext.operationEmpty()) {
                String op = builderContext.operationPop();
                if (op.equals("(")) {
                    String op1;
                    if (!builderContext.operationEmpty() && ((op1 = builderContext.operationPeek()).equals(":") || op1.equals("=") || op1.equals("~=") || op1.equals("ANY") || op1.equals("ALL") || op1.equals("NONE"))) {
                        SearchQueryBuilder.DoOperation(builderContext.operationPop(), builderContext);
                    }
                    break;
                }
                SearchQueryBuilder.DoOperation(op, builderContext);
            }
        } else {
            int tokenPrecedence = 1;
            if (operation.equals("AND")) {
                tokenPrecedence = 2;
            }
            while (!builderContext.operationEmpty()) {
                String opTop = builderContext.operationPop();
                if (opTop.equals("(")) {
                    builderContext.operationPush(opTop);
                    break;
                }
                int previousTokenPrecedence = 2;
                previousTokenPrecedence = opTop.equals("OR") ? 1 : 2;
                if (previousTokenPrecedence < tokenPrecedence) {
                    builderContext.operationPush(opTop);
                    break;
                }
                if (operation.equals("Criteria")) {
                    Query f = builderContext.queries.pop();
                    Query s = builderContext.queries.pop();
                    Query t = QueryUtils.CloneQuery(s);
                    builderContext.queries.push(s);
                    builderContext.queries.push(f);
                    SearchQueryBuilder.DoOperation(opTop, builderContext);
                    builderContext.queries.push(t);
                    builderContext.operationPush("ANDC");
                    return;
                }
                SearchQueryBuilder.DoOperation(opTop, builderContext);
            }
            if (operation.equals("Criteria")) {
                operation = "ANDC";
            }
            builderContext.operationPush(operation);
        }
    }

    static void DoOperation(String op, BuilderContext builderContext) {
        if (op.equals("ADDF") || op.equals("Criteria")) {
            return;
        }
        if (op.equals("ANDC")) {
            Query second = builderContext.queries.pop();
            Query first = builderContext.queries.pop();
            Query result = QueryUtils.MergeAND(first, second);
            builderContext.queries.push(result);
            return;
        }
        if (op.equals("AND")) {
            Query second = builderContext.queries.pop();
            Query first = builderContext.queries.pop();
            if (first instanceof AndQuery) {
                ((AndQuery)first).subqueries.add(second);
                SearchQueryBuilder.pushQuery(builderContext, first);
            } else {
                SearchQueryBuilder.pushQuery(builderContext, SearchQueryBuilder.CreateAndQuery(first, second));
            }
            return;
        }
        if (op.equals("OR")) {
            Query second = builderContext.queries.pop();
            Query first = builderContext.queries.pop();
            if (first instanceof OrQuery) {
                ((OrQuery)first).subqueries.add(second);
                SearchQueryBuilder.pushQuery(builderContext, first);
            } else {
                SearchQueryBuilder.pushQuery(builderContext, SearchQueryBuilder.CreateOrQuery(first, second));
            }
            return;
        }
        if (op.equals("WHERE")) {
            Query first = builderContext.queries.pop();
            builderContext.definition = builderContext.tables.pop();
            Query second = builderContext.queries.pop();
            SearchQueryBuilder.PerformWhereOperation(builderContext, first, second);
            return;
        }
        if (op.equals("=")) {
            SearchQueryBuilder.PerformAssign(builderContext, BinaryQuery.EQUALS);
            return;
        }
        if (op.equals("NULL")) {
            SearchQueryBuilder.PerformAssign(builderContext, "NULL");
            Query current = builderContext.queries.pop();
            boolean none = SearchQueryBuilder.isNonePresent(current);
            if (current instanceof LinkQuery) {
                LinkQuery lq = (LinkQuery)current;
                if (LinkQuery.ALL.equals(lq.quantifier) || LinkQuery.NONE.equals(lq.quantifier)) {
                    while (lq.innerQuery != null) {
                        Query q = lq.innerQuery;
                        if (q instanceof LinkQuery) {
                            LinkQuery candidad = (LinkQuery)q;
                            if (candidad.quantifier.equals(LinkQuery.ANY)) {
                                lq.innerQuery = new NotQuery(candidad);
                                if (none) {
                                    SearchQueryBuilder.removeNone(current);
                                    builderContext.queries.push(new NotQuery(current));
                                } else {
                                    builderContext.queries.push(current);
                                }
                                return;
                            }
                            lq = candidad;
                            continue;
                        }
                        lq.innerQuery = new NotQuery(q);
                        if (none) {
                            builderContext.queries.push(new NotQuery(current));
                            SearchQueryBuilder.removeNone(current);
                        } else {
                            builderContext.queries.push(current);
                        }
                        return;
                    }
                    throw new RuntimeException("Wrong usage of ALL or ANY");
                }
                builderContext.queries.push(new NotQuery(current));
            } else {
                builderContext.queries.push(new NotQuery(current));
            }
            return;
        }
        if (op.equals(":")) {
            SearchQueryBuilder.PerformAssign(builderContext, BinaryQuery.CONTAINS);
            return;
        }
        if (op.equals("TO")) {
            Query second = builderContext.queries.pop();
            Query first = builderContext.queries.pop();
            RangeQuery rq = new RangeQuery(null, ((BinaryQuery)first).value, false, ((BinaryQuery)second).value, false);
            builderContext.queries.push(rq);
            return;
        }
        if (op.equals(">") || op.equals(">=") || op.equals("<") || op.equals("<=")) {
            SearchQueryBuilder.PerformCompare(builderContext, op);
            return;
        }
        if (op.equals("NOT")) {
            Query query = builderContext.queries.pop();
            NotQuery notQuery = new NotQuery();
            notQuery.innerQuery = query;
            builderContext.queries.push(notQuery);
            return;
        }
        if (op.equals("EOF")) {
            return;
        }
        throw new IllegalArgumentException("Error, unsupported operation:" + op);
    }

    private static void PerformCompare(BuilderContext builderContext, String op) {
        Query first = builderContext.queries.pop();
        Query second = builderContext.queries.pop();
        SearchQueryBuilder.PerformCompare1(builderContext, first, second, op);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void PerformCompare1(BuilderContext builderContext, Query q, Query first, String op) {
        String field = "";
        if (QueryUtils.HasInnerQuery(first)) {
            Query iq = QueryUtils.GetLastChild(first);
            field = QueryUtils.GetLinkQueryLink(iq);
            QueryFieldType fieldtype = QueryUtils.GetFieldType(QueryUtils.GetPath(first, builderContext.definition), builderContext.definition);
            Query pat = QueryUtils.GetParent(first, iq);
            if (QueryUtils.GetLinkQuantifier(iq).equals("COUNT")) {
                boolean isLink;
                if (fieldtype != QueryFieldType.Link && fieldtype != QueryFieldType.Field && fieldtype != QueryFieldType.MultiValueScalar && fieldtype != QueryFieldType.Unknown) throw new IllegalArgumentException("Error COUNT: " + field + " is not a link or field");
                boolean bl = isLink = fieldtype == QueryFieldType.Link;
                if (!(iq instanceof LinkQuery)) throw new IllegalArgumentException("Error COUNT: " + field + " is not a link or field");
                LinkQuery llq = (LinkQuery)iq;
                if (!llq.quantifier.equals("COUNT")) throw new IllegalArgumentException("Error COUNT: " + field + " is not a link or field");
                SearchQueryBuilder.SetLinkQueryQuantifier(first, LinkQuery.ANY);
                RangeQuery rq = SearchQueryBuilder.CreateRangeQuery(op, (BinaryQuery)q, field);
                if (isLink) {
                    LinkCountRangeQuery lcrq = new LinkCountRangeQuery(field, rq);
                    lcrq.filter = llq.filter;
                    QueryUtils.SetInnerQuery(pat, lcrq);
                } else {
                    if (llq.filter != null) {
                        throw new IllegalArgumentException("Filters are not supported for non link fields: " + field);
                    }
                    QueryUtils.SetInnerQuery(pat, new FieldCountRangeQuery(field, rq));
                }
                builderContext.queries.push(first);
                return;
            }
            switch (fieldtype) {
                case Link: {
                    throw new IllegalArgumentException("Operation '" + op + "' is not supported for links (" + field + ")");
                }
                case MultiValueScalar: {
                    throw new IllegalArgumentException("Operation '" + op + "' is not supported for scalar collections (" + field + ")");
                }
            }
            RangeQuery rq = SearchQueryBuilder.CreateRangeQuery(op, (BinaryQuery)q, field);
            Query parent = QueryUtils.GetParent(first, iq);
            if (parent == null) {
                builderContext.queries.push(rq);
                return;
            } else {
                QueryUtils.SetInnerQuery(parent, rq);
                builderContext.queries.push(first);
            }
            return;
        } else {
            if (first instanceof LinkQuery && QueryUtils.GetLinkQuantifier(first).equals("COUNT")) {
                LinkQuery lqOrigin = (LinkQuery)first;
                String fname = lqOrigin.link;
                QueryFieldType fieldtype = QueryUtils.GetFieldType(QueryUtils.GetPath(first, builderContext.definition), builderContext.definition);
                RangeQuery rq = SearchQueryBuilder.CreateRangeQuery(op, (BinaryQuery)q, fname);
                switch (fieldtype) {
                    case Link: {
                        LinkCountRangeQuery lcrq = new LinkCountRangeQuery(fname, rq);
                        lcrq.filter = lqOrigin.filter;
                        builderContext.queries.push(lcrq);
                        return;
                    }
                    case Group: {
                        throw new IllegalArgumentException("Error. COUNT is not supported for group fields: " + fname);
                    }
                }
                if (lqOrigin.filter != null) {
                    throw new IllegalArgumentException("Filters are not supported for non link fields: " + fname);
                }
                builderContext.queries.push(new FieldCountRangeQuery(fname, rq));
                return;
            }
            if (!(first instanceof BinaryQuery)) {
                if (!(first instanceof LinkQuery)) throw new IllegalArgumentException("Error: unsupported operation " + op);
                field = ((LinkQuery)first).link;
            } else {
                field = ((BinaryQuery)first).value;
            }
            if (builderContext.definition != null && builderContext.definition.isLinkField(field)) {
                throw new IllegalArgumentException("Error: unsupported operation " + op + " for link " + field);
            }
            builderContext.queries.push(SearchQueryBuilder.CreateRangeQuery(op, (BinaryQuery)q, field));
        }
    }

    private static void PerformWhereOperation(BuilderContext builderContext, Query first, Query secondQuery) {
        Query second = secondQuery;
        boolean notQuery = second instanceof NotQuery;
        if (notQuery) {
            second = ((NotQuery)second).innerQuery;
        }
        if (second instanceof LinkQuery || second instanceof TransitiveLinkQuery) {
            if (QueryUtils.HasInnerQuery(second)) {
                Query last = QueryUtils.GetLastChild(second);
                if (!(last instanceof LinkQuery) && !(last instanceof TransitiveLinkQuery)) {
                    builderContext.queries.push(second);
                    builderContext.queries.push(first);
                    return;
                }
                QueryUtils.SetInnerQuery(last, first);
                if (notQuery) {
                    builderContext.queries.push(secondQuery);
                } else {
                    builderContext.queries.push(second);
                }
                return;
            }
            QueryUtils.SetInnerQuery(second, first);
            builderContext.queries.push(second);
            return;
        }
        if (second instanceof BinaryQuery) {
            String field = ((BinaryQuery)second).value;
            LinkQuery lq = new LinkQuery(LinkQuery.ANY, field, first);
            if (notQuery) {
                ((NotQuery)secondQuery).innerQuery = lq;
                builderContext.queries.push(secondQuery);
            } else {
                builderContext.queries.push(lq);
            }
            return;
        }
        throw new IllegalArgumentException("Internal error: unexpected usage of and");
    }

    private static void removeNone(Query q) {
        while (SearchQueryBuilder.isNonePresent(q)) {
            if (q instanceof LinkQuery) {
                ((LinkQuery)q).quantifier = LinkQuery.ANY;
                q = ((LinkQuery)q).innerQuery;
            }
            if (q instanceof TransitiveLinkQuery) {
                ((TransitiveLinkQuery)q).quantifier = LinkQuery.ANY;
                q = ((TransitiveLinkQuery)q).innerQuery;
            }
            if (q instanceof MVSBinaryQuery) {
                ((MVSBinaryQuery)q).quantifier = LinkQuery.ANY;
                q = ((MVSBinaryQuery)q).innerQuery;
            }
            if (q instanceof LinkIdQuery) {
                ((LinkIdQuery)q).quantifier = LinkQuery.ANY;
                return;
            }
            if (q != null) continue;
            return;
        }
    }

    private static boolean isNonePresent(Query q) {
        if (q instanceof LinkQuery) {
            return LinkQuery.NONE.equals(((LinkQuery)q).quantifier);
        }
        if (q instanceof TransitiveLinkQuery) {
            return LinkQuery.NONE.equals(((TransitiveLinkQuery)q).quantifier);
        }
        if (q instanceof MVSBinaryQuery) {
            return LinkQuery.NONE.equals(((MVSBinaryQuery)q).quantifier);
        }
        if (q instanceof LinkIdQuery) {
            return LinkQuery.NONE.equals(((LinkIdQuery)q).quantifier);
        }
        return false;
    }

    private static void PerformAssign(BuilderContext builderContext, String operationType) {
        Query first = builderContext.queries.pop();
        Query second = builderContext.queries.pop();
        if (operationType.equals(BinaryQuery.EQUALS) && first instanceof OrQuery && SearchQueryBuilder.isNonePresent(second)) {
            OrQuery orQuery = new OrQuery();
            OrQuery source = (OrQuery)first;
            SearchQueryBuilder.removeNone(second);
            int i = 0;
            while (i < source.subqueries.size()) {
                Query query = source.subqueries.get(i);
                SearchQueryBuilder.LinkQueryAssign(builderContext, query, QueryUtils.CloneQuery(second), operationType);
                orQuery.subqueries.add(builderContext.queries.pop());
                ++i;
            }
            builderContext.queries.push(new NotQuery(orQuery));
        } else if (operationType.equals(BinaryQuery.EQUALS) && SearchQueryBuilder.isNonePresent(second)) {
            SearchQueryBuilder.removeNone(second);
            SearchQueryBuilder.LinkQueryAssign(builderContext, first, second, operationType);
            builderContext.queries.push(new NotQuery(builderContext.queries.pop()));
        } else if (operationType.equals("NULL")) {
            SearchQueryBuilder.LinkQueryAssign(builderContext, first, second, BinaryQuery.EQUALS);
        } else {
            SearchQueryBuilder.LinkQueryAssign(builderContext, first, second, operationType);
        }
    }

    private static RangeQuery CreateRangeQuery(String op, BinaryQuery bq, String field) {
        String min = null;
        String max = null;
        boolean minI = false;
        boolean maxI = false;
        if (op.equals(">")) {
            return new RangeQuery(field, bq.value, minI, max, maxI);
        }
        if (op.equals(">=")) {
            return new RangeQuery(field, bq.value, true, max, maxI);
        }
        if (op.equals("<")) {
            return new RangeQuery(field, min, minI, bq.value, maxI);
        }
        if (op.equals("<=")) {
            return new RangeQuery(field, min, minI, bq.value, true);
        }
        return new RangeQuery(field, min, minI, max, maxI);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean LinkQueryAssign(BuilderContext builderContext, Query first, Query second, String op) {
        Query lq = second;
        ArrayList<String> path = QueryUtils.GetPath(lq, builderContext.definition);
        QueryFieldType fieldType = QueryUtils.GetFieldType(path, builderContext.definition);
        if (QueryUtils.HasInnerQuery(lq)) {
            Query last = QueryUtils.GetLastChild(lq);
            Query pat = QueryUtils.GetParent(lq, last);
            String lastname = QueryUtils.GetLinkQueryLink(last);
            if (path.size() > 1 && QueryUtils.TruncateUnits.containsKey(lastname)) {
                QueryUtils.CheckPath(path, path.size() - 2, builderContext.definition, false);
            }
            if (QueryUtils.GetLinkQuantifier(last).equals("COUNT")) {
                switch (fieldType) {
                    case Field: 
                    case Link: 
                    case MultiValueScalar: {
                        boolean isLink;
                        boolean bl = isLink = fieldType == QueryFieldType.Link;
                        if (!(last instanceof LinkQuery)) throw new IllegalArgumentException("Error COUNT: " + QueryUtils.GetLinkQueryLink(last) + " is not a link or field");
                        LinkQuery llq = (LinkQuery)last;
                        if (!llq.quantifier.equals("COUNT")) throw new IllegalArgumentException("Error COUNT: " + QueryUtils.GetLinkQueryLink(last) + " is not a link or field");
                        if (isLink) {
                            SearchQueryBuilder.SetLinkQueryQuantifier(second, LinkQuery.ANY);
                        }
                        if (first instanceof BinaryQuery) {
                            int countValue = Integer.parseInt(((BinaryQuery)first).value);
                            if (isLink) {
                                QueryUtils.SetInnerQuery(pat, new LinkCountQuery(QueryUtils.GetLinkQueryLink(last), countValue));
                            } else {
                                QueryUtils.SetInnerQuery(pat, new FieldCountQuery(QueryUtils.GetLinkQueryLink(last), countValue));
                            }
                            String quantifier = QueryUtils.GetLinkQuantifier(second);
                            if (quantifier != null && quantifier.equals("COUNT")) {
                                SearchQueryBuilder.SetLinkQueryQuantifier(second, LinkQuery.ANY);
                            }
                            builderContext.queries.push(second);
                            return false;
                        }
                        if (!(first instanceof RangeQuery)) throw new IllegalArgumentException("Error COUNT: " + QueryUtils.GetLinkQueryLink(last) + " is not a link or field");
                        RangeQuery rq = (RangeQuery)first;
                        rq.field = lastname;
                        if (isLink) {
                            QueryUtils.SetInnerQuery(pat, new LinkCountRangeQuery(lastname, rq));
                        } else {
                            QueryUtils.SetInnerQuery(pat, new FieldCountRangeQuery(lastname, rq));
                        }
                        String quantifier = QueryUtils.GetLinkQuantifier(second);
                        if (quantifier != null && quantifier.equals("COUNT")) {
                            SearchQueryBuilder.SetLinkQueryQuantifier(second, LinkQuery.ANY);
                        }
                        builderContext.queries.push(second);
                        return false;
                    }
                }
                throw new IllegalArgumentException("Error COUNT: " + QueryUtils.GetLinkQueryLink(last) + " is not a link or field");
            }
            QueryFieldType fType = QueryUtils.GetBasicFieldType(path, builderContext.definition);
            switch (fieldType) {
                case MultiValueScalar: {
                    if (first instanceof RangeQuery) {
                        DoradusQueryBuilder.traverse(first, new FieldVisitor(QueryUtils.GetLinkQueryLink(last), op));
                        QueryUtils.SetInnerQuery(pat, first);
                        break;
                    }
                    if (last instanceof TransitiveLinkQuery) {
                        throw new IllegalArgumentException(String.valueOf(lastname) + "  is not a link");
                    }
                    Query mq = DoradusQueryBuilder.traverseTree(new Stack<String>(), first, new MultiValueVisitor(QueryUtils.GetLinkQuantifier(last), QueryUtils.GetLinkQueryLink(last), op));
                    QueryUtils.SetInnerQuery(pat, mq);
                    break;
                }
                case Field: {
                    if (last instanceof TransitiveLinkQuery) {
                        throw new IllegalArgumentException(String.valueOf(lastname) + "  is not a link");
                    }
                    DoradusQueryBuilder.traverse(first, new FieldVisitor(QueryUtils.GetLinkQueryLink(last), op));
                    QueryUtils.SetInnerQuery(pat, first);
                    break;
                }
                case Link: 
                case Group: {
                    if (fType == QueryFieldType.Link) {
                        if (last instanceof TransitiveLinkQuery) {
                            Query newFirst = DoradusQueryBuilder.traverseTree(new Stack<String>(), first, new LinkIdReplaceVisitor(QueryUtils.GetLinkQuantifier(last), lastname));
                            QueryUtils.SetInnerQuery(last, newFirst);
                            break;
                        }
                        if (BinaryQuery.CONTAINS.equals(op)) {
                            throw new IllegalArgumentException("Operation ':' is nor supported for links");
                        }
                        Query newFirst = DoradusQueryBuilder.traverseTree(new Stack<String>(), first, new LinkIdVisitor(QueryUtils.GetLinkQuantifier(last), QueryUtils.GetLinkQueryLink(last)));
                        QueryUtils.SetInnerQuery(pat, newFirst);
                        break;
                    }
                }
                default: {
                    if (last instanceof TransitiveLinkQuery) {
                        throw new IllegalArgumentException("Error :" + lastname + " is not a link");
                    }
                    if (QueryUtils.TruncateUnits.containsKey(lastname)) {
                        String truncateField = QueryUtils.GetLinkQueryLink(pat);
                        Query tq = DoradusQueryBuilder.traverseTree(new Stack<String>(), first, new DatePartQueryVisitor(truncateField, op, QueryUtils.TruncateUnits.get(lastname)));
                        if (pat instanceof TransitiveLinkQuery) {
                            throw new IllegalArgumentException(" Error: Cannot apply datetime function for transitive query (" + truncateField + ")");
                        }
                        if (tq instanceof RangeQuery) {
                            throw new IllegalArgumentException(" Error: Date parts for range query are not supported (" + truncateField + ")");
                        }
                        Query insertPoint = QueryUtils.GetParent(lq, pat);
                        if (insertPoint != null) {
                            QueryUtils.SetInnerQuery(insertPoint, tq);
                            break;
                        }
                        second = tq;
                        break;
                    }
                    DoradusQueryBuilder.traverse(first, new FieldVisitor(QueryUtils.GetLinkQueryLink(last), op));
                    QueryUtils.SetInnerQuery(pat, first);
                    break;
                }
            }
        } else {
            String quantifier = "";
            String fname = "";
            boolean quantifierDefined = false;
            Query parent1 = QueryUtils.GetParent(second, lq);
            if (lq instanceof BinaryQuery) {
                BinaryQuery bq = (BinaryQuery)lq;
                ArrayList<String> t = new ArrayList<String>();
                t.add(bq.value);
                fieldType = QueryUtils.GetFieldType(t, builderContext.definition);
                quantifier = LinkQuery.ANY;
                fname = bq.value;
            } else {
                quantifier = QueryUtils.GetLinkQuantifier(lq);
                quantifierDefined = true;
                fname = QueryUtils.GetLinkQueryLink(lq);
            }
            if (quantifier.equals("COUNT")) {
                boolean isLink;
                if (fieldType != QueryFieldType.Link && fieldType != QueryFieldType.Unknown && fieldType != QueryFieldType.Group && fieldType != QueryFieldType.Field && fieldType != QueryFieldType.MultiValueScalar) throw new IllegalArgumentException("Error COUNT: " + fname + " is  not a link or field");
                boolean bl = isLink = fieldType == QueryFieldType.Link || fieldType == QueryFieldType.Group;
                if (lq instanceof LinkQuery) {
                    LinkQuery llq = (LinkQuery)lq;
                    if (isLink) {
                        SearchQueryBuilder.SetLinkQueryQuantifier(second, LinkQuery.ANY);
                    }
                    if (first instanceof BinaryQuery) {
                        int countValue = Integer.parseInt(((BinaryQuery)first).value);
                        if (isLink) {
                            LinkCountQuery newFirst = new LinkCountQuery(fname, countValue);
                            newFirst.filter = llq.filter;
                            second = newFirst;
                        } else {
                            if (llq.filter != null) {
                                throw new IllegalArgumentException("Filters are not supported for non link fields: " + fname);
                            }
                            second = new FieldCountQuery(fname, countValue);
                        }
                    } else {
                        if (!(first instanceof RangeQuery)) throw new IllegalArgumentException("Error : unsupported type for COUNT value");
                        RangeQuery rq = (RangeQuery)first;
                        rq.field = fname;
                        if (isLink) {
                            LinkCountRangeQuery lcrq = new LinkCountRangeQuery(fname, rq);
                            lcrq.filter = llq.filter;
                            second = lcrq;
                        } else {
                            if (llq.filter != null) {
                                throw new IllegalArgumentException("Filters are not supported for non link fields: " + fname);
                            }
                            second = new FieldCountRangeQuery(fname, rq);
                        }
                    }
                }
            } else {
                QueryFieldType originalType = fieldType;
                fieldType = QueryUtils.GetBasicFieldType(path, builderContext.definition);
                switch (originalType) {
                    case MultiValueScalar: {
                        if (first instanceof RangeQuery) {
                            DoradusQueryBuilder.traverse(first, new FieldVisitor(fname, op));
                            if (parent1 != null) {
                                QueryUtils.SetInnerQuery(parent1, first);
                                break;
                            }
                            second = first;
                            break;
                        }
                        Query mq = DoradusQueryBuilder.traverseTree(new Stack<String>(), first, new MultiValueVisitor(quantifier, fname, op));
                        if (parent1 != null) {
                            QueryUtils.SetInnerQuery(parent1, mq);
                            break;
                        }
                        if (second instanceof TransitiveLinkQuery) {
                            throw new IllegalArgumentException("Error:" + fname + " is not a link");
                        }
                        second = mq;
                        break;
                    }
                    case Link: 
                    case Group: {
                        if (fieldType == QueryFieldType.Link) {
                            if (lq instanceof TransitiveLinkQuery) {
                                Query newFirst = DoradusQueryBuilder.traverseTree(new Stack<String>(), first, new LinkIdReplaceVisitor(QueryUtils.GetLinkQuantifier(lq), fname));
                                QueryUtils.SetInnerQuery(lq, newFirst);
                                break;
                            }
                            if (BinaryQuery.CONTAINS.equals(op)) {
                                throw new IllegalArgumentException("Operation ':' is nor supported for links");
                            }
                            Query newF = DoradusQueryBuilder.traverseTree(new Stack<String>(), first, new LinkIdVisitor(quantifier, fname));
                            if (parent1 != null) {
                                QueryUtils.SetInnerQuery(parent1, newF);
                                break;
                            }
                            second = newF;
                            break;
                        }
                    }
                    default: {
                        if (second instanceof TransitiveLinkQuery) {
                            throw new IllegalArgumentException("Error:" + fname + " is not a link");
                        }
                        if (quantifierDefined) {
                            Query mvs = DoradusQueryBuilder.traverseTree(new Stack<String>(), first, new MultiValueVisitor(quantifier, fname, op));
                            if (parent1 != null) {
                                QueryUtils.SetInnerQuery(parent1, mvs);
                                break;
                            }
                            if (second instanceof TransitiveLinkQuery) {
                                throw new IllegalArgumentException("Error:" + fname + " is not a link");
                            }
                            second = mvs;
                            break;
                        }
                        DoradusQueryBuilder.traverse(first, new FieldVisitor(fname, op));
                        if (parent1 != null) {
                            QueryUtils.SetInnerQuery(parent1, first);
                            break;
                        }
                        second = first;
                    }
                }
            }
        }
        builderContext.queries.push(second);
        return false;
    }

    private static void SetLinkQueryQuantifier(Query query, String value) {
        Query current = query;
        while (current != null && QueryUtils.HasInnerQuery(current)) {
            QueryUtils.SetLinkQuantifier(current, value);
            current = QueryUtils.GetInnerQuery(current);
        }
    }

    private static void assignFilter(Query query, Query filter) {
        if (query instanceof LinkCountQuery) {
            ((LinkCountQuery)query).filter = filter;
        } else if (query instanceof LinkQuery) {
            ((LinkQuery)query).filter = filter;
        } else if (query instanceof TransitiveLinkQuery) {
            ((TransitiveLinkQuery)query).filter = filter;
        } else if (query instanceof LinkCountRangeQuery) {
            ((LinkCountRangeQuery)query).filter = filter;
        } else {
            throw new IllegalArgumentException("Internal error: attempt to assign filter for query");
        }
    }

    private static Query getQuery(LinkItem item, String operation, BuilderContext context) {
        String op = operation;
        if (item.operation != null) {
            if (item.operation.equals("ANY")) {
                op = LinkQuery.ANY;
            }
            if (item.operation.equals("NONE")) {
                op = LinkQuery.NONE;
            }
            if (item.operation.equals("ALL")) {
                op = LinkQuery.ALL;
            }
            if (item.operation.equals("COUNT")) {
                op = item.operation;
            }
        }
        AndQuery andFilter = null;
        Query myFilter = null;
        if (item.filters != null) {
            int f = 0;
            while (f < item.filters.size()) {
                ArrayList<LinkItem> filter = item.filters.get(f);
                TableDefinition newDef = QueryUtils.GetTableDefinition(SearchQueryBuilder.getPath(item), context.definition);
                BuilderContext newContext = new BuilderContext(newDef);
                Query nextfilter = SearchQueryBuilder.build(filter, newContext);
                if (myFilter == null) {
                    myFilter = nextfilter;
                } else {
                    if (andFilter == null) {
                        andFilter = new AndQuery();
                        andFilter.subqueries.add(myFilter);
                    }
                    andFilter.subqueries.add(nextfilter);
                }
                ++f;
            }
        }
        Query result = null;
        if (item.item != null) {
            if (item.transitive != null && item.transitive.equals("^")) {
                TransitiveLinkQuery tq = new TransitiveLinkQuery(op, 0, item.item.getValue(), null);
                if (item.operation == null) {
                    tq.quantifier = LinkQuery.ANY;
                }
                if (item.value != null) {
                    int tValue;
                    tq.depth = tValue = Integer.parseInt(item.value.getValue());
                }
                result = tq;
            } else {
                result = op.equals("COUNT") ? new LinkQuery(op, item.item.getValue(), null) : (item.operation == null ? new LinkQuery(LinkQuery.ANY, item.item.getValue(), null) : new LinkQuery(op, item.item.getValue(), null));
                op = operation;
            }
        }
        if (result != null) {
            if (andFilter != null) {
                SearchQueryBuilder.assignFilter(result, andFilter);
            } else if (myFilter != null) {
                SearchQueryBuilder.assignFilter(result, myFilter);
            }
        }
        int k = 0;
        while (k < item.items.size()) {
            LinkItem lkitem = item.items.get(k);
            Query query = SearchQueryBuilder.getQuery(lkitem, op, context);
            if (result == null) {
                result = query;
            } else {
                Query last = QueryUtils.GetLastChild(result);
                QueryUtils.SetInnerQuery(last, query);
            }
            ++k;
        }
        return result;
    }

    private static ArrayList<String> getPath(LinkItem item) {
        ArrayList<String> result = new ArrayList<String>();
        if (item.item != null) {
            result.add(item.item.getValue());
        } else {
            int k = 0;
            while (k < item.items.size()) {
                ArrayList<String> nextPath = SearchQueryBuilder.getPath(item.items.get(k));
                result.addAll(nextPath);
                ++k;
            }
        }
        return result;
    }

    private static GrammarItem GetGrammarItem(LinkItem item) {
        if (item.transitive != null) {
            return null;
        }
        if (item.item != null && item.operation == null) {
            return item.item;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static Query build(ArrayList<LinkItem> items, BuilderContext builderContext) {
        i = 0;
        while (i < items.size()) {
            block11: {
                block12: {
                    block10: {
                        grammarItem = SearchQueryBuilder.GetGrammarItem(items.get(i));
                        if (grammarItem != null) break block10;
                        q = SearchQueryBuilder.getQuery(items.get(i), LinkQuery.ANY, builderContext);
                        builderContext.queries.push(q);
                        break block11;
                    }
                    if (!grammarItem.getType().equals("lexem") && !grammarItem.getType().equals("string")) break block12;
                    DoradusQueryBuilder.pushGrammarItem(builderContext, grammarItem);
                    break block11;
                }
                if (!grammarItem.getType().equals("semantic")) ** GOTO lbl-1000
                if (grammarItem.getValue().equals("(") || grammarItem.getValue().equals(")")) {
                    SearchQueryBuilder.pushOperation(builderContext, grammarItem.getValue());
                } else if (grammarItem.getValue().equals("SearchCriteriaStart")) {
                    SearchQueryBuilder.pushOperation(builderContext, "Criteria");
                } else if (grammarItem.getValue().equals("EOF")) {
                    SearchQueryBuilder.pushOperation(builderContext, grammarItem.getValue());
                } else if (grammarItem.getType().equals("token")) {
                    SearchQueryBuilder.pushOperation(builderContext, grammarItem.getValue());
                }
            }
            ++i;
        }
        while (!builderContext.operationEmpty()) {
            op = builderContext.operationPop();
            SearchQueryBuilder.DoOperation(op, builderContext);
        }
        query = builderContext.queries.pop();
        if (!builderContext.queries.empty()) {
            throw new IllegalArgumentException("Internal error: queries stack is not empty:" + builderContext.queries.pop());
        }
        query = DoradusQueryBuilder.traverseTree(new Stack<String>(), query, new LinkCheckVisitor(builderContext.definition));
        query = DoradusQueryBuilder.traverseTree(new Stack<String>(), query, new FieldNameVisitor());
        return query;
    }

    public static AndQuery CreateAndQuery(Query first, Query second) {
        AndQuery and = new AndQuery();
        and.subqueries.add(first);
        and.subqueries.add(second);
        return and;
    }

    public static OrQuery CreateOrQuery(Query first, Query second) {
        OrQuery and = new OrQuery();
        and.subqueries.add(first);
        and.subqueries.add(second);
        return and;
    }
}

